/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.develnext.jphp.core.compiler.jvm.statement.ClassStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.ClosureStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.FunctionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.MethodStmtCompiler;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.Tokenizer;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.value.ClosureStmtToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.YieldExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ArgumentStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DeclareStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;
import php.runtime.Memory;
import php.runtime.common.AbstractCompiler;
import php.runtime.common.Messages;
import php.runtime.common.Modifier;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.exceptions.CompileException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class JvmCompiler
extends AbstractCompiler {
    protected final ModuleEntity module;
    protected NamespaceStmtToken namespace;
    protected List<DeclareStmtToken> declareStmtTokens = new ArrayList<DeclareStmtToken>();
    private List<ClassStmtCompiler> classes = new ArrayList<ClassStmtCompiler>();
    private Map<String, ConstantEntity> constants = new LinkedHashMap<String, ConstantEntity>();
    private Map<String, FunctionEntity> functions = new LinkedHashMap<String, FunctionEntity>();
    protected final SyntaxAnalyzer analyzer;
    protected final List<Token> tokens;
    protected YieldExprToken lastYield;

    public JvmCompiler(Environment environment, Context context) throws IOException {
        this(environment, context, new SyntaxAnalyzer(environment, new Tokenizer(context)));
    }

    public JvmCompiler(Environment environment, Context context, SyntaxAnalyzer analyzer) {
        super(environment, context);
        this.classes = new ArrayList<ClassStmtCompiler>();
        this.module = new ModuleEntity(context);
        this.module.setId(this.scope.nextModuleIndex());
        this.tokens = analyzer.getTree();
        this.analyzer = analyzer;
    }

    public SyntaxAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public ConstantEntity findConstant(String fullName) {
        return this.constants.get(fullName.toLowerCase());
    }

    public FunctionEntity findFunction(String name) {
        return this.functions.get(name.toLowerCase());
    }

    public NamespaceStmtToken getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceStmtToken namespace) {
        this.namespace = namespace;
    }

    public YieldExprToken getLastYield() {
        return this.lastYield;
    }

    public void setLastYield(YieldExprToken lastYield) {
        this.lastYield = lastYield;
    }

    public ClassEntity compileClass(ClassStmtToken clazz, boolean external) {
        ClassStmtCompiler cmp = new ClassStmtCompiler(this, clazz);
        cmp.setExternal(external);
        return cmp.compile();
    }

    public ClassEntity compileClass(ClassStmtToken clazz) {
        return this.compileClass(clazz, false);
    }

    public FunctionEntity compileFunction(FunctionStmtToken function) {
        FunctionStmtCompiler cmp = new FunctionStmtCompiler(this, function);
        return cmp.compile();
    }

    public List<ConstantEntity> compileConstant(ConstStmtToken constant) {
        ArrayList<ConstantEntity> result = new ArrayList<ConstantEntity>();
        for (ConstStmtToken.Item el : constant.items) {
            ConstantEntity constantEntity = new ConstantEntity(this.getContext());
            constantEntity.setName(el.getFulledName());
            constantEntity.setModule(this.module);
            constantEntity.setTrace(el.name.toTraceInfo(this.context));
            ExpressionStmtCompiler expressionStmtCompiler = new ExpressionStmtCompiler(this);
            Memory memory = expressionStmtCompiler.writeExpression(el.value, true, true, false);
            if (memory == null) {
                throw new CompileException(Messages.ERR_EXPECTED_CONST_VALUE.fetch(el.getFulledName()), constant.toTraceInfo(this.context));
            }
            constantEntity.setValue(memory);
            result.add(constantEntity);
        }
        return result;
    }

    public MethodEntity compileMethod(ClassStmtCompiler clazzCompiler, MethodStmtToken method, boolean external, GeneratorEntity generatorEntity) {
        MethodStmtCompiler compiler = new MethodStmtCompiler(clazzCompiler, method);
        compiler.setExternal(external);
        compiler.setGeneratorEntity(generatorEntity);
        clazzCompiler.node.methods.add(compiler.node);
        return compiler.compile();
    }

    public MethodEntity compileMethod(ClassStmtCompiler clazzCompiler, MethodStmtToken method) {
        return this.compileMethod(clazzCompiler, method, false, null);
    }

    public void compileExpression(MethodStmtCompiler method, ExprStmtToken expression) {
        new ExpressionStmtCompiler(method, expression).compile();
    }

    public List<ExprStmtToken> process(List<Token> tokens, NamespaceStmtToken namespace) {
        FunctionEntity entity;
        ArrayList<ExprStmtToken> externalCode = new ArrayList<ExprStmtToken>();
        for (ConstStmtToken constant : this.analyzer.getConstants()) {
            List<ConstantEntity> items = this.compileConstant(constant);
            for (ConstantEntity el : items) {
                if (!this.constants.containsKey(el.getLowerName())) {
                    this.module.addConstant(el);
                    if (this.scope.findUserConstant(el.getName()) != null) {
                        this.environment.error(el.getTrace(), ErrorType.E_ERROR, Messages.ERR_CANNOT_REDECLARE_CONSTANT, el.getName());
                    }
                    this.constants.put(el.getLowerName(), el);
                    continue;
                }
                this.environment.error(el.getTrace(), ErrorType.E_ERROR, Messages.ERR_CANNOT_REDECLARE_CONSTANT, el.getName());
            }
        }
        for (ClosureStmtToken closure : this.analyzer.getClosures()) {
            ClosureEntity closureEntity = new ClosureStmtCompiler(this, closure).compile();
            this.module.addClosure(closureEntity);
        }
        for (FunctionStmtToken function : this.analyzer.getFunctions()) {
            if (function.isStatic()) continue;
            entity = this.compileFunction(function);
            entity.setStatic(function.isStatic());
            this.module.addFunction(entity);
        }
        for (Token token : tokens) {
            if (token instanceof NamespaceStmtToken) {
                this.setNamespace((NamespaceStmtToken)token);
            }
            if (token instanceof DeclareStmtToken) {
                this.declareStmtTokens.add((DeclareStmtToken)token);
            }
            if (token instanceof ClassStmtToken) {
                ClassStmtCompiler cmp = new ClassStmtCompiler(this, (ClassStmtToken)token);
                ClassEntity entity2 = cmp.compile();
                entity2.setStatic(true);
                this.module.addClass(entity2);
                if (!cmp.isInitDynamicExists()) continue;
                externalCode.add(new ExprStmtToken(this.getEnvironment(), this.getContext(), new ClassInitEnvironment((ClassStmtToken)token, entity2)));
                continue;
            }
            if (token instanceof FunctionStmtToken) {
                entity = this.compileFunction((FunctionStmtToken)token);
                entity.setStatic(true);
                this.module.addFunction(entity);
                this.functions.put(entity.getLowerName(), entity);
                continue;
            }
            if (token instanceof ExprStmtToken) {
                externalCode.add((ExprStmtToken)token);
                continue;
            }
            externalCode.add(new ExprStmtToken(this.getEnvironment(), this.getContext(), token));
        }
        return externalCode;
    }

    @Override
    public ModuleEntity compile(boolean autoRegister) {
        this.classes = new ArrayList<ClassStmtCompiler>();
        this.module.setInternalName("$php_module_m" + UUID.randomUUID().toString().replace("-", ""));
        List<ExprStmtToken> externalCode = this.process(this.tokens, NamespaceStmtToken.getDefault());
        block6: for (DeclareStmtToken declare : this.declareStmtTokens) {
            String name = declare.getName().getName();
            ExpressionStmtCompiler expressionStmtCompiler = new ExpressionStmtCompiler(this);
            Memory value = expressionStmtCompiler.tryCalculateExpression(declare.getValue());
            switch (name.toLowerCase()) {
                case "strict_types": {
                    this.module.setStrictTypes(value.toBoolean());
                    continue block6;
                }
            }
            this.environment.error(declare.getValue().getMeta().toTraceInfo(this.context), ErrorType.E_ERROR, Messages.ERR_INVALID_DECLARE_CONSTANT, name);
        }
        NamespaceStmtToken namespace = NamespaceStmtToken.getDefault();
        ClassStmtToken token = new ClassStmtToken(TokenMeta.of(this.module.getName()));
        token.setFinal(true);
        token.setName(new NameToken(TokenMeta.of(this.module.getInternalName())));
        token.setNamespace(namespace);
        MethodStmtToken methodToken = new MethodStmtToken(token.getMeta());
        methodToken.setFinal(true);
        methodToken.setClazz(token);
        methodToken.setModifier(Modifier.PUBLIC);
        methodToken.setStatic(true);
        methodToken.setDynamicLocal(true);
        methodToken.setName((NameToken)Token.of("__include"));
        methodToken.setArguments(new ArrayList<ArgumentStmtToken>());
        methodToken.setLocal(this.analyzer.getScope().getVariables());
        methodToken.setLabels(this.analyzer.getScope().getLabels());
        methodToken.setBody(BodyStmtToken.of(externalCode));
        token.setMethods(Arrays.asList(methodToken));
        ClassStmtCompiler classStmtCompiler = new ClassStmtCompiler(this, token);
        classStmtCompiler.setExternal(true);
        classStmtCompiler.setSystem(true);
        this.module.setData(classStmtCompiler.compile().getData());
        if (autoRegister) {
            this.scope.addUserModule(this.module);
        }
        return this.module;
    }

    public ModuleEntity getModule() {
        return this.module;
    }

    public List<ClassStmtCompiler> getClasses() {
        return this.classes;
    }

    public String getSourceFile() {
        return this.context.getFileName();
    }

    public class ClassInitEnvironment
    extends StmtToken {
        protected final ClassStmtToken token;
        protected final ClassEntity entity;

        public ClassInitEnvironment(ClassStmtToken token, ClassEntity clazz) {
            super(token.getMeta(), TokenType.T_J_CUSTOM);
            this.token = token;
            this.entity = clazz;
        }

        public ClassStmtToken getToken() {
            return this.token;
        }

        public ClassEntity getEntity() {
            return this.entity;
        }
    }
}

