/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement;

import java.util.Arrays;
import org.develnext.jphp.core.compiler.jvm.JvmCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.ClassStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.StmtCompiler;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import php.runtime.common.Modifier;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.support.TypeChecker;

public class FunctionStmtCompiler
extends StmtCompiler<FunctionEntity> {
    protected FunctionStmtToken statement;

    public FunctionStmtCompiler(JvmCompiler compiler, FunctionStmtToken statement) {
        super(compiler);
        this.statement = statement;
    }

    @Override
    public FunctionEntity compile() {
        ModuleEntity module = this.compiler.getModule();
        FunctionEntity entity = new FunctionEntity(this.compiler.getContext());
        entity.setModule(module);
        entity.setName(this.statement.getFulledName());
        entity.setReturnReference(this.statement.isReturnReference());
        if (this.statement.getReturnHintTypeClass() != null) {
            entity.setReturnTypeChecker(TypeChecker.of(this.statement.getReturnHintTypeClass().getName()));
        } else if (this.statement.getReturnHintType() != null) {
            entity.setReturnTypeChecker(TypeChecker.of(this.statement.getReturnHintType()));
        }
        entity.setInternalName(this.compiler.getModule().getInternalName() + "_func" + this.statement.getId());
        entity.setTrace(this.statement.toTraceInfo(this.compiler.getContext()));
        if (this.statement.getDocComment() != null) {
            entity.setDocComment(new DocumentComment(this.statement.getDocComment().getComment()));
        }
        NamespaceStmtToken namespace = NamespaceStmtToken.getDefault();
        ClassStmtToken token = new ClassStmtToken(this.statement.getMeta());
        token.setFinal(true);
        token.setNamespace(namespace);
        token.setName(new NameToken(TokenMeta.of(entity.getInternalName())));
        MethodStmtToken methodToken = new MethodStmtToken(this.statement);
        methodToken.setClazz(token);
        methodToken.setFinal(true);
        methodToken.setStatic(true);
        methodToken.setReturnReference(entity.isReturnReference());
        methodToken.setModifier(Modifier.PUBLIC);
        methodToken.setName(new NameToken(TokenMeta.of("__invoke")));
        token.setMethods(Arrays.asList(methodToken));
        ClassStmtCompiler classStmtCompiler = new ClassStmtCompiler(this.compiler, token);
        classStmtCompiler.setSystem(true);
        classStmtCompiler.setFunctionName(entity.getName());
        ClassEntity clazzEntity = classStmtCompiler.compile();
        clazzEntity.setType(ClassEntity.Type.FUNCTION);
        entity.setData(clazzEntity.getData());
        MethodEntity methodEntity = clazzEntity.findMethod("__invoke");
        entity.setParameters(methodEntity.getParameters());
        entity.setEmpty(methodEntity.isEmpty());
        entity.setUsesStackTrace(methodEntity.isUsesStackTrace());
        entity.setImmutable(methodEntity.isImmutable());
        entity.setResult(methodEntity.getResult());
        entity.setGeneratorEntity(methodEntity.getGeneratorEntity());
        return entity;
    }
}

