/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.stmt;

import java.util.Arrays;
import java.util.List;
import org.develnext.jphp.core.compiler.common.ASMExpression;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.stmt.GotoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.LabelStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;
import php.runtime.env.Context;
import php.runtime.env.Environment;

public class ExprStmtToken
extends StmtToken {
    private List<Token> tokens;
    private ExprStmtToken asmExpr;
    private boolean isStmtList = true;
    private boolean constantly = true;

    protected ExprStmtToken(TokenMeta meta) {
        super(meta, TokenType.T_J_CUSTOM);
    }

    public ExprStmtToken(Environment env, Context context, List<Token> tokens) {
        this(TokenMeta.of(tokens));
        this.setTokens(tokens);
        if (!this.isStmtList() && env != null && context != null) {
            this.updateAsmExpr(env, context);
        }
    }

    public ExprStmtToken(Environment env, Context context, Token ... tokens) {
        this(env, context, Arrays.asList(tokens));
    }

    public void updateAsmExpr(Environment env, Context context) {
        if (!this.isStmtList()) {
            this.setAsmExpr(new ASMExpression(env, context, this).getResult());
        }
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> tokens) {
        for (Token el : tokens) {
            if (el == null) continue;
            if (!(el instanceof StmtToken)) {
                this.isStmtList = false;
                break;
            }
            if (!(el instanceof GotoStmtToken) && !(el instanceof LabelStmtToken)) continue;
            this.constantly = false;
        }
        this.tokens = tokens;
    }

    public boolean isSingle() {
        return this.tokens.size() == 1;
    }

    public Token getSingle() {
        return this.tokens.get(0);
    }

    public Token getLast() {
        if (this.tokens.size() == 0) {
            return null;
        }
        return this.tokens.get(this.tokens.size() - 1);
    }

    public boolean isStmtList() {
        return this.isStmtList;
    }

    public boolean isConstantly() {
        return this.constantly;
    }

    public ExprStmtToken getAsmExpr() {
        return this.asmExpr;
    }

    public void setAsmExpr(ExprStmtToken asmExpr) {
        this.asmExpr = asmExpr;
    }
}

