/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.develnext.jphp.ext.javafx.classes.UXControl;
import org.develnext.jphp.ext.javafx.classes.UXListCell;
import org.develnext.jphp.ext.javafx.support.control.ListViewEx;
import php.runtime.annotation.Reflection;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXListView")
public class UXListView
extends UXControl<ListView> {
    public UXListView(Environment env, ListView wrappedObject) {
        super(env, wrappedObject);
    }

    public UXListView(Environment env, ListViewEx wrappedObject) {
        super(env, wrappedObject);
    }

    public UXListView(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new ListViewEx();
    }

    @Reflection.Signature
    public void scrollTo(int index) {
        ((ListView)this.getWrappedObject()).scrollTo(index);
    }

    @Reflection.Getter
    public boolean getMultipleSelection() {
        return ((ListView)this.getWrappedObject()).getSelectionModel().getSelectionMode() == SelectionMode.MULTIPLE;
    }

    @Reflection.Setter
    public void setMultipleSelection(boolean value) {
        ((ListView)this.getWrappedObject()).getSelectionModel().setSelectionMode(value ? SelectionMode.MULTIPLE : SelectionMode.SINGLE);
    }

    @Reflection.Getter
    public List<Integer> getSelectedIndexes() {
        return ((ListView)this.getWrappedObject()).getSelectionModel().getSelectedIndices();
    }

    @Reflection.Setter
    public void setSelectedIndexes(int[] indexes) {
        MultipleSelectionModel selectionModel = ((ListView)this.getWrappedObject()).getSelectionModel();
        selectionModel.clearSelection();
        for (int index : indexes) {
            selectionModel.select(index);
        }
    }

    @Reflection.Getter
    public int getSelectedIndex() {
        return ((ListView)this.getWrappedObject()).getSelectionModel().getSelectedIndex();
    }

    @Reflection.Setter
    public void setSelectedIndex(int index) {
        MultipleSelectionModel selectionModel = ((ListView)this.getWrappedObject()).getSelectionModel();
        selectionModel.clearSelection();
        selectionModel.select(index);
    }

    @Reflection.Getter
    public Object getFocusedItem() {
        return ((ListView)this.getWrappedObject()).getFocusModel().getFocusedItem();
    }

    @Reflection.Getter
    public List<Object> getSelectedItems() {
        return ((ListView)this.getWrappedObject()).getSelectionModel().getSelectedItems();
    }

    @Reflection.Getter
    public Object getSelectedItem() {
        ObservableList selectedItems = ((ListView)this.getWrappedObject()).getSelectionModel().getSelectedItems();
        return selectedItems.isEmpty() ? null : selectedItems.get(0);
    }

    @Reflection.Getter
    public Object getFocusedIndex() {
        return ((ListView)this.getWrappedObject()).getFocusModel().getFocusedIndex();
    }

    @Reflection.Setter
    public void setFocusedIndex(int index) {
        ((ListView)this.getWrappedObject()).getFocusModel().focus(index);
    }

    @Reflection.Signature
    public void setCellFactory(final Environment env, final @Reflection.Nullable Invoker invoker) {
        if (invoker == null) {
            ((ListView)this.getWrappedObject()).setCellFactory(null);
            return;
        }
        ((ListView)this.getWrappedObject()).setCellFactory((Callback)new Callback<ListView, ListCell>(){

            public ListCell call(ListView param) {
                return new ListCell(){

                    protected void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            invoker.callAny(new UXListCell(env, this), item, empty);
                        }
                    }
                };
            }
        });
    }

    @Reflection.Signature
    public void setDraggableCellFactory(final Environment env, final @Reflection.Nullable Invoker invoker, final @Reflection.Nullable Invoker dragDone) {
        if (invoker == null) {
            ((ListView)this.getWrappedObject()).setCellFactory(null);
            return;
        }
        ((ListView)this.getWrappedObject()).setCellFactory((Callback)new Callback<ListView, ListCell>(){

            public ListCell call(ListView param) {
                return new DragListCell(dragDone){

                    protected void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            invoker.callAny(new UXListCell(env, this), item, empty);
                        }
                    }
                };
            }
        });
    }

    @Reflection.Signature
    public void update() {
        ObservableList items = ((ListView)this.getWrappedObject()).getItems();
        ((ListView)this.getWrappedObject()).setItems(null);
        ((ListView)this.getWrappedObject()).setItems(items);
    }

    @Reflection.Getter
    protected String getItemsText() {
        return StringUtils.join(((ListView)this.getWrappedObject()).getItems(), "\n");
    }

    @Reflection.Setter
    protected void setItemsText(String value) {
        Scanner scanner = new Scanner(value);
        ((ListView)this.getWrappedObject()).getItems().clear();
        while (scanner.hasNextLine()) {
            ((ListView)this.getWrappedObject()).getItems().add((Object)scanner.nextLine());
        }
    }

    static class DragListCell
    extends ListCell {
        private final ImageView imageView = new ImageView();
        private final Invoker dragDone;

        public DragListCell(final Invoker dragDone) {
            this.dragDone = dragDone;
            final DragListCell thisCell = this;
            this.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (this.getItem() == null) {
                        return;
                    }
                    Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    ClipboardContent content = new ClipboardContent();
                    content.putString(String.valueOf(this.getListView().getSelectionModel().getSelectedIndex()));
                    dragboard.setContent((Map)content);
                    SnapshotParameters snapParams = new SnapshotParameters();
                    snapParams.setFill((Paint)Color.TRANSPARENT);
                    if (this.getGraphic() != null) {
                        imageView.setImage((Image)this.getGraphic().snapshot(snapParams, null));
                    } else {
                        imageView.setImage((Image)this.snapshot(snapParams, null));
                    }
                    imageView.setStyle("-fx-border-color: silver; -fx-border-width: 1px;");
                    event.consume();
                }
            });
            this.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                        event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    }
                    event.consume();
                }
            });
            this.setOnDragEntered((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                        this.setOpacity(0.3);
                    }
                }
            });
            this.setOnDragExited((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                        this.setOpacity(1.0);
                    }
                }
            });
            this.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    if (this.getItem() == null) {
                        dragDone.callAny(event, this.getListView(), -1);
                        return;
                    }
                    Dragboard db = event.getDragboard();
                    boolean success = false;
                    if (db.hasString()) {
                        ObservableList items = this.getListView().getItems();
                        int thisIdx = items.indexOf(this.getItem());
                        if (dragDone != null) {
                            dragDone.callAny(event, this.getListView(), thisIdx);
                        } else {
                            int draggedIdx = Integer.parseInt(db.getString());
                            Object dragged = this.getListView().getItems().get(draggedIdx);
                            if (thisIdx < draggedIdx) {
                                items.add(thisIdx, dragged);
                                items.remove(++draggedIdx);
                            } else {
                                items.add(thisIdx + 1, dragged);
                                items.remove(draggedIdx);
                            }
                            ArrayList itemscopy = new ArrayList(this.getListView().getItems());
                            this.getListView().getItems().setAll(itemscopy);
                        }
                        success = true;
                    }
                    event.setDropCompleted(success);
                    event.consume();
                }
            });
            this.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    dragEvent.consume();
                }
            });
        }
    }

    static interface WrappedInterface {
        @Reflection.Property
        public boolean editable();

        @Reflection.Property
        public double fixedCellSize();

        @Reflection.Property
        @Reflection.Nullable
        public Node placeholder();

        @Reflection.Property
        public Orientation orientation();

        @Reflection.Property
        public ObservableList items();

        @Reflection.Property
        public int editingIndex();
    }
}

