/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.develnext.jphp.ext.javafx.classes.UXNode;
import org.develnext.jphp.ext.javafx.support.EventProvider;
import org.develnext.jphp.ext.javafx.support.JavaFxUtils;
import org.develnext.jphp.ext.javafx.support.UserData;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="php\\gui\\UXWindow")
public class UXWindow<T extends Window>
extends BaseWrapper<Window> {
    public UXWindow(Environment env, T wrappedObject) {
        super(env, wrappedObject);
    }

    public UXWindow(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    public T getWrappedObject() {
        return (T)((Window)super.getWrappedObject());
    }

    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new Stage();
    }

    @Reflection.Signature
    public void __construct(Stage stage) {
        this.__wrappedObject = stage;
    }

    @Reflection.Getter
    public Memory getUserData(Environment env) {
        Object userData = this.getWrappedObject().getUserData();
        if (userData == null) {
            return null;
        }
        if (userData instanceof UserData) {
            return ((UserData)userData).getValue();
        }
        return Memory.wrap(env, userData);
    }

    @Reflection.Setter
    public void setUserData(Environment env, @Reflection.Nullable Object value) {
        Object userData = this.getWrappedObject().getUserData();
        if (userData instanceof UserData) {
            ((UserData)userData).setValue(Memory.wrap(env, value));
        } else {
            this.getWrappedObject().setUserData(value);
        }
    }

    @Reflection.Signature
    public Memory data(String name) {
        return JavaFxUtils.data(this.getWrappedObject(), name);
    }

    @Reflection.Signature
    public Memory data(Environment env, String name, Memory value) {
        return JavaFxUtils.data(env, this.getWrappedObject(), name, value);
    }

    @Reflection.Getter
    protected Cursor getCursor() {
        return this.getWrappedObject().getScene().getCursor();
    }

    @Reflection.Setter
    protected void setCursor(Cursor cursor) {
        this.getWrappedObject().getScene().setCursor(cursor);
    }

    @Reflection.Getter
    protected double[] getSize() {
        return new double[]{this.getWrappedObject().getWidth(), this.getWrappedObject().getHeight()};
    }

    @Reflection.Setter
    protected void setSize(double[] size) {
        if (size.length >= 2) {
            this.getWrappedObject().setWidth(size[0]);
            this.getWrappedObject().setHeight(size[1]);
        }
    }

    @Reflection.Getter
    public Parent getLayout(Environment env) {
        Memory data = this.data("~~virtual-layout");
        if (data.isNotNull()) {
            return (Parent)Memory.unwrap(env, data);
        }
        return this.getWrappedObject().getScene() == null ? null : this.getWrappedObject().getScene().getRoot();
    }

    @Reflection.Setter
    public void setLayout(Environment env, Parent pane) {
        if (this.getWrappedObject().getScene() == null) {
            throw new IllegalStateException("Unable to set layout");
        }
        this.getWrappedObject().getScene().setRoot(pane);
        this.getWrappedObject().sizeToScene();
        this.data(env, "~~virtual-layout", Memory.NULL);
    }

    @Reflection.Signature
    public void makeVirtualLayout(Environment env) {
        Parent layout = this.getLayout(env);
        this.data(env, "~~virtual-layout", Memory.wrap(env, layout));
        this.getWrappedObject().getScene().setRoot((Parent)new AnchorPane());
    }

    @Reflection.Getter
    public ObservableList<Node> getChildren(Environment env) {
        Parent root = this.getLayout(env);
        if (root instanceof Pane) {
            return ((Pane)root).getChildren();
        }
        if (root instanceof SplitPane) {
            return ((SplitPane)root).getItems();
        }
        return FXCollections.emptyObservableList();
    }

    @Reflection.Signature
    public void add(Environment env, Node node) {
        ObservableList<Node> children = this.getChildren(env);
        if (children == null) {
            throw new IllegalStateException("Unable to add node");
        }
        children.add((Object)node);
    }

    @Reflection.Signature
    public boolean remove(Environment env, Node node) {
        ObservableList<Node> children = this.getChildren(env);
        if (children != null) {
            return children.remove((Object)node);
        }
        throw new IllegalStateException("Unable to remove node");
    }

    @Reflection.Signature
    public boolean hasStylesheet(String path) {
        return this.getWrappedObject().getScene().getStylesheets().contains((Object)path);
    }

    @Reflection.Signature
    public void addStylesheet(String path) {
        this.getWrappedObject().getScene().getStylesheets().add((Object)path);
    }

    @Reflection.Signature
    public void removeStylesheet(String path) {
        this.getWrappedObject().getScene().getStylesheets().remove((Object)path);
    }

    @Reflection.Signature
    public void clearStylesheets() {
        this.getWrappedObject().getScene().getStylesheets().clear();
    }

    @Reflection.Signature
    public void addEventFilter(final Environment env, String event, final Invoker invoker) {
        EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                try {
                    invoker.callAny(event);
                }
                catch (Throwable throwable) {
                    env.wrapThrow(throwable);
                }
            }
        };
        EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                try {
                    invoker.callAny(event);
                }
                catch (Throwable throwable) {
                    env.wrapThrow(throwable);
                }
            }
        };
        switch (event) {
            case "mouseMove": {
                this.getWrappedObject().getScene().addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)mouseHandler);
                break;
            }
            case "mouseDrag": {
                this.getWrappedObject().getScene().addEventFilter(MouseEvent.MOUSE_DRAGGED, (EventHandler)mouseHandler);
                break;
            }
            case "mouseDown": {
                this.getWrappedObject().getScene().addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)mouseHandler);
                break;
            }
            case "mouseUp": {
                this.getWrappedObject().getScene().addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)mouseHandler);
                break;
            }
            case "click": {
                this.getWrappedObject().getScene().addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)mouseHandler);
                break;
            }
            case "keyDown": {
                this.getWrappedObject().getScene().addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)keyHandler);
                break;
            }
            case "keyUp": {
                this.getWrappedObject().getScene().addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)keyHandler);
                break;
            }
            case "keyPress": {
                this.getWrappedObject().getScene().addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)keyHandler);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Reflection.Signature
    public void on(String event, Invoker invoker, String group, Environment env) {
        Object target = this.getWrappedObject();
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            target = this.getLayout(env);
            eventProvider = EventProvider.get(target, event);
        }
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.on(target, event, group, invoker);
    }

    @Reflection.Signature
    public void on(String event, Invoker invoker, Environment env) {
        this.on(event, invoker, "general", env);
    }

    @Reflection.Signature
    public void off(Environment env, String event, @Reflection.Nullable String group) {
        Object target = this.getWrappedObject();
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            target = this.getLayout(env);
            eventProvider = EventProvider.get(target, event);
        }
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.off(target, event, group);
    }

    @Reflection.Signature
    public void off(Environment env, String event) {
        this.off(env, event, null);
    }

    @Reflection.Signature
    public void trigger(Environment env, String event, @Reflection.Nullable Event e) {
        Object target = this.getWrappedObject();
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            target = this.getLayout(env);
            eventProvider = EventProvider.get(target, event);
        }
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.trigger(target, event, e);
    }

    @Reflection.Signature
    public ObservableValue observer(String property) {
        return JavaFxUtils.findObservable(this.getWrappedObject(), property);
    }

    @Reflection.Signature
    public void watch(final String property, final Invoker invoker) throws InvocationTargetException, IllegalAccessException {
        String name = property + "Property";
        Class<?> aClass = this.getWrappedObject().getClass();
        try {
            Method method = aClass.getMethod(name, new Class[0]);
            ReadOnlyProperty bindProperty = (ReadOnlyProperty)method.invoke(this.getWrappedObject(), new Object[0]);
            bindProperty.addListener(new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    invoker.callAny(UXWindow.this, property, oldValue, newValue);
                }
            });
        }
        catch (ClassCastException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to find the '" + property + "' property for watching");
        }
    }

    @Reflection.Signature
    public Memory __get(Environment env, String name) throws NoSuchFieldException, IllegalAccessException {
        Memory prop = this.data("--property-" + name);
        if (prop.isNotNull()) {
            return prop;
        }
        Node node = UXNode.__globalLookup((Node)this.getLayout(env), "#" + name);
        return Memory.wrap(env, node);
    }

    @Reflection.Signature
    public boolean __isset(Environment env, String name) {
        return UXNode.__globalLookup((Node)this.getLayout(env), "#" + name) != null;
    }

    static interface WrappedInterface {
        @Reflection.Property
        public double x();

        @Reflection.Property
        public double y();

        @Reflection.Property
        public double height();

        @Reflection.Property
        public double width();

        @Reflection.Property
        public double opacity();

        @Reflection.Property
        public boolean focused();

        @Reflection.Property(value="visible")
        public boolean showing();

        public void hide();

        public void sizeToScene();

        public void centerOnScreen();

        public void requestFocus();
    }
}

