/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.jfoenix.classes;

import com.jfoenix.controls.JFXTimePicker;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import org.develnext.jphp.ext.javafx.classes.UXComboBoxBase;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Namespace(value="php\\gui")
public class UXMaterialTimePicker
extends UXComboBoxBase<JFXTimePicker> {
    public UXMaterialTimePicker(Environment env, JFXTimePicker wrappedObject) {
        super(env, wrappedObject);
    }

    public UXMaterialTimePicker(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new JFXTimePicker();
    }

    @Reflection.Setter
    public void setFormat(String value) {
        ((JFXTimePicker)((Object)this.getWrappedObject())).setConverter(new CustomConverter(value));
    }

    @Reflection.Getter
    public String getFormat() {
        this.initFormat();
        StringConverter<LocalTime> converter = ((JFXTimePicker)((Object)this.getWrappedObject())).getConverter();
        if (converter instanceof CustomConverter) {
            return ((CustomConverter)converter).format;
        }
        return null;
    }

    private void initFormat() {
        if (((JFXTimePicker)((Object)this.getWrappedObject())).getConverter() == null) {
            ((JFXTimePicker)((Object)this.getWrappedObject())).setConverter(new CustomConverter("HH:mm"));
        }
    }

    @Reflection.Getter
    public WrapTime getValueAsTime(Environment env) {
        this.initFormat();
        LocalTime value = (LocalTime)((JFXTimePicker)((Object)this.getWrappedObject())).getValue();
        if (value == null) {
            return null;
        }
        Instant instant = value.atDate(LocalDate.of(0, 0, 0)).atZone(ZoneId.systemDefault()).toInstant();
        return new WrapTime(env, Date.from(instant));
    }

    @Reflection.Setter
    public void setValueAsTime(Environment env, @Reflection.Nullable WrapTime time) {
        this.initFormat();
        if (time == null) {
            ((JFXTimePicker)((Object)this.getWrappedObject())).setValue(null);
        } else {
            ((JFXTimePicker)((Object)this.getWrappedObject())).setValue(Instant.ofEpochMilli(time.getDate().getTime()).atZone(ZoneId.systemDefault()).toLocalTime());
        }
    }

    @Reflection.Getter
    public Color getDefaultColor() {
        return (Color)((JFXTimePicker)((Object)this.getWrappedObject())).getDefaultColor();
    }

    @Reflection.Setter
    public void setDefaultColor(@Reflection.Nullable Color color) {
        ((JFXTimePicker)((Object)this.getWrappedObject())).setDefaultColor((Paint)color);
    }

    @Reflection.Getter
    public boolean getHourView24() {
        return ((JFXTimePicker)((Object)this.getWrappedObject())).is24HourView();
    }

    @Reflection.Setter
    public void setHourView24(boolean value) {
        ((JFXTimePicker)((Object)this.getWrappedObject())).setIs24HourView(value);
    }

    @Override
    protected Memory getValue(Environment env) {
        this.initFormat();
        if (((JFXTimePicker)((Object)this.getWrappedObject())).getConverter() == null) {
            return StringMemory.valueOf(((LocalTime)((JFXTimePicker)((Object)this.getWrappedObject())).getValue()).toString());
        }
        return StringMemory.valueOf(((JFXTimePicker)((Object)this.getWrappedObject())).getConverter().toString(((JFXTimePicker)((Object)this.getWrappedObject())).getValue()));
    }

    @Override
    @Reflection.Signature
    protected void setValue(Environment env, Memory value) {
        this.initFormat();
        if (value.toString().isEmpty()) {
            ((JFXTimePicker)((Object)this.getWrappedObject())).setValue(null);
        } else {
            try {
                if (((JFXTimePicker)((Object)this.getWrappedObject())).getConverter() != null) {
                    ((JFXTimePicker)((Object)this.getWrappedObject())).setValue(((JFXTimePicker)((Object)this.getWrappedObject())).getConverter().fromString(value.toString()));
                } else {
                    ((JFXTimePicker)((Object)this.getWrappedObject())).setValue(LocalTime.parse(value.toString()));
                }
            }
            catch (DateTimeParseException e) {
                ((JFXTimePicker)((Object)this.getWrappedObject())).setValue(null);
            }
        }
    }

    static class CustomConverter
    extends StringConverter<LocalTime> {
        private final DateTimeFormatter dateTimeFormatter;
        protected final String format;

        CustomConverter(String format) {
            this.format = format;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        }

        public String toString(LocalTime localDate) {
            if (localDate == null) {
                return "";
            }
            return this.dateTimeFormatter.format(localDate);
        }

        public LocalTime fromString(String dateString) {
            if (dateString == null || dateString.trim().isEmpty()) {
                return null;
            }
            return LocalTime.parse(dateString, this.dateTimeFormatter);
        }
    }

    static interface WrappedInterface {
        @Reflection.Property(value="overlay")
        public boolean overLay();
    }
}

