/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.io.StringWriter;
import php.runtime.Memory;
import php.runtime.env.TraceInfo;
import php.runtime.lang.Closure;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.output.PlainPrinter;
import php.runtime.reflection.ClassEntity;

public class CallStackItem {
    public TraceInfo trace;
    public IObject object;
    public Memory[] args;
    public String function;
    public String clazz;
    public String staticClazz;
    public ClassEntity classEntity;
    public ClassEntity staticClassEntity;
    public int flags;

    public CallStackItem(TraceInfo trace) {
        this.trace = trace;
    }

    public CallStackItem(CallStackItem copy) {
        this.trace = copy.trace;
        this.object = copy.object;
        this.args = copy.args;
        this.function = copy.function;
        this.clazz = copy.clazz;
        this.staticClazz = copy.staticClazz;
    }

    public CallStackItem(TraceInfo trace, IObject object, Memory[] args, String function, String clazz, String staticClazz) {
        this.trace = trace;
        this.object = object;
        this.args = args;
        this.function = function;
        this.clazz = clazz;
        this.staticClazz = staticClazz;
    }

    public TraceInfo getTrace() {
        return this.trace;
    }

    public void setTrace(TraceInfo trace) {
        this.trace = trace;
    }

    public void setParameters(TraceInfo trace, IObject object, Memory[] args, String function, String clazz, String staticClazz) {
        this.trace = trace;
        this.object = object;
        this.args = args;
        this.function = function;
        this.clazz = clazz;
        this.staticClazz = staticClazz;
        this.classEntity = null;
        this.staticClassEntity = null;
    }

    public void clear() {
        this.object = null;
        this.args = null;
        this.flags = 0;
    }

    public String toString() {
        return this.toString(false);
    }

    public ArrayMemory toArray() {
        return this.toArray(true, false);
    }

    public ArrayMemory toArray(boolean provideObject, boolean ignoreArgs) {
        ArrayMemory el = new ArrayMemory();
        if (this.trace != null) {
            if (this.trace.getFile() != null) {
                el.refOfIndex("file").assign(this.trace.getFileName());
            }
            el.refOfIndex("line").assign(this.trace.getStartLine() + 1);
        }
        el.refOfIndex("function").assign(this.function);
        if (this.clazz != null) {
            el.refOfIndex("class").assign(this.clazz);
            el.refOfIndex("type").assign("::");
        }
        if (this.object != null) {
            if (provideObject) {
                el.refOfIndex("object").assign(new ObjectMemory(this.object));
            }
            el.refOfIndex("type").assign("->");
        }
        if (!ignoreArgs) {
            el.refOfIndex("args").assign(ArrayMemory.of(this.args));
        }
        if (this.trace != null) {
            el.refOfIndex("position").assign(this.trace.getStartPosition() + 1);
        }
        return el;
    }

    public static String toString(CallStackItem[] items, boolean withArgs) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        if (items != null) {
            for (CallStackItem e : items) {
                if (i != 0) {
                    sb.append("\n");
                }
                sb.append("#").append(i).append(" ").append(e.toString(withArgs));
                ++i;
            }
            if (i != 0) {
                sb.append("\n");
            }
            sb.append("#").append(i).append(" {main}");
        }
        return sb.toString();
    }

    public String getWhere() {
        StringBuilder sb = new StringBuilder();
        if (this.object instanceof Closure) {
            sb.append("{closure}");
        } else if (this.clazz != null) {
            sb.append(this.clazz);
            if (this.object == null) {
                sb.append("::");
            } else {
                sb.append("->");
            }
            sb.append(this.function);
        } else if (this.function != null) {
            sb.append(this.function);
        } else {
            sb.append("<internal>");
        }
        return sb.toString();
    }

    public String toString(boolean withArgs) {
        StringBuilder sb = new StringBuilder();
        if (this.object instanceof Closure) {
            sb.append("{closure}");
        } else if (this.clazz != null) {
            sb.append(this.clazz);
            if (this.object == null) {
                sb.append("::");
            } else {
                sb.append("->");
            }
            sb.append(this.function);
        } else if (this.function != null) {
            sb.append(this.function);
        } else {
            sb.append("<internal>");
        }
        sb.append("(");
        if (withArgs) {
            StringWriter writer = new StringWriter();
            PlainPrinter printer = new PlainPrinter(null, writer);
            int i = 0;
            if (this.args != null) {
                for (Memory arg : this.args) {
                    printer.print(arg);
                    if (i != this.args.length - 1) {
                        writer.append(", ");
                    }
                    ++i;
                }
            }
            sb.append(writer.toString());
        }
        sb.append(")");
        if (this.trace != null && this.trace != TraceInfo.UNKNOWN) {
            sb.append(" called at [");
            sb.append(this.trace.getFileName());
            sb.append(":");
            sb.append(this.trace.getStartLine() + 1);
            sb.append("]");
        }
        return sb.toString();
    }
}

