/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.util;

import java.io.IOException;
import java.util.HashSet;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.lib.ItemsUtils;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringBuilderMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\util\\Flow")
public class WrapFlow
extends BaseObject
implements Iterator {
    protected ForeachIterator selfIterator;
    protected ForeachIterator iterator;
    protected Worker worker;
    protected boolean init;
    protected boolean valid = true;
    protected boolean withKeys = false;

    public WrapFlow(Environment env, Iterable iterable) {
        this(env, ForeachIterator.of(env, iterable));
    }

    public WrapFlow(Environment env, ForeachIterator iterator) {
        super(env);
        this.iterator = iterator;
        this.worker = new Worker(){

            @Override
            public boolean next(Environment env) {
                return WrapFlow.this.iterator.next();
            }
        };
        this.worker.setIterator(iterator);
    }

    public WrapFlow(Environment env, ForeachIterator iterator, Worker worker) {
        super(env);
        this.iterator = iterator;
        this.worker = worker;
        this.worker.setIterator(iterator);
    }

    public WrapFlow(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    protected ForeachIterator getSelfIterator(Environment env) {
        if (this.selfIterator == null) {
            this.selfIterator = new ObjectMemory(this).getNewIterator(env);
        }
        if (!this.valid) {
            env.exception("Unable to iterate the flow repeatedly", new Object[0]);
        }
        return this.selfIterator;
    }

    protected static Memory call(ForeachIterator iterator, Invoker invoker) {
        if (invoker == null) {
            return iterator.getValue();
        }
        if (invoker.getArgumentCount() == 1) {
            return invoker.callNoThrow(iterator.getValue());
        }
        return invoker.callNoThrow(iterator.getValue(), iterator.getMemoryKey());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public Memory __construct(Environment env, Memory ... args) {
        ForeachIterator iterator;
        this.iterator = iterator = args[0].toImmutable().getNewIterator(env);
        this.worker = new Worker(){

            @Override
            public boolean next(Environment env) {
                return WrapFlow.this.iterator.next();
            }
        };
        this.worker.setIterator(iterator);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory withKeys(Environment env, Memory ... args) {
        this.withKeys = true;
        return new ObjectMemory(this);
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public static Memory ofEmpty(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapFlow(env, new ArrayMemory().getNewIterator(env)));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public static Memory of(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapFlow(env, args[0].toImmutable().getNewIterator(env)));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="from"), @Reflection.Arg(value="to"), @Reflection.Arg(value="step", optional=@Reflection.Optional(value="1"))})
    public static Memory ofRange(Environment env, Memory ... args) {
        final int from = args[0].toInteger();
        final int to = args[1].toInteger();
        final int step = args[2].toInteger() < 1 ? 1 : args[2].toInteger();
        return new ObjectMemory(new WrapFlow(env, new ForeachIterator(false, false, false){
            protected int i;

            @Override
            public void reset() {
                this.i = from;
                this.currentKeyMemory = LongMemory.valueOf(-1);
                this.currentKey = this.currentKeyMemory;
            }

            @Override
            protected boolean init() {
                this.reset();
                return true;
            }

            @Override
            protected boolean nextValue() {
                if (this.i <= to) {
                    this.currentValue = LongMemory.valueOf(this.i);
                    if (this.currentKey == null) {
                        this.currentKey = LongMemory.valueOf(0);
                    }
                    this.currentKey = ((LongMemory)this.currentKey).inc();
                    this.currentKeyMemory = null;
                    this.i += step;
                    return true;
                }
                return false;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }
        }));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="stream", typeClass="php\\io\\Stream"), @Reflection.Arg(value="chunkSize", optional=@Reflection.Optional(value="1"))})
    public static Memory ofStream(final Environment env, Memory ... args) {
        final Stream stream = args[0].toObject(Stream.class);
        final int chunkSize = args[1].toInteger() < 1 ? 1 : args[1].toInteger();
        return new ObjectMemory(new WrapFlow(env, new ForeachIterator(false, false, false){

            protected boolean eof() {
                env.pushCall(stream, "eof", new Memory[0]);
                try {
                    boolean bl = stream.eof(env, new Memory[0]).toBoolean();
                    return bl;
                }
                finally {
                    env.popCall();
                }
            }

            @Override
            protected boolean init() {
                this.currentKey = Memory.CONST_INT_M1;
                return !this.eof();
            }

            @Override
            protected boolean nextValue() {
                if (this.eof()) {
                    return false;
                }
                env.pushCall(stream, "read", LongMemory.valueOf(chunkSize));
                try {
                    this.currentValue = stream.read(env, LongMemory.valueOf(chunkSize));
                    this.currentKey = ((LongMemory)this.currentKey).inc();
                }
                catch (IOException e) {
                    env.catchUncaught(e);
                }
                finally {
                    env.popCall();
                }
                return true;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }

            @Override
            public void reset() {
                this.currentKey = Memory.CONST_INT_M1;
                env.pushCall(stream, "seek", Memory.CONST_INT_0);
                try {
                    stream.seek(env, Memory.CONST_INT_0);
                }
                catch (IOException e) {
                    env.catchUncaught(e);
                }
                finally {
                    env.popCall();
                }
            }
        }));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="chunkSize", optional=@Reflection.Optional(value="1"))})
    public static Memory ofString(Environment env, Memory ... args) {
        final String string = args[0].toString();
        final int chunkSize = args[1].toInteger() < 1 ? 1 : args[1].toInteger();
        return new ObjectMemory(new WrapFlow(env, new ForeachIterator(false, false, false){
            protected int i;
            protected int length;
            {
                super(getReferences, getKeyReferences, withPrevious);
                this.i = 0;
                this.length = string.length();
            }

            @Override
            public void reset() {
                this.i = 0;
            }

            @Override
            protected boolean init() {
                this.reset();
                return this.length > 0;
            }

            @Override
            protected boolean nextValue() {
                if (this.i < this.length) {
                    int endIndex = this.i + chunkSize;
                    if (endIndex > this.length) {
                        endIndex = this.length;
                    }
                    Memory memory = this.currentValue = chunkSize == 1 ? StringMemory.valueOf(string.charAt(this.i)) : StringMemory.valueOf(string.substring(this.i, endIndex));
                    if (this.currentKeyMemory == null) {
                        this.currentKeyMemory = LongMemory.valueOf(0);
                    }
                    this.currentKeyMemory = this.currentKeyMemory.inc();
                    this.currentKey = this.currentKeyMemory;
                    this.i += chunkSize;
                    return true;
                }
                return false;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }
        }));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public Memory append(Environment env, Memory ... args) {
        final ForeachIterator appendIterator = args[0].toImmutable().getNewIterator(env);
        final ForeachIterator iterator = this.getSelfIterator(env);
        return new ObjectMemory(new WrapFlow(env, new ForeachIterator(false, false, false){
            protected boolean applyAppended;
            {
                super(getReferences, getKeyReferences, withPrevious);
                this.applyAppended = false;
            }

            @Override
            public void reset() {
                iterator.reset();
                appendIterator.reset();
                this.applyAppended = false;
            }

            @Override
            protected boolean init() {
                return true;
            }

            @Override
            protected boolean nextValue() {
                ForeachIterator it = appendIterator;
                boolean r = false;
                if (!this.applyAppended) {
                    it = iterator;
                    r = it.next();
                    if (!r) {
                        this.applyAppended = true;
                        it = appendIterator;
                    }
                } else {
                    this.applyAppended = true;
                }
                if (this.applyAppended) {
                    r = it.next();
                }
                return r;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }

            @Override
            public Object getKey() {
                return this.applyAppended ? appendIterator.getKey() : iterator.getKey();
            }

            @Override
            public Memory getMemoryKey() {
                return this.applyAppended ? appendIterator.getMemoryKey() : iterator.getMemoryKey();
            }

            @Override
            public Memory getValue() {
                return this.applyAppended ? appendIterator.getValue() : iterator.getValue();
            }
        }));
    }

    @Override
    @Reflection.Signature
    public Memory current(Environment env, Memory ... args) {
        if (!this.valid) {
            return Memory.NULL;
        }
        if (!this.init) {
            this.rewind(env, args);
        }
        return this.worker.current(env);
    }

    @Override
    @Reflection.Signature
    public Memory key(Environment env, Memory ... args) {
        return this.worker.key(env);
    }

    @Override
    @Reflection.Signature
    public Memory next(Environment env, Memory ... args) {
        if (!this.valid) {
            return Memory.NULL;
        }
        if (!this.worker.next(env)) {
            this.valid = false;
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory rewind(Environment env, Memory ... args) {
        if (this.init) {
            this.worker.reset();
            return Memory.NULL;
        }
        this.init = true;
        if (!this.worker.next(env)) {
            this.valid = false;
            return Memory.NULL;
        }
        this.valid = true;
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory valid(Environment env, Memory ... args) {
        return this.valid ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory count(Environment env, Memory ... args) {
        int cnt = 0;
        ForeachIterator iterator = this.getSelfIterator(env);
        while (iterator.next()) {
            ++cnt;
        }
        return LongMemory.valueOf(cnt);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="comparator", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null"))})
    public Memory sort(Environment env, Memory ... args) {
        return ItemsUtils.sort(env, new ObjectMemory(this), args[0], this.withKeys ? Memory.TRUE : Memory.FALSE);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="comparator", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null"))})
    public Memory sortByKeys(Environment env, Memory ... args) {
        return ItemsUtils.sortByKeys(env, new ObjectMemory(this), args[0], this.withKeys ? Memory.TRUE : Memory.FALSE);
    }

    @Reflection.Signature
    public Memory toArray(Environment env, Memory ... args) {
        ForeachIterator iterator = this.getSelfIterator(env);
        ArrayMemory r = new ArrayMemory();
        while (iterator.next()) {
            if (this.withKeys) {
                r.put(iterator.getKey(), iterator.getValue());
                continue;
            }
            r.add(iterator.getValue());
        }
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="separator")})
    public Memory toString(Environment env, Memory ... args) {
        String sep = args[0].toString();
        ForeachIterator iterator = this.getSelfIterator(env);
        StringBuilderMemory sb = new StringBuilderMemory();
        int i = 0;
        while (iterator.next()) {
            if (i != 0) {
                sb.append(sep);
            }
            sb.append(iterator.getValue());
            ++i;
        }
        return sb;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public Memory reduce(Environment env, Memory ... args) {
        Invoker invoker = Invoker.valueOf(env, null, args[0]);
        ForeachIterator iterator = this.getSelfIterator(env);
        Memory r = Memory.NULL;
        int argCount = invoker.getArgumentCount();
        while (iterator.next()) {
            if (argCount < 3) {
                r = invoker.callNoThrow(r, iterator.getValue());
                continue;
            }
            r = invoker.callNoThrow(r, iterator.getValue(), iterator.getMemoryKey());
        }
        return r;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public Memory each(Environment env, Memory ... args) {
        ForeachIterator iterator = this.getSelfIterator(env);
        Invoker invoker = Invoker.valueOf(env, null, args[0]);
        int cnt = 0;
        while (iterator.next()) {
            ++cnt;
            if (WrapFlow.call(iterator, invoker).toValue() != Memory.FALSE) continue;
            break;
        }
        return LongMemory.valueOf(cnt);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="sliceSize"), @Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public Memory eachSlice(Environment env, Memory ... args) {
        Invoker invoker = Invoker.valueOf(env, null, args[1]);
        ArrayMemory tmp = new ArrayMemory();
        int cnt = 0;
        int r = 0;
        int n = args[0].toInteger();
        while (this.iterator.next()) {
            ++cnt;
            if (this.withKeys) {
                tmp.refOfIndex(this.iterator.getMemoryKey()).assign(this.iterator.getValue());
            } else {
                tmp.add(this.iterator.getValue());
            }
            if (cnt < n) continue;
            ++r;
            Memory ret = invoker.callNoThrow(tmp);
            tmp = new ArrayMemory();
            if (ret.toValue() == Memory.FALSE) break;
            cnt = 0;
        }
        if (tmp.size() > 0) {
            ++r;
            invoker.callNoThrow(tmp);
        }
        return LongMemory.valueOf(r);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public Memory group(Environment env, Memory ... args) {
        final Invoker invoker = Invoker.valueOf(env, null, args[0]);
        final ForeachIterator iterator = this.getSelfIterator(env);
        return new ObjectMemory(new WrapFlow(env, new ForeachIterator(false, false, false){
            protected Memory key;

            @Override
            protected boolean init() {
                this.key = Memory.CONST_INT_M1;
                return true;
            }

            @Override
            protected boolean nextValue() {
                ArrayMemory r = new ArrayMemory();
                boolean done = false;
                while (iterator.next()) {
                    done = true;
                    if (WrapFlow.this.withKeys) {
                        r.refOfIndex(iterator.getMemoryKey()).assign(iterator.getValue());
                    } else {
                        r.refOfPush().assign(iterator.getValue());
                    }
                    if (!WrapFlow.call(iterator, invoker).toBoolean()) continue;
                }
                if (done) {
                    this.currentKeyMemory = this.key.inc();
                    this.currentKey = this.currentKeyMemory;
                    this.currentValue = r;
                }
                return done;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }

            @Override
            public void reset() {
                iterator.reset();
                this.key = Memory.CONST_INT_M1;
            }
        }));
    }

    @Reflection.Signature
    public IObject onlyKeys(Environment env, ForeachIterator iterator) {
        return this.onlyKeys(env, iterator, false);
    }

    @Reflection.Signature
    public IObject onlyKeys(Environment env, ForeachIterator iterator, final boolean ignoreCase) {
        final HashSet<String> keys = new HashSet<String>();
        for (Memory el : iterator) {
            if (ignoreCase) {
                keys.add(el.toString());
                continue;
            }
            keys.add(el.toString().toLowerCase());
        }
        return new WrapFlow(env, this.getSelfIterator(env), new Worker(){

            @Override
            public boolean next(Environment env) {
                while (this.iterator.next()) {
                    String key = this.iterator.getKey().toString();
                    if (ignoreCase) {
                        key = key.toLowerCase();
                    }
                    if (!keys.contains(key)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Reflection.Signature(value={@Reflection.Arg(value="filter", type=HintType.CALLABLE, optional=@Reflection.Optional(value="NULL"))})
    public Memory find(Environment env, Memory ... args) {
        final Invoker invoker = Invoker.valueOf(env, null, args[0]);
        return new ObjectMemory(new WrapFlow(env, this.getSelfIterator(env), new Worker(){

            @Override
            public boolean next(Environment env) {
                while (this.iterator.next()) {
                    if (!WrapFlow.call(this.iterator, invoker).toBoolean()) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="filter", type=HintType.CALLABLE, optional=@Reflection.Optional(value="NULL"))})
    public Memory findOne(Environment env, Memory ... args) {
        Invoker invoker = Invoker.valueOf(env, null, args[0]);
        ForeachIterator iterator = this.getSelfIterator(env);
        while (iterator.next()) {
            if (!WrapFlow.call(iterator, invoker).toBoolean()) continue;
            return iterator.getValue();
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="strict", optional=@Reflection.Optional(value="false"))})
    public Memory findValue(Environment env, Memory ... args) {
        ForeachIterator iterator = this.getSelfIterator(env);
        boolean strict = args[1].toBoolean();
        while (iterator.next()) {
            if (strict && iterator.getValue().identical(args[0])) {
                return iterator.getMemoryKey();
            }
            if (!iterator.getValue().equal(args[0])) continue;
            return iterator.getMemoryKey();
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory keys(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapFlow(env, this.getSelfIterator(env), new Worker(){
            Memory current;
            Memory key;

            @Override
            public boolean next(Environment env) {
                if (this.iterator.next()) {
                    this.current = this.iterator.getMemoryKey();
                    this.key = this.key == null ? Memory.CONST_INT_0 : this.key.inc();
                    return true;
                }
                return false;
            }

            @Override
            public Memory current(Environment env) {
                return this.current == null ? Memory.NULL : this.current;
            }

            @Override
            public Memory key(Environment env) {
                return this.key == null ? Memory.NULL : this.key;
            }

            @Override
            public void reset() {
                this.key = null;
                this.current = null;
            }
        }));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public Memory map(Environment env, Memory ... args) {
        final Invoker invoker = Invoker.valueOf(env, null, args[0]);
        return new ObjectMemory(new WrapFlow(env, this.getSelfIterator(env), new Worker(){
            Memory current;

            @Override
            public boolean next(Environment env) {
                if (this.iterator.next()) {
                    this.current = WrapFlow.call(this.iterator, invoker);
                    return true;
                }
                return false;
            }

            @Override
            public Memory current(Environment env) {
                return this.current == null ? Memory.NULL : this.current;
            }
        }));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="n")})
    public Memory skip(Environment env, Memory ... args) {
        final int skip = args[0].toInteger();
        if (skip <= 0) {
            return new ObjectMemory(this);
        }
        return new ObjectMemory(new WrapFlow(env, this.getSelfIterator(env), new Worker(){
            protected int i = 0;

            @Override
            public boolean next(Environment env) {
                while (this.iterator.next()) {
                    ++this.i;
                    if (this.i <= skip) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="max")})
    public Memory limit(Environment env, Memory ... args) {
        final int limit = args[0].toInteger();
        return new ObjectMemory(new WrapFlow(env, this.getSelfIterator(env), new Worker(){
            protected int i = 0;

            @Override
            public boolean next(Environment env) {
                if (this.i >= limit) {
                    return false;
                }
                if (this.iterator.next()) {
                    ++this.i;
                    return true;
                }
                return false;
            }
        }));
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ObjectMemory.valueOf(this).getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env) {
        return ObjectMemory.valueOf(this).getNewIterator(env);
    }

    protected static abstract class Worker {
        protected ForeachIterator iterator;

        protected Worker() {
        }

        public void setIterator(ForeachIterator iterator) {
            this.iterator = iterator;
        }

        public abstract boolean next(Environment var1);

        public Memory current(Environment env) {
            return this.iterator.getValue();
        }

        public Memory key(Environment env) {
            return this.iterator.getMemoryKey();
        }

        public void reset() {
            this.iterator.reset();
        }
    }
}

