/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.spl;

import java.io.File;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.env.SplClassLoader;
import php.runtime.env.TraceInfo;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.invoke.Invoker;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.spl.Countable;
import php.runtime.lang.spl.Traversable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

public class SPLFunctions
extends FunctionsContainer {
    private static final StringMemory __autoloadMethod = new StringMemory("__autoload");
    public static final StringMemory defaultExtensions = new StringMemory(".inc,.php");

    public static long iterator_apply(Environment env, TraceInfo trace, Memory object, Memory callback, Memory args) throws Throwable {
        if (SPLFunctions.expectingImplement(env, trace, 1, object, Traversable.class)) {
            Invoker invoker = SPLFunctions.expectingCallback(env, trace, 2, callback);
            if (invoker == null) {
                return 0L;
            }
            if (args != null && !SPLFunctions.expecting(env, trace, 3, args, Memory.Type.ARRAY)) {
                return 0L;
            }
            ForeachIterator iterator = object.getNewIterator(env, false, false);
            Memory[] values = args == null ? null : args.toValue(ArrayMemory.class).values(true);
            int i = 0;
            while (iterator.next() && invoker.call(values).toBoolean()) {
                ++i;
            }
            return i;
        }
        return 0L;
    }

    public static long iterator_apply(Environment env, TraceInfo trace, Memory object, Memory callback) throws Throwable {
        return SPLFunctions.iterator_apply(env, trace, object, callback, null);
    }

    public static long iterator_count(Environment env, TraceInfo trace, Memory object) {
        if (SPLFunctions.expectingImplement(env, trace, 1, object, Traversable.class)) {
            IObject tmp = object.toValue(ObjectMemory.class).value;
            if (tmp instanceof Countable) {
                return ((Countable)tmp).count(env, new Memory[0]).toLong();
            }
            ForeachIterator iterator = object.getNewIterator(env, true, false);
            int i = 0;
            while (iterator.next()) {
                ++i;
            }
            return i;
        }
        return 0L;
    }

    public static Memory iterator_to_array(Environment env, TraceInfo trace, Memory object, boolean useKeys) {
        if (SPLFunctions.expectingImplement(env, trace, 1, object, Traversable.class)) {
            ArrayMemory result = new ArrayMemory();
            ForeachIterator iterator = object.getNewIterator(env, false, false);
            while (iterator.next()) {
                if (useKeys) {
                    result.refOfIndex(iterator.getMemoryKey()).assign(iterator.getValue());
                    continue;
                }
                result.add(iterator.getValue());
            }
            return result.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory iterator_to_array(Environment env, TraceInfo trace, Memory object) {
        return SPLFunctions.iterator_to_array(env, trace, object, true);
    }

    public static Memory class_parents(Environment env, TraceInfo trace, Memory object, boolean autoLoad) {
        ClassEntity entity = object.isObject() ? object.toValue(ObjectMemory.class).getReflection() : env.fetchClass(object.toString(), autoLoad);
        if (entity == null) {
            env.warning(trace, "class_parents(): Class %s does not exist and could not be loaded", object.toString());
            return Memory.FALSE;
        }
        ArrayMemory result = new ArrayMemory();
        while ((entity = entity.getParent()) != null) {
            result.refOfIndex(entity.getName()).assign(entity.getName());
        }
        return result.toConstant();
    }

    public static Memory class_parents(Environment env, TraceInfo trace, Memory object) {
        return SPLFunctions.class_parents(env, trace, object, true);
    }

    public static Memory class_implements(Environment env, TraceInfo trace, Memory object, boolean autoLoad) {
        ClassEntity entity = object.isObject() ? object.toValue(ObjectMemory.class).getReflection() : env.fetchClass(object.toString(), autoLoad);
        if (entity == null) {
            env.warning(trace, "class_implements(): Class %s does not exist and could not be loaded", object.toString());
            return Memory.FALSE;
        }
        ArrayMemory result = new ArrayMemory();
        do {
            for (ClassEntity el : entity.getInterfaces().values()) {
                result.refOfIndex(el.getName()).assign(el.getName());
            }
        } while ((entity = entity.getParent()) != null);
        return result.toConstant();
    }

    public static Memory class_implements(Environment env, TraceInfo trace, Memory object) {
        return SPLFunctions.class_implements(env, trace, object, true);
    }

    public static Memory spl_object_hash(Environment env, TraceInfo trace, Memory object) {
        if (SPLFunctions.expecting(env, trace, 1, object, Memory.Type.OBJECT)) {
            return LongMemory.valueOf(object.getPointer());
        }
        return Memory.FALSE;
    }

    public static boolean spl_autoload_register(Environment env, TraceInfo trace, Memory callback, boolean _throw, boolean prepend) {
        Invoker invoker = SPLFunctions.expectingCallback(env, trace, 1, callback);
        if (invoker == null) {
            return false;
        }
        env.registerAutoloader(new SplClassLoader(invoker, callback), prepend);
        return true;
    }

    public static boolean spl_autoload_register(Environment env, TraceInfo trace, Memory callback, boolean _throw) {
        return SPLFunctions.spl_autoload_register(env, trace, callback, _throw, false);
    }

    public static boolean spl_autoload_register(Environment env, TraceInfo trace, Memory callback) {
        return SPLFunctions.spl_autoload_register(env, trace, callback, true, false);
    }

    public static boolean spl_autoload_register(Environment env, TraceInfo trace) {
        return SPLFunctions.spl_autoload_register(env, trace, new StringMemory("spl_autoload"), true, false);
    }

    public static Memory spl_autoload_functions(Environment env) {
        Invoker invoker;
        ArrayMemory result = new ArrayMemory();
        for (SplClassLoader loader : env.getClassLoaders()) {
            result.add(loader.getCallback().toImmutable());
        }
        if (result.size() == 0 && env.__autoload == null && (invoker = Invoker.valueOf(env, null, __autoloadMethod)) != null) {
            env.__autoload = new SplClassLoader(invoker, __autoloadMethod);
            result.add(env.__autoload.getCallback().toImmutable());
        }
        return result.toConstant();
    }

    public static boolean spl_autoload_unregister(Environment env, TraceInfo trace, Memory callback) {
        Invoker invoker = SPLFunctions.expectingCallback(env, trace, 1, callback);
        if (invoker == null) {
            return false;
        }
        return env.unRegisterAutoloader(new SplClassLoader(invoker, callback));
    }

    public static String spl_autoload_extensions(Environment env, String extensions) {
        env.getOrCreateStatic("spl$autoload_extensions", defaultExtensions).assign(extensions);
        return extensions;
    }

    public static String spl_autoload_extensions(Environment env) {
        return env.getOrCreateStatic("spl$autoload_extensions", defaultExtensions).toString();
    }

    public static void __$jphp_spl_autoload(Environment env, String className, String fileExtensions) {
        Invoker invoker;
        if (env.__autoload == null && (invoker = Invoker.valueOf(env, null, __autoloadMethod)) != null) {
            env.__autoload = new SplClassLoader(invoker, __autoloadMethod);
        }
        if (env.__autoload != null) {
            env.__autoload.load(new StringMemory(className), new StringMemory(fileExtensions));
        }
    }

    public static void __$jphp_spl_autoload(Environment env, String className) {
        SPLFunctions.__$jphp_spl_autoload(env, className, SPLFunctions.spl_autoload_extensions(env));
    }

    public static void spl_autoload(Environment env, String className, String fileExtensions) throws Throwable {
        String[] extensions = StringUtils.split(fileExtensions, ",", 255);
        Set<String> includePaths = env.getIncludePaths();
        for (String path : includePaths) {
            for (String e : extensions) {
                File file = new File(path, className + e);
                if (!file.exists()) continue;
                env.__include(file.getPath());
                return;
            }
        }
    }

    public static void spl_autoload(Environment env, String className) throws Throwable {
        SPLFunctions.spl_autoload(env, className, SPLFunctions.spl_autoload_extensions(env));
    }
}

