/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.common.Pair;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.RecursiveException;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.StdClass;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.memory.helper.ArrayKeyMemory;
import php.runtime.memory.helper.ArrayValueMemory;
import php.runtime.memory.helper.ShortcutMemory;
import php.runtime.memory.support.ArrayMapEntryMemory;
import php.runtime.memory.support.ArrayMemoryList;
import php.runtime.memory.support.ArrayMemoryMap;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.memory.support.MemoryStringUtils;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.support.ReflectionUtils;

public class ArrayMemory
extends Memory
implements Iterable<ReferenceMemory> {
    protected transient long lastLongIndex;
    protected transient int size;
    protected transient int copies;
    protected transient ArrayMemory original;
    protected transient ArrayMemoryList<ReferenceMemory> _list;
    protected transient ArrayMemoryMap map;
    protected transient ForeachIterator foreachIterator;

    public ArrayMemory(boolean asMap) {
        super(Memory.Type.ARRAY);
        if (asMap) {
            this.convertToMap();
        }
        this.lastLongIndex = -1L;
    }

    private ArrayMemory(ArrayMemoryMap map) {
        super(Memory.Type.ARRAY);
        this.map = map;
        this.lastLongIndex = -1L;
    }

    private ArrayMemory(ArrayMemoryList<ReferenceMemory> list) {
        super(Memory.Type.ARRAY);
        this.map = null;
        this._list = list;
        this.lastLongIndex = -1L;
    }

    public ArrayMemory() {
        this(false);
    }

    public static ArrayMemory createListed(int expectedSize) {
        if (expectedSize <= 0) {
            return new ArrayMemory();
        }
        return new ArrayMemory(new ArrayMemoryList<ReferenceMemory>(expectedSize));
    }

    public static ArrayMemory createHashed() {
        return ArrayMemory.createHashed(8);
    }

    public static ArrayMemory createHashed(int expectedSize) {
        ArrayMemoryMap map = new ArrayMemoryMap(expectedSize < 4 ? 7 : (int)((double)expectedSize * 1.75));
        return new ArrayMemory(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceMemory> getList() {
        if (this._list != null) {
            return this._list;
        }
        ArrayMemory arrayMemory = this;
        synchronized (arrayMemory) {
            if (this._list != null) {
                return this._list;
            }
            this._list = new ArrayMemoryList(7);
        }
        return this._list;
    }

    @Deprecated
    public ArrayMemory(Collection collection) {
        this();
        for (Object el : collection) {
            if (el == null) {
                this.add(NULL);
                continue;
            }
            MemoryOperation operation = MemoryOperation.get(el.getClass(), null);
            if (operation == null) continue;
            this.add(operation.unconvertNoThow(null, null, el));
        }
    }

    @Deprecated
    public ArrayMemory(Object ... array) {
        this();
        for (Object el : array) {
            if (el == null) {
                this.getList().add(new ReferenceMemory());
                continue;
            }
            MemoryOperation operation = MemoryOperation.get(el.getClass(), null);
            if (operation == null) continue;
            this.getList().add(new ReferenceMemory(operation.unconvertNoThow(null, null, el)));
        }
        this.size = array.length;
        this.lastLongIndex = this.size - 1;
    }

    @Deprecated
    public ArrayMemory(boolean toImmutable, Memory ... array) {
        this();
        if (array != null) {
            for (Memory el : array) {
                this.getList().add(new ReferenceMemory(toImmutable ? el.toImmutable() : el));
            }
            this.size = array.length;
            this.lastLongIndex = this.size - 1;
        }
    }

    @Deprecated
    public ArrayMemory(String[] array) {
        this();
        for (String el : array) {
            this.getList().add(new ReferenceMemory(StringMemory.valueOf(el)));
        }
        this.size = array.length;
        this.lastLongIndex = this.size - 1;
    }

    @Deprecated
    public ArrayMemory(Map map) {
        this();
        for (Object key : map.keySet()) {
            Object el = map.get(key);
            this.put(ArrayMemory.toKey(MemoryUtils.valueOf(key)), MemoryUtils.valueOf(el));
        }
    }

    public static Memory valueOf() {
        return new ArrayMemory();
    }

    public static ArrayMemory valueOfRef(ArrayMemory value) {
        if (value == null) {
            return new ArrayMemory();
        }
        return value;
    }

    public Set<Object> keySet() {
        if (this.map == null) {
            HashSet<Object> set = new HashSet<Object>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                set.add(i);
            }
            return set;
        }
        return this.map.keySet();
    }

    public ArrayMemory duplicate() {
        ArrayMemory result = new ArrayMemory();
        result.lastLongIndex = this.lastLongIndex;
        result.size = this.size;
        if (this.size() == 0) {
            return result;
        }
        if (this.map == null) {
            for (ReferenceMemory item : this.getList()) {
                result.getList().add(item.duplicate());
            }
        } else {
            result._list = null;
            result.map = new ArrayMemoryMap();
            for (Map.Entry<Object, Memory> entry : this.map.entrySet()) {
                result.map.put(entry.getKey(), entry.getValue().toImmutable());
            }
        }
        return result;
    }

    public ArrayMemory checkCopied() {
        if (this.original != null || this.copies > 0) {
            ArrayMemory dup = this.duplicate();
            this.map = dup.map;
            this._list = dup._list;
            this.lastLongIndex = dup.lastLongIndex;
            if (this.original == null) {
                --this.copies;
            } else {
                --this.original.copies;
                this.original = null;
                this.copies = 0;
            }
            return dup;
        }
        return null;
    }

    public static Object toKey(Memory key) {
        switch (key.type) {
            case STRING: {
                String key1 = key.toString();
                Memory number = StringMemory.toLong(key1);
                if (number == null) {
                    return key1;
                }
                return number;
            }
            case INT: {
                return key;
            }
            case NULL: {
                return Memory.CONST_EMPTY_STRING;
            }
            case REFERENCE: {
                return ArrayMemory.toKey(key.toValue());
            }
        }
        return LongMemory.valueOf(key.toLong());
    }

    public boolean containsLongKey(long key) {
        return this.containsKey(LongMemory.valueOf(key));
    }

    public boolean containsKey(Object key) {
        if (this.size() == 0) {
            return false;
        }
        if (this._list != null) {
            long t = MemoryUtils.valueOf(key).toLong();
            return t >= 0L && t < (long)this._list.size();
        }
        return this.map.containsKey(key);
    }

    private void convertToMap() {
        this.map = new ArrayMemoryMap();
        if (this._list != null && !this._list.isEmpty()) {
            int i = 0;
            for (ReferenceMemory memory : this._list) {
                if (memory != null) {
                    this.map.put((Object)LongMemory.valueOf(i), memory.getValue());
                }
                ++i;
            }
        }
        this._list = null;
    }

    public void renameKey(Memory oldKey, Memory newKey) {
        this.checkCopied();
        if (this._list != null || this.map == null) {
            this.convertToMap();
        }
        Object key1 = ArrayMemory.toKey(oldKey);
        Object key2 = ArrayMemory.toKey(newKey);
        this.map.put(key2, this.map.remove(key1));
    }

    public Memory get(Memory key) {
        return this.getByScalar(ArrayMemory.toKey(key));
    }

    public ReferenceMemory getOrCreate(Memory key) {
        return this.getByScalarOrCreate(ArrayMemory.toKey(key));
    }

    public ReferenceMemory getOrCreateAsShortcut(Memory key) {
        return this.getByScalarOrCreateAsShortcut(ArrayMemory.toKey(key));
    }

    public ReferenceMemory getByScalarOrCreate(Object sKey, Memory initValue) {
        ReferenceMemory value = this.getByScalar(sKey);
        if (value == null) {
            return this.put(sKey, initValue);
        }
        return value;
    }

    public ReferenceMemory getByScalarOrCreateAsShortcut(Object sKey) {
        ReferenceMemory value = this.getByScalar(sKey);
        if (value == null) {
            value = new ReferenceMemory(UNDEFINED);
            return this.put(sKey, new ShortcutMemory(value));
        }
        if (value instanceof ShortcutMemory) {
            return (ShortcutMemory)value.getValue();
        }
        this.put(sKey, new ShortcutMemory(value));
        return value;
    }

    public ReferenceMemory getByScalarOrCreate(Object sKey) {
        return this.getByScalarOrCreate(sKey, UNDEFINED);
    }

    public ReferenceMemory getByScalar(Object key) {
        if (this._list != null) {
            if (key instanceof Memory) {
                int index = (int)((Memory)key).toLong();
                if (index >= 0 && index < this._list.size()) {
                    return (ReferenceMemory)this._list.get(index);
                }
                return null;
            }
            return null;
        }
        if (this.map != null) {
            return this.map.getEntry(key);
        }
        return null;
    }

    public void add(IObject object) {
        this.add(new ObjectMemory(object));
    }

    public void add(long value) {
        this.add(LongMemory.valueOf(value));
    }

    public void add(String value) {
        this.add(StringMemory.valueOf(value));
    }

    public void add(double value) {
        this.add(new DoubleMemory(value));
    }

    public void add(boolean value) {
        this.add(value ? TRUE : FALSE);
    }

    public void addNull() {
        this.add(NULL);
    }

    public ReferenceMemory add(Memory value) {
        ReferenceMemory ref;
        if (value instanceof KeyValueMemory) {
            KeyValueMemory keyValue = (KeyValueMemory)value;
            return this.put(keyValue.getArrayKey(), keyValue.getValue().toImmutable());
        }
        if (this.map == null) {
            ++this.lastLongIndex;
            ref = new ReferenceMemory(value);
            this.getList().add(ref);
            ++this.size;
        } else {
            ref = this.put(LongMemory.valueOf(++this.lastLongIndex), value);
        }
        return ref;
    }

    public void merge(ArrayMemory array, boolean recursive, Set<Integer> done) {
        this.checkCopied();
        if (recursive && done == null) {
            done = new HashSet<Integer>();
        }
        if (this.map == null && array.map == null) {
            for (ReferenceMemory reference : array.getList()) {
                this.getList().add(new ReferenceMemory(reference.toImmutable()));
            }
            this.size = this.getList().size();
            this.lastLongIndex = this.size - 1;
        } else {
            if (this.map == null) {
                this.convertToMap();
            }
            if (array.map == null) {
                for (ReferenceMemory reference : array.getList()) {
                    this.add(reference.toImmutable());
                }
            } else {
                for (Map.Entry<Object, Memory> entry : array.map.entrySet()) {
                    Object key = entry.getKey();
                    if (key instanceof LongMemory) {
                        this.add(entry.getValue().toImmutable());
                        continue;
                    }
                    Memory value = entry.getValue();
                    if (recursive && value.isArray()) {
                        if (done.contains(value.getPointer())) {
                            throw new RecursiveException();
                        }
                        Memory current = this.getByScalar(key).toImmutable();
                        if (current.isArray()) {
                            value = value.toImmutable();
                            int pointer = value.getPointer();
                            done.add(pointer);
                            ArrayMemory result = (ArrayMemory)value;
                            result.merge((ArrayMemory)current, recursive, done);
                            this.put(key, result);
                            done.remove(pointer);
                            continue;
                        }
                        this.put(key, value.toImmutable());
                        continue;
                    }
                    this.put(key, value.toImmutable());
                }
            }
        }
    }

    public void putAll(ArrayMemory array) {
        if (array.map == null) {
            int i = 0;
            for (ReferenceMemory memory : array.getList()) {
                if (memory != null) {
                    this.put(LongMemory.valueOf(i), memory.toImmutable());
                }
                ++i;
            }
        } else {
            if (this.map == null) {
                this.convertToMap();
            }
            if (array.lastLongIndex > this.lastLongIndex) {
                this.lastLongIndex = array.lastLongIndex;
            }
            for (Map.Entry<Object, Memory> entry : array.map.entrySet()) {
                this.put(entry.getKey(), entry.getValue().toImmutable());
            }
        }
    }

    public void putAllRef(ArrayMemory array) {
        if (array.map == null) {
            int i = 0;
            for (ReferenceMemory memory : array.getList()) {
                if (memory != null) {
                    this.put(LongMemory.valueOf(i), memory);
                }
                ++i;
            }
        } else {
            if (this.map == null) {
                this.convertToMap();
            }
            if (array.lastLongIndex > this.lastLongIndex) {
                this.lastLongIndex = array.lastLongIndex;
            }
            this.map.putAll(array.map);
        }
    }

    public ReferenceMemory putAsKeyString(String key, Memory value) {
        Pair<Memory, ArrayMapEntryMemory> result;
        if (this.map == null) {
            this.convertToMap();
        }
        if (!(result = this.map.putWithEntry(key, value)).hasA()) {
            ++this.size;
        }
        return result.getB();
    }

    public ReferenceMemory put(Object key, Memory value) {
        if (key instanceof LongMemory) {
            ReferenceMemory mem = new ReferenceMemory(value);
            int index = (int)((LongMemory)key).value;
            if ((long)index > this.lastLongIndex) {
                this.lastLongIndex = index;
            }
            if (this.map == null) {
                int size = this.getList().size();
                if (index >= 0) {
                    if (index < size) {
                        this.getList().set(index, mem);
                        return mem;
                    }
                    if (index == size) {
                        this.getList().add(mem);
                        ++this.size;
                        return mem;
                    }
                    this.convertToMap();
                } else {
                    this.convertToMap();
                }
            }
        } else {
            if (!(key instanceof String)) {
                key = key.toString();
            }
            if (this.map == null) {
                this.convertToMap();
            }
        }
        Pair<Memory, ArrayMapEntryMemory> result = this.map.putWithEntry(key, value);
        if (!result.hasA()) {
            ++this.size;
        }
        return result.getB();
    }

    public Memory removeByScalar(Object key) {
        Memory tmp;
        if (this.map == null) {
            Memory tmp2;
            int index = -1;
            if (key instanceof Long) {
                index = ((Long)key).intValue();
            } else if (key instanceof Integer) {
                index = (Integer)key;
            } else if (key instanceof String && (tmp2 = StringMemory.toLong((String)key)) != null) {
                index = (int)tmp2.toLong();
            }
            if (index < 0 || this._list == null || index >= this.getList().size()) {
                return null;
            }
            if (index == this.size - 1) {
                --this.size;
                this.lastLongIndex = this.size - 1;
                ReferenceMemory remove = this.getList().remove(index);
                if (this.getList().isEmpty()) {
                    this._list = null;
                }
                return remove;
            }
            key = (long)index;
            this.convertToMap();
        }
        if (key instanceof Long) {
            key = LongMemory.valueOf((Long)key);
        } else if (key instanceof Integer) {
            key = LongMemory.valueOf((Integer)key);
        } else if (key instanceof String && (tmp = StringMemory.toLong((String)key)) != null) {
            key = tmp;
        }
        Memory memory = this.map.remove(key);
        if (memory != null) {
            --this.size;
        }
        return memory;
    }

    public Memory remove(Memory key) {
        Memory memory;
        Object _key = ArrayMemory.toKey(key);
        if (this.map == null) {
            int index;
            int n = index = _key instanceof LongMemory ? (int)key.toLong() : -1;
            if (index < 0 || this._list == null || index >= this.getList().size()) {
                return null;
            }
            if (index == this.size - 1) {
                --this.size;
                this.lastLongIndex = index - 1;
                ReferenceMemory remove = this.getList().remove(index);
                if (this.getList().isEmpty()) {
                    this._list = null;
                }
                return remove;
            }
            this.convertToMap();
        }
        if ((memory = this.map.remove(_key)) != null) {
            --this.size;
        }
        return memory;
    }

    public int size() {
        return this.size;
    }

    public void unshift(Memory value, int count) {
        this.checkCopied();
        if (this.size == 0) {
            for (int i = 0; i < count; ++i) {
                this.add(value);
            }
        } else if (this.map == null) {
            ArrayList<ReferenceMemory> tmp = new ArrayList<ReferenceMemory>();
            for (int i = 0; i < count; ++i) {
                tmp.add(new ReferenceMemory(value));
            }
            this.getList().addAll(0, tmp);
            this.size = this.getList().size();
        } else {
            ArrayMemory tmp = new ArrayMemory();
            tmp.convertToMap();
            for (int i = 0; i < count; ++i) {
                tmp.add(value);
            }
            ForeachIterator iterator = this.getNewIterator(null, false, false);
            while (iterator.next()) {
                Object key = iterator.getKey();
                if (key instanceof String) {
                    tmp.put(key, iterator.getValue());
                    continue;
                }
                this.add(iterator.getValue());
            }
            this.lastLongIndex = tmp.lastLongIndex;
            this.map = tmp.map;
            this.size = tmp.size;
        }
    }

    public void unshift(Memory ... values) {
        this.checkCopied();
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.size == 0) {
            for (Memory value : values) {
                this.add(value);
            }
        } else if (this.map == null) {
            if (values.length > 1) {
                ArrayList<ReferenceMemory> tmp = new ArrayList<ReferenceMemory>();
                for (Memory value : values) {
                    tmp.add(new ReferenceMemory(value));
                }
                this.getList().addAll(0, tmp);
                this.size = this.getList().size();
            } else if (values.length == 1) {
                this.getList().add(0, new ReferenceMemory(values[0]));
                this.size = this.getList().size();
            }
        } else {
            ArrayMemory tmp = new ArrayMemory();
            tmp.convertToMap();
            for (Memory el : values) {
                tmp.add(el);
            }
            ForeachIterator iterator = this.getNewIterator(null, false, false);
            while (iterator.next()) {
                Object key = iterator.getKey();
                if (key instanceof String) {
                    tmp.put(key, iterator.getValue());
                    continue;
                }
                this.add(iterator.getValue());
            }
            this.lastLongIndex = tmp.lastLongIndex;
            this.map = tmp.map;
            this.size = tmp.size;
        }
    }

    public Memory shift() {
        Memory value;
        this.checkCopied();
        if (this.size < 1) {
            return null;
        }
        --this.size;
        if (this.map == null) {
            value = this.getList().get(0);
            this.getList().remove(0);
        } else {
            value = this.map.remove(this.map.firstKey());
        }
        return value.toValue();
    }

    public Memory pop() {
        Memory value;
        this.checkCopied();
        if (this.size < 1) {
            return null;
        }
        if (this.getList() != null) {
            value = this.getList().get(this.size - 1);
            this.getList().remove(this.size - 1);
        } else {
            value = this.map.remove(this.map.lastKey());
        }
        --this.size;
        return value.toValue();
    }

    public Memory peek() {
        if (this.size < 1) {
            return null;
        }
        Memory value = this.map == null ? (Memory)this.getList().get(this.size - 1) : this.map.get(this.map.lastKey());
        return value.toValue();
    }

    public Memory peekKey() {
        if (this.size < 1) {
            return null;
        }
        if (this.map == null) {
            return LongMemory.valueOf(this.size - 1);
        }
        Object key = this.map.lastKey();
        if (key instanceof Memory) {
            return (Memory)key;
        }
        if (key instanceof String) {
            return StringMemory.valueOf(key.toString());
        }
        return null;
    }

    public Memory getRandomElementKey(Random rnd) {
        int index = rnd.nextInt(this.size);
        if (this.map == null) {
            return LongMemory.valueOf(index);
        }
        Iterator<Object> keys = this.map.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            keys.next();
        }
        Object key = keys.next();
        if (key instanceof LongMemory) {
            return (LongMemory)key;
        }
        return new StringMemory((String)key);
    }

    public void shuffle(Random rnd) {
        this.checkCopied();
        if (this.map == null) {
            if (this._list != null) {
                Collections.shuffle(this.getList(), rnd);
            }
        } else {
            Set<Object> keys = this.map.keySet();
            ArrayList<Memory> values = new ArrayList<Memory>(this.map.values());
            Collections.shuffle(values, rnd);
            int i = 0;
            for (Object key : keys) {
                this.map.put(key, (Memory)values.get(i));
                ++i;
            }
        }
    }

    public void clear() {
        this._list = null;
        this.map = null;
        this.size = 0;
    }

    public int compare(ArrayMemory otherRef, boolean strict) {
        return this.compare(otherRef, strict, null);
    }

    public int compare(ArrayMemory otherRef, boolean strict, Set<Integer> used) {
        int size2;
        int size1 = this.size();
        if (size1 < (size2 = otherRef.size())) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        ForeachIterator iterator = this.foreachIterator(false, false);
        ForeachIterator iterator2 = null;
        if (strict) {
            iterator2 = otherRef.foreachIterator(false, false);
        }
        if (used == null) {
            used = new HashSet<Integer>();
        }
        while (iterator.next()) {
            Memory value2;
            Memory value1 = iterator.getValue();
            Memory key = iterator.getMemoryKey();
            if (iterator2 == null) {
                value2 = otherRef.get(key);
            } else {
                if (!iterator2.next()) {
                    return -2;
                }
                Object key2 = iterator2.getKey();
                if (!iterator.getKey().equals(key2)) {
                    return -2;
                }
                value2 = iterator2.getValue();
            }
            if (value2 == null) {
                value2 = UNDEFINED;
            }
            if (value1.isArray() && value2.isArray()) {
                ArrayMemory arr1 = value1.toValue(ArrayMemory.class);
                if (used.add(value2.getPointer())) {
                    int r = arr1.compare(value2.toValue(ArrayMemory.class), strict, used);
                    if (r == 0) {
                        used.remove(value2.getPointer());
                        continue;
                    }
                    return r;
                }
                used.remove(value2.getPointer());
                continue;
            }
            if (value1.isObject() && value2.isObject()) {
                ObjectMemory o1 = value1.toValue(ObjectMemory.class);
                ObjectMemory o2 = value2.toValue(ObjectMemory.class);
                return o1.compare(o2.value, strict, used);
            }
            if (strict && value1.identical(value2) || !strict && value1.equal(value2)) continue;
            if (value1.smaller(value2)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public Memory toImmutable() {
        if (this.copies >= 0) {
            ArrayMemory mem = new ArrayMemory();
            mem._list = this._list;
            mem.original = this;
            mem.size = this.size;
            mem._list = this._list;
            mem.map = this.map;
            mem.lastLongIndex = this.lastLongIndex;
            ++this.copies;
            this.reset();
            return mem;
        }
        ++this.copies;
        return this;
    }

    public ArrayMemory toConstant() {
        if (this.copies == 0) {
            --this.copies;
        } else {
            throw new RuntimeException("Cannot convert array to a constant value with copies != 0");
        }
        return this;
    }

    public Memory[] values(boolean asImmutable) {
        Memory[] result = new Memory[this.size];
        int i = 0;
        for (ReferenceMemory el : this) {
            result[i++] = asImmutable ? el.toImmutable() : el.toValue();
        }
        return result;
    }

    public Memory[] values() {
        return this.values(false);
    }

    @Override
    public long toLong() {
        return this.size == 0 ? 0L : 1L;
    }

    @Override
    public double toDouble() {
        return this.size == 0 ? 0.0 : 1.0;
    }

    @Override
    public boolean toBoolean() {
        return this.size != 0;
    }

    @Override
    public Memory toNumeric() {
        return this.size == 0 ? CONST_INT_0 : CONST_INT_1;
    }

    @Override
    public String toString() {
        return "Array";
    }

    @Override
    public Memory inc() {
        return this.toNumeric().inc();
    }

    @Override
    public Memory dec() {
        return this.toNumeric().dec();
    }

    @Override
    public Memory negative() {
        return this.toNumeric().negative();
    }

    @Override
    public Memory plus(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                ArrayMemory left = (ArrayMemory)this.toImmutable();
                ArrayMemory other = (ArrayMemory)memory;
                ForeachIterator iterator = other.foreachIterator(false, false);
                while (iterator.next()) {
                    Object key = iterator.getKey();
                    ReferenceMemory origin = this.getByScalar(key);
                    if (origin != null) continue;
                    left.checkCopied();
                    left.put(key, iterator.getValue().toImmutable());
                }
                return left;
            }
            case REFERENCE: {
                return this.plus(memory.toValue());
            }
        }
        return this.toNumeric().plus(memory);
    }

    @Override
    public Memory minus(Memory memory) {
        return this.toNumeric().minus(memory);
    }

    @Override
    public Memory mul(Memory memory) {
        return this.toNumeric().mul(memory);
    }

    @Override
    public Memory pow(Memory memory) {
        return this.toNumeric().pow(memory);
    }

    @Override
    public Memory div(Memory memory) {
        return this.toNumeric().div(memory);
    }

    @Override
    public boolean equal(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, false) == 0;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean notEqual(Memory memory) {
        return !this.equal(memory);
    }

    @Override
    public boolean smaller(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, false) == -1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean smallerEq(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                int r = this.compare((ArrayMemory)memory, false);
                return r == 0 || r == -1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean greater(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, false) == 1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean greaterEq(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                int r = this.compare((ArrayMemory)memory, false);
                return r == 0 || r == 1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public void unset() {
        if (this.original != null) {
            --this.original.copies;
            this.original = null;
        } else {
            --this.copies;
        }
        this.clear();
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        switch (index.getRealType()) {
            case ARRAY: 
            case OBJECT: {
                return UNDEFINED;
            }
        }
        Memory e = this.get(index);
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        ReferenceMemory e = this.getByScalar(LongMemory.valueOf(index));
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        ReferenceMemory e = this.getByScalar(LongMemory.valueOf((long)index));
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        ReferenceMemory e = this.getByScalar(index ? CONST_INT_0 : CONST_INT_1);
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        Memory number = StringMemory.toLong(index);
        ReferenceMemory e = number == null ? this.getByScalar(index) : this.getByScalar(number);
        return e == null ? UNDEFINED : e;
    }

    @Override
    public void unsetOfIndex(TraceInfo trace, Memory index) {
        this.checkCopied();
        this.remove(index);
    }

    @Override
    public Memory issetOfIndex(TraceInfo trace, Memory index) {
        Memory value = this.get(index);
        return value == null ? NULL : value;
    }

    @Override
    public Memory refOfPush(TraceInfo trace) {
        this.checkCopied();
        return this.add(UNDEFINED);
    }

    @Override
    public Memory refOfIndexAsShortcut(TraceInfo trace, Memory index) {
        switch (index.getRealType()) {
            case ARRAY: 
            case OBJECT: {
                return new ReferenceMemory();
            }
        }
        this.checkCopied();
        return this.getOrCreateAsShortcut(index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, Memory index) {
        switch (index.getRealType()) {
            case ARRAY: 
            case OBJECT: {
                return new ReferenceMemory();
            }
        }
        this.checkCopied();
        return this.getOrCreate(index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, long index) {
        this.checkCopied();
        return this.getOrCreate(LongMemory.valueOf(index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, double index) {
        return this.refOfIndex(null, LongMemory.valueOf((long)index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, boolean index) {
        this.checkCopied();
        return this.getOrCreate(index ? CONST_INT_1 : CONST_INT_0);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, String index) {
        this.checkCopied();
        Memory number = StringMemory.toLong(index);
        return number == null ? this.getByScalarOrCreate(index) : this.getByScalarOrCreate(number);
    }

    @Override
    public boolean identical(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, true) == 0;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean identical(long value) {
        return false;
    }

    @Override
    public boolean identical(double value) {
        return false;
    }

    @Override
    public boolean identical(boolean value) {
        return false;
    }

    @Override
    public boolean identical(String value) {
        return false;
    }

    @Override
    public Iterator<ReferenceMemory> iterator() {
        if (this.map == null) {
            return this.getList().iterator();
        }
        return this.map.entriesIterator();
    }

    public ForeachIterator foreachIterator(boolean getReferences, boolean withPrevious) {
        return this.foreachIterator(getReferences, false, withPrevious, true);
    }

    public ForeachIterator foreachIterator(boolean getReferences, boolean getKeyReferences, boolean withPrevious) {
        return this.foreachIterator(getReferences, getKeyReferences, withPrevious, true);
    }

    public ForeachIterator foreachIterator(boolean getReferences, boolean getKeyReferences, boolean withPrevious, final boolean freeze) {
        return new ForeachIterator(getReferences, getKeyReferences, withPrevious){
            protected int cursor;
            protected int listMax;
            protected Iterator<Object> keys;
            {
                super(getReferences, getKeyReferences, withPrevious);
                this.cursor = 0;
            }

            @Override
            public void reset() {
                if (this.getKeyReferences && ArrayMemory.this.map == null) {
                    ArrayMemory.this.convertToMap();
                }
                if (ArrayMemory.this.map != null) {
                    this.keys = this.withPrevious || this.getKeyReferences ? new ArrayList<Object>(ArrayMemory.this.map.keySet()).listIterator() : (freeze ? new ArrayList<Object>(ArrayMemory.this.map.keySet()).iterator() : ArrayMemory.this.map.keySet().iterator());
                } else {
                    this.listMax = ArrayMemory.this._list == null ? 0 : ArrayMemory.this.getList().size();
                }
            }

            @Override
            protected boolean init() {
                if (this.getKeyReferences && ArrayMemory.this.map == null) {
                    ArrayMemory.this.convertToMap();
                }
                if (ArrayMemory.this.map != null) {
                    this.keys = this.withPrevious || this.getKeyReferences ? new ArrayList<Object>(ArrayMemory.this.map.keySet()).listIterator() : new ArrayList<Object>(ArrayMemory.this.map.keySet()).iterator();
                } else {
                    this.listMax = ArrayMemory.this._list == null ? 0 : ArrayMemory.this.getList().size();
                }
                return true;
            }

            private void setCurrentValue(ReferenceMemory value) {
                this.currentValue = this.getReferences ? (this.plainReferences ? value : new ArrayValueMemory(this.getMemoryKey(), ArrayMemory.this, value)) : value.getValue();
                if (this.getKeyReferences) {
                    this.currentKeyMemory = new ArrayKeyMemory(ArrayMemory.this, this.getMemoryKey());
                }
            }

            @Override
            public boolean end() {
                if (ArrayMemory.this.size == 0) {
                    return false;
                }
                if (ArrayMemory.this.map == null) {
                    this.cursor = ArrayMemory.this.size - 1;
                    this.currentKey = (long)this.cursor;
                    this.setCurrentValue((ReferenceMemory)ArrayMemory.this.getList().get(this.cursor));
                    return true;
                }
                this.init = true;
                ArrayList<Object> tmp = new ArrayList<Object>(ArrayMemory.this.map.keySet());
                this.keys = tmp.listIterator(tmp.size() - 1);
                return this.keys.hasNext() && this.next();
            }

            @Override
            protected boolean prevValue() {
                if (ArrayMemory.this.map == null) {
                    if (this.cursor <= 0) {
                        this.currentKey = null;
                        this.currentValue = null;
                        --this.cursor;
                        this.keys = null;
                        return false;
                    }
                    --this.cursor;
                    this.currentKey = LongMemory.valueOf((long)this.cursor);
                    this.setCurrentValue((ReferenceMemory)ArrayMemory.this.getList().get(this.cursor));
                    return true;
                }
                ListIterator keyIterator = (ListIterator)this.keys;
                if (keyIterator.hasPrevious()) {
                    this.currentKey = keyIterator.previous();
                    this.setCurrentValue(ArrayMemory.this.map.getEntry(this.currentKey));
                    return true;
                }
                this.currentKey = null;
                this.currentValue = null;
                this.keys = null;
                this.cursor = -1;
                return false;
            }

            @Override
            protected boolean nextValue() {
                if (this.withPrevious && this.keys == null && this.cursor < 0) {
                    return false;
                }
                if (ArrayMemory.this.map == null) {
                    if (this.cursor >= this.listMax && freeze || this.cursor >= ArrayMemory.this.size && !freeze || ArrayMemory.this.size < this.listMax) {
                        this.currentKey = null;
                        this.currentValue = null;
                        return false;
                    }
                    this.currentKey = LongMemory.valueOf((long)this.cursor);
                    this.setCurrentValue((ReferenceMemory)ArrayMemory.this.getList().get(this.cursor));
                    ++this.cursor;
                    return true;
                }
                if (this.keys == null) {
                    ArrayList<Object> tmp = new ArrayList<Object>(ArrayMemory.this.map.keySet());
                    this.keys = tmp.listIterator(this.cursor - 1);
                }
                if (this.keys.hasNext()) {
                    this.currentKey = this.keys.next();
                    this.setCurrentValue(ArrayMemory.this.map.getEntry(this.currentKey));
                    return true;
                }
                this.currentKey = null;
                this.currentValue = null;
                return false;
            }
        };
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return this.foreachIterator(getReferences, getKeyReferences, false);
    }

    public ForeachIterator getCurrentIterator() {
        if (this.foreachIterator == null) {
            this.foreachIterator = this.foreachIterator(false, true);
        }
        return this.foreachIterator;
    }

    protected void reset() {
        this.foreachIterator = null;
    }

    public Memory resetCurrentIterator() {
        this.reset();
        ForeachIterator iterator = this.getCurrentIterator();
        if (this.size == 0) {
            return FALSE;
        }
        iterator.next();
        Memory tmp = iterator.getValue();
        iterator.prev();
        return tmp;
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return MemoryStringUtils.getBinaryBytes(this);
    }

    public boolean isList() {
        return this.map == null;
    }

    public boolean isMap() {
        return this.map != null;
    }

    @Override
    public Memory toArray() {
        return this;
    }

    @Override
    public Memory toObject(Environment env) {
        StdClass stdClass = new StdClass(env);
        ArrayMemory props = stdClass.getProperties();
        ForeachIterator iterator = this.getNewIterator(env, false, false);
        while (iterator.next()) {
            props.refOfIndex(null, iterator.getMemoryKey()).assign(iterator.getValue());
        }
        return new ObjectMemory(stdClass);
    }

    public int[] toIntArray() {
        int[] r = new int[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toInteger();
            ++i;
        }
        return r;
    }

    public long[] toLongArray() {
        long[] r = new long[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toLong();
            ++i;
        }
        return r;
    }

    public String[] toStringArray() {
        String[] r = new String[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toString();
            ++i;
        }
        return r;
    }

    public float[] toFloatArray() {
        float[] r = new float[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toFloat();
            ++i;
        }
        return r;
    }

    public double[] toDoubleArray() {
        double[] r = new double[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toDouble();
            ++i;
        }
        return r;
    }

    public boolean[] toBoolArray() {
        boolean[] r = new boolean[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toBoolean();
            ++i;
        }
        return r;
    }

    public <T extends IObject> List<T> toObjectArray(Class<T> clazz) {
        ArrayList<T> r = new ArrayList<T>();
        boolean i = false;
        for (Memory e : this) {
            if (e.instanceOf(clazz)) {
                r.add(e.toObject(clazz));
                continue;
            }
            throw new IllegalArgumentException(Messages.ERR_INVALID_ARRAY_ELEMENT_TYPE.fetch(ReflectionUtils.getClassName(clazz), ReflectionUtils.getGivenName(e)));
        }
        return r;
    }

    public Map<String, String> toStringMap() {
        LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toString());
        }
        return r;
    }

    public Map<String, Integer> toIntMap() {
        LinkedHashMap<String, Integer> r = new LinkedHashMap<String, Integer>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toInteger());
        }
        return r;
    }

    public Map<String, Long> toLongMap() {
        LinkedHashMap<String, Long> r = new LinkedHashMap<String, Long>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toLong());
        }
        return r;
    }

    public Map<String, Double> toDoubleMap() {
        LinkedHashMap<String, Double> r = new LinkedHashMap<String, Double>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toDouble());
        }
        return r;
    }

    public Map<String, Boolean> toBooleanMap() {
        LinkedHashMap<String, Boolean> r = new LinkedHashMap<String, Boolean>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toBoolean());
        }
        return r;
    }

    public <T extends IObject> Map<String, T> toObjectMap(Class<T> clazz) {
        LinkedHashMap<String, T> r = new LinkedHashMap<String, T>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            Memory e = iterator.getValue();
            if (e.instanceOf(clazz)) {
                r.put(iterator.getKey().toString(), e.toObject(clazz));
                continue;
            }
            throw new IllegalArgumentException(Messages.ERR_INVALID_ARRAY_ELEMENT_TYPE.fetch(ReflectionUtils.getClassName(clazz), ReflectionUtils.getGivenName(e)));
        }
        return r;
    }

    public static ArrayMemory ofPair(String key, Memory value) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex(key).assign(value.toImmutable());
        return r;
    }

    public static ArrayMemory ofPair(String key, String value) {
        return ArrayMemory.ofPair(key, StringMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, long value) {
        return ArrayMemory.ofPair(key, LongMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, double value) {
        return ArrayMemory.ofPair(key, DoubleMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, boolean value) {
        return ArrayMemory.ofPair(key, TrueMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, IObject value) {
        return ArrayMemory.ofPair(key, ObjectMemory.valueOf(value));
    }

    public static ArrayMemory ofShorts(short ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (short el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofIntegers(int ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (int el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofBytes(byte ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (byte el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofLongs(long ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (long el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofFloats(float ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (float el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofDoubles(double ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (double el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofBooleans(boolean ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (boolean el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofChars(char ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (char el : array) {
                result.add(StringMemory.valueOf(el));
            }
        }
        return result;
    }

    public static ArrayMemory ofStrings(String ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (String el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofStringCollection(Collection<String> list) {
        ArrayMemory result = new ArrayMemory();
        for (String el : list) {
            result.add(el);
        }
        return result;
    }

    public static ArrayMemory ofObjects(IObject ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (IObject el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory of(Memory ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (Memory el : array) {
                result.add(el.toImmutable());
            }
        }
        return result;
    }

    public static ArrayMemory ofCollection(Collection<Memory> list) {
        ArrayMemory result = new ArrayMemory();
        for (Memory el : list) {
            result.add(el.toImmutable());
        }
        return result;
    }

    public static ArrayMemory ofMap(Map<String, Memory> map) {
        ArrayMemory result = new ArrayMemory();
        for (Map.Entry<String, Memory> entry : map.entrySet()) {
            result.putAsKeyString(entry.getKey(), entry.getValue().toImmutable());
        }
        return result;
    }

    public static ArrayMemory ofStringMap(Map<String, String> map) {
        ArrayMemory result = new ArrayMemory();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.putAsKeyString(entry.getKey(), StringMemory.valueOf(entry.getValue()));
        }
        return result;
    }

    public static <T> ArrayMemory ofBean(Environment env, T anyObject) {
        return ArrayMemory.ofBean(env, env.trace(), anyObject);
    }

    public static <T> ArrayMemory ofBean(Environment env, TraceInfo trace, T anyObject) {
        Method[] methods = anyObject.getClass().getMethods();
        ArrayMemory value = new ArrayMemory(true);
        for (Method method : methods) {
            String name = method.getName();
            String key = null;
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                key = name.substring(3);
                key = name.length() == 4 ? key.toLowerCase() : key.substring(0, 1).toLowerCase() + key.substring(1);
            } else if (name.startsWith("is") && name.length() > 2 && method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                key = name.substring(2);
                key = name.length() == 3 ? key.toLowerCase() : key.substring(0, 1).toLowerCase() + key.substring(1);
            }
            if (key == null || "class".equals(key)) continue;
            try {
                Object invoke = method.invoke(anyObject, new Object[0]);
                MemoryOperation operation = MemoryOperation.get(method.getReturnType(), method.getGenericReturnType());
                if (operation == null) {
                    if (!ArrayMemory.isLikeBean(method.getReturnType())) continue;
                    value.put(key, ArrayMemory.ofNullableBean(env, invoke));
                    continue;
                }
                Memory memory = operation.unconvert(env, trace, invoke);
                value.put(key, memory);
            }
            catch (IllegalAccessException e) {
                throw new CriticalException(e);
            }
            catch (InvocationTargetException e) {
                env.__throwException(e);
            }
            catch (Throwable throwable) {
                env.wrapThrow(throwable);
            }
        }
        return value;
    }

    public static <T> Memory ofNullableBean(Environment env, T anyObject) {
        return ArrayMemory.ofNullableBean(env, env.trace(), anyObject);
    }

    public static <T> Memory ofNullableBean(Environment env, TraceInfo trace, T anyObject) {
        if (anyObject == null) {
            return NULL;
        }
        return ArrayMemory.ofBean(env, trace, anyObject);
    }

    public static <T> boolean isLikeBean(Class<T> anyClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = anyClass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public <T> T toBean(Environment env, Class<T> beanClass) {
        return this.toBean(env, env.trace(), beanClass);
    }

    public <T> T toBean(Environment env, TraceInfo trace, Class<T> beanClass) {
        try {
            Constructor<T> constructor = beanClass.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            ForeachIterator iterator = this.foreachIterator(false, false);
            while (iterator.next()) {
                String key = iterator.getStringKey();
                String name = key.substring(0, 1).toUpperCase() + key.substring(1);
                String getterName = "get" + name;
                String getterIsName = "is" + name;
                String setterName = "set" + name;
                try {
                    Method method = null;
                    try {
                        method = beanClass.getMethod(getterName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        method = beanClass.getMethod(getterIsName, new Class[0]);
                        if (method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) continue;
                    }
                    Class<?> returnType = method.getReturnType();
                    MemoryOperation operation = MemoryOperation.get(returnType, method.getGenericReturnType());
                    if (operation == null) continue;
                    method = beanClass.getMethod(setterName, returnType);
                    Object value = operation.convert(env, trace, iterator.getValue());
                    method.invoke(instance, value);
                }
                catch (NoSuchMethodException e) {
                }
                catch (Throwable throwable) {
                    env.wrapThrow(throwable);
                }
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CriticalException(e);
        }
    }

    public ArrayMemory slice(int offset) {
        return this.slice(offset, false);
    }

    public ArrayMemory slice(int offset, int length) {
        return this.slice(offset, length, false);
    }

    public ArrayMemory slice(int offset, boolean saveKeys) {
        ArrayMemory result = new ArrayMemory();
        if (offset < 0) {
            offset = this.size() + offset;
        }
        if (this.isList()) {
            int i = 0;
            try {
                for (ReferenceMemory referenceMemory : this.getList().subList(offset, this.getList().size())) {
                    if (saveKeys) {
                        result.refOfIndex(i + offset).assign(referenceMemory.toImmutable());
                    } else {
                        result.add(referenceMemory.toImmutable());
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        } else {
            int i = 0;
            ForeachIterator iterator = this.foreachIterator(false, false);
            while (iterator.next()) {
                if (i >= offset) {
                    if (saveKeys || !iterator.isLongKey()) {
                        result.put(iterator.getKey(), iterator.getValue().toImmutable());
                    } else {
                        result.add(iterator.getValue().toImmutable());
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public ArrayMemory slice(int offset, int length, boolean saveKeys) {
        ArrayMemory result = new ArrayMemory();
        if (offset < 0) {
            offset = this.size() + offset;
        }
        if (length < 0) {
            length = this.size() + length - offset;
        }
        if (this.isList()) {
            int i = 0;
            try {
                for (ReferenceMemory referenceMemory : this.getList().subList(offset, offset + length)) {
                    if (saveKeys) {
                        result.refOfIndex(i + offset).assign(referenceMemory.toImmutable());
                    } else {
                        result.add(referenceMemory.toImmutable());
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        } else {
            int i = 0;
            int count = 0;
            ForeachIterator iterator = this.foreachIterator(false, false);
            while (iterator.next()) {
                if (i >= offset) {
                    ++count;
                    if (saveKeys || !iterator.isLongKey()) {
                        result.put(iterator.getKey(), iterator.getValue().toImmutable());
                    } else {
                        result.add(iterator.getValue().toImmutable());
                    }
                    if (count >= length) break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayMemory that = (ArrayMemory)o;
        if (this.original != null ? !this.original.equals(that.original) : that.original != null) {
            return false;
        }
        if (this._list != null ? !this._list.equals(that._list) : that._list != null) {
            return false;
        }
        return this.map != null ? this.map.equals(that.map) : that.map == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.original != null ? this.original.hashCode() : 0);
        result = 31 * result + (this._list != null ? this._list.hashCode() : 0);
        result = 31 * result + (this.map != null ? this.map.hashCode() : 0);
        return result;
    }
}

