/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.lang.StdClass;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.FalseMemory;
import php.runtime.memory.ObjectMemory;

public class NullMemory
extends FalseMemory {
    public static final NullMemory INSTANCE = new NullMemory();

    protected NullMemory() {
        super(Memory.Type.NULL);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    @Override
    public boolean identical(Memory memory) {
        return memory.getRealType() == Memory.Type.NULL;
    }

    @Override
    public boolean identical(boolean value) {
        return false;
    }

    @Override
    public Memory inc() {
        return CONST_INT_1;
    }

    @Override
    public Memory dec() {
        return CONST_INT_M1;
    }

    @Override
    public Memory toArray() {
        return new ArrayMemory().toConstant();
    }

    @Override
    public Memory toObject(Environment env) {
        return new ObjectMemory(new StdClass(env));
    }
}

