/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.CharMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringBuilderMemory;
import php.runtime.memory.StringMemory;

public class ReferenceMemory
extends Memory {
    private Memory _value;

    protected ReferenceMemory(Memory.Type type, Memory value) {
        super(type);
        this._value = value;
    }

    public ReferenceMemory(Memory value) {
        super(Memory.Type.REFERENCE);
        this._value = value == null ? Memory.NULL : value;
    }

    public static Memory valueOf(Memory value) {
        return new ReferenceMemory(value);
    }

    public ReferenceMemory() {
        super(Memory.Type.REFERENCE);
        this._value = Memory.NULL;
    }

    public ReferenceMemory duplicate() {
        return new ReferenceMemory(this.getValue().toImmutable());
    }

    public Memory getValue() {
        return this._value;
    }

    public Memory setValue(Memory value) {
        this._value = value;
        return this._value;
    }

    @Override
    public int getPointer() {
        return this.getValue().getPointer();
    }

    @Override
    public int getPointer(boolean absolute) {
        return absolute ? this.getValue().getPointer() : this.getPointer();
    }

    @Override
    public long toLong() {
        return this.getValue().toLong();
    }

    @Override
    public double toDouble() {
        return this.getValue().toDouble();
    }

    @Override
    public boolean toBoolean() {
        return this.getValue().toBoolean();
    }

    @Override
    public Memory toNumeric() {
        return this.getValue().toNumeric();
    }

    @Override
    public String toString() {
        return this.getValue().toString();
    }

    @Override
    public char toChar() {
        return this.getValue().toChar();
    }

    @Override
    public boolean isNull() {
        return this.getValue().isNull();
    }

    @Override
    public boolean isObject() {
        return this.getValue().isObject();
    }

    @Override
    public boolean isResource() {
        return this.getValue().isResource();
    }

    @Override
    public boolean isArray() {
        return this.getValue().isArray();
    }

    @Override
    public boolean isString() {
        return this.getValue().isString();
    }

    @Override
    public boolean isNumber() {
        return this.getValue().isNumber();
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public Memory inc() {
        return this.getValue().inc();
    }

    @Override
    public Memory dec() {
        return this.getValue().dec();
    }

    @Override
    public Memory negative() {
        return this.getValue().negative();
    }

    @Override
    public Memory plus(Memory memory) {
        return this.getValue().plus(memory);
    }

    @Override
    public Memory plus(long value) {
        return this.getValue().plus(value);
    }

    @Override
    public Memory plus(double value) {
        return this.getValue().plus(value);
    }

    @Override
    public Memory plus(boolean value) {
        return this.getValue().plus(value);
    }

    @Override
    public Memory plus(String value) {
        return this.getValue().plus(value);
    }

    @Override
    public Memory minus(Memory memory) {
        return this.getValue().minus(memory);
    }

    @Override
    public Memory minus(double value) {
        return this.getValue().minus(value);
    }

    @Override
    public Memory minus(boolean value) {
        return this.getValue().minus(value);
    }

    @Override
    public Memory minus(String value) {
        return this.getValue().minus(value);
    }

    @Override
    public Memory minus(long value) {
        return this.getValue().minus(value);
    }

    @Override
    public Memory mul(Memory memory) {
        return this.getValue().mul(memory);
    }

    @Override
    public Memory mul(long value) {
        return this.getValue().mul(value);
    }

    @Override
    public Memory mul(double value) {
        return this.getValue().mul(value);
    }

    @Override
    public Memory mul(boolean value) {
        return this.getValue().mul(value);
    }

    @Override
    public Memory mul(String value) {
        return this.getValue().mul(value);
    }

    @Override
    public Memory pow(Memory memory) {
        return this.getValue().pow(memory);
    }

    @Override
    public Memory pow(long value) {
        return this.getValue().pow(value);
    }

    @Override
    public Memory pow(double value) {
        return this.getValue().pow(value);
    }

    @Override
    public Memory pow(boolean value) {
        return this.getValue().pow(value);
    }

    @Override
    public Memory pow(String value) {
        return this.getValue().pow(value);
    }

    @Override
    public Memory div(Memory memory) {
        return this.getValue().div(memory);
    }

    @Override
    public Memory div(long value) {
        return this.getValue().div(value);
    }

    @Override
    public Memory div(double value) {
        return this.getValue().div(value);
    }

    @Override
    public Memory div(boolean value) {
        return this.getValue().div(value);
    }

    @Override
    public Memory div(String value) {
        return this.getValue().div(value);
    }

    @Override
    public Memory mod(long value) {
        return this.getValue().mod(value);
    }

    @Override
    public Memory mod(double value) {
        return this.getValue().mod(value);
    }

    @Override
    public Memory mod(boolean value) {
        return this.getValue().mod(value);
    }

    @Override
    public Memory mod(String value) {
        return this.getValue().mod(value);
    }

    @Override
    public boolean equal(Memory memory) {
        return this.getValue().equal(memory);
    }

    @Override
    public boolean equal(long value) {
        return this.getValue().equal(value);
    }

    @Override
    public boolean equal(double value) {
        return this.getValue().equal(value);
    }

    @Override
    public boolean equal(boolean value) {
        return this.getValue().equal(value);
    }

    @Override
    public boolean equal(String value) {
        return this.getValue().equal(value);
    }

    @Override
    public boolean notEqual(Memory memory) {
        return this.getValue().notEqual(memory);
    }

    @Override
    public boolean notEqual(long value) {
        return this.getValue().notEqual(value);
    }

    @Override
    public boolean notEqual(double value) {
        return this.getValue().notEqual(value);
    }

    @Override
    public boolean notEqual(boolean value) {
        return this.getValue().notEqual(value);
    }

    @Override
    public boolean notEqual(String value) {
        return this.getValue().notEqual(value);
    }

    @Override
    public String concat(Memory memory) {
        return this.getValue().concat(memory);
    }

    @Override
    public String concat(long value) {
        return this.getValue().concat(value);
    }

    @Override
    public String concat(double value) {
        return this.getValue().concat(value);
    }

    @Override
    public String concat(boolean value) {
        return this.getValue().concat(value);
    }

    @Override
    public String concat(String value) {
        return this.getValue().concat(value);
    }

    @Override
    public boolean smaller(Memory memory) {
        return this.getValue().smaller(memory);
    }

    @Override
    public boolean smaller(long value) {
        return this.getValue().smaller(value);
    }

    @Override
    public boolean smaller(double value) {
        return this.getValue().smaller(value);
    }

    @Override
    public boolean smaller(boolean value) {
        return this.getValue().smaller(value);
    }

    @Override
    public boolean smaller(String value) {
        return this.getValue().smaller(value);
    }

    @Override
    public boolean smallerEq(Memory memory) {
        return this.getValue().smallerEq(memory);
    }

    @Override
    public boolean smallerEq(long value) {
        return this.getValue().smallerEq(value);
    }

    @Override
    public boolean smallerEq(double value) {
        return this.getValue().smallerEq(value);
    }

    @Override
    public boolean smallerEq(boolean value) {
        return this.getValue().smallerEq(value);
    }

    @Override
    public boolean smallerEq(String value) {
        return this.getValue().smallerEq(value);
    }

    @Override
    public boolean greater(Memory memory) {
        return this.getValue().greater(memory);
    }

    @Override
    public boolean greater(long value) {
        return this.getValue().greater(value);
    }

    @Override
    public boolean greater(double value) {
        return this.getValue().greater(value);
    }

    @Override
    public boolean greater(boolean value) {
        return this.getValue().greater(value);
    }

    @Override
    public boolean greater(String value) {
        return this.getValue().greater(value);
    }

    @Override
    public boolean greaterEq(Memory memory) {
        return this.getValue().greaterEq(memory);
    }

    @Override
    public boolean greaterEq(long value) {
        return this.getValue().greaterEq(value);
    }

    @Override
    public boolean greaterEq(double value) {
        return this.getValue().greaterEq(value);
    }

    @Override
    public boolean greaterEq(boolean value) {
        return this.getValue().greaterEq(value);
    }

    @Override
    public boolean greaterEq(String value) {
        return this.getValue().greaterEq(value);
    }

    @Override
    public Memory bitAnd(Memory memory) {
        return this.getValue().bitAnd(memory);
    }

    @Override
    public Memory bitAnd(long memory) {
        return this.getValue().bitAnd(memory);
    }

    @Override
    public Memory bitAnd(double memory) {
        return this.getValue().bitAnd(memory);
    }

    @Override
    public Memory bitAnd(boolean memory) {
        return this.getValue().bitAnd(memory);
    }

    @Override
    public Memory bitAnd(String memory) {
        return this.getValue().bitAnd(memory);
    }

    @Override
    public Memory bitOr(Memory memory) {
        return this.getValue().bitOr(memory);
    }

    @Override
    public Memory bitOr(long memory) {
        return this.getValue().bitOr(memory);
    }

    @Override
    public Memory bitOr(double memory) {
        return this.getValue().bitOr(memory);
    }

    @Override
    public Memory bitOr(boolean memory) {
        return this.getValue().bitOr(memory);
    }

    @Override
    public Memory bitOr(String memory) {
        return this.getValue().bitOr(memory);
    }

    @Override
    public Memory bitXor(Memory memory) {
        return this.getValue().bitXor(memory);
    }

    @Override
    public Memory bitXor(long memory) {
        return this.getValue().bitXor(memory);
    }

    @Override
    public Memory bitXor(double memory) {
        return this.getValue().bitXor(memory);
    }

    @Override
    public Memory bitXor(boolean memory) {
        return this.getValue().bitXor(memory);
    }

    @Override
    public Memory bitXor(String memory) {
        return this.getValue().bitXor(memory);
    }

    @Override
    public Memory bitNot() {
        return this.getValue().bitNot();
    }

    @Override
    public Memory bitShr(Memory memory) {
        return this.getValue().bitShr(memory);
    }

    @Override
    public Memory bitShr(long memory) {
        return this.getValue().bitShr(memory);
    }

    @Override
    public Memory bitShr(double memory) {
        return this.getValue().bitShr(memory);
    }

    @Override
    public Memory bitShr(boolean memory) {
        return this.getValue().bitShr(memory);
    }

    @Override
    public Memory bitShr(String memory) {
        return this.getValue().bitShr(memory);
    }

    @Override
    public Memory bitShl(Memory memory) {
        return this.getValue().bitShl(memory);
    }

    @Override
    public Memory bitShl(long memory) {
        return this.getValue().bitShl(memory);
    }

    @Override
    public Memory bitShl(double memory) {
        return this.getValue().bitShl(memory);
    }

    @Override
    public Memory bitShl(boolean memory) {
        return this.getValue().bitShl(memory);
    }

    @Override
    public Memory bitShl(String memory) {
        return this.getValue().bitShl(memory);
    }

    @Override
    public Memory newKeyValue(Memory memory) {
        return this.getValue().newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(long memory) {
        return this.getValue().newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(double memory) {
        return this.getValue().newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(boolean memory) {
        return this.getValue().newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(String memory) {
        return this.getValue().newKeyValue(memory);
    }

    @Override
    public Memory toImmutable() {
        switch (this.getValue().type) {
            case NULL: 
            case REFERENCE: 
            case ARRAY: {
                return this.getValue().toImmutable();
            }
        }
        return this.getValue();
    }

    @Override
    public <T extends Memory> T toValue(Class<T> clazz) {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().toValue(clazz);
            }
        }
        return (T)this.getValue();
    }

    @Override
    public Memory toValue() {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().toValue();
            }
        }
        return this.getValue();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Memory assign(Memory memory) {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().assign(memory);
            }
        }
        return this.setValue(memory);
    }

    public ReferenceMemory getReference() {
        if (this.getValue().type == Memory.Type.REFERENCE) {
            return ((ReferenceMemory)this.getValue()).getReference();
        }
        return this;
    }

    @Override
    public Memory assignRef(Memory reference) {
        if (reference.isReference()) {
            reference = ((ReferenceMemory)reference).getReference();
        }
        if (reference == this) {
            return reference;
        }
        this.setValue(reference);
        return reference;
    }

    @Override
    public Memory assign(long memory) {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().assign(memory);
            }
            case ARRAY: {
                this.getValue().unset();
            }
        }
        return this.setValue(LongMemory.valueOf(memory));
    }

    @Override
    public Memory assign(String memory) {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().assign(memory);
            }
            case ARRAY: {
                this.getValue().unset();
            }
        }
        return this.setValue(StringMemory.valueOf(memory));
    }

    @Override
    public Memory assign(boolean memory) {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().assign(memory);
            }
            case ARRAY: {
                this.getValue().unset();
            }
        }
        return this.setValue(memory ? TRUE : FALSE);
    }

    @Override
    public Memory assign(double memory) {
        switch (this.getValue().type) {
            case REFERENCE: {
                return this.getValue().assign(memory);
            }
            case ARRAY: {
                this.getValue().unset();
            }
        }
        return this.setValue(new DoubleMemory(memory));
    }

    private StringMemory typeString() {
        if (this.toValue().type != Memory.Type.STRING) {
            this.assign(new StringMemory(this.getValue().toString()));
        }
        return (StringMemory)this.toImmutable();
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return this.getValue().getBinaryBytes(charset);
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public void unset() {
        this.setValue(UNDEFINED);
    }

    @Override
    public void manualUnset(Environment env) {
        if (this.getValue().isObject()) {
            this.getValue().manualUnset(env);
        }
        this.unset();
    }

    public void needArray() {
        Memory.Type type = this.getRealType();
        if (type != Memory.Type.STRING && type != Memory.Type.ARRAY && type != Memory.Type.OBJECT) {
            this.assign(new ArrayMemory());
        }
    }

    public StringBuilderMemory needStringBuilder() {
        Memory value = this.toValue();
        if (value instanceof StringBuilderMemory) {
            return (StringBuilderMemory)value;
        }
        StringBuilderMemory builderMemory = new StringBuilderMemory(this.getValue().toString());
        this.assign(builderMemory);
        return builderMemory;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        return this.getValue().valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        return this.getValue().valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        return this.getValue().valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        return this.getValue().valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        return this.getValue().valueOfIndex(trace, index);
    }

    @Override
    public Memory refOfPush(TraceInfo trace) {
        this.needArray();
        return this.getValue().refOfPush(trace);
    }

    @Override
    public Memory refOfIndexAsShortcut(TraceInfo trace, Memory index) {
        this.needArray();
        switch (this.getValue().type) {
            case STRING: {
                return this.refOfIndex(trace, index);
            }
        }
        return this.getValue().refOfIndexAsShortcut(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, Memory index) {
        this.needArray();
        switch (this.getValue().type) {
            case STRING: {
                if (index.isString()) {
                    int _index = -1;
                    Memory tmp = StringMemory.toLong(index.toString());
                    if (tmp != null) {
                        _index = tmp.toInteger();
                    }
                    return CharMemory.valueOf(this, (StringMemory)this.getValue(), _index);
                }
                return CharMemory.valueOf(this, (StringMemory)this.getValue(), (int)index.toNumeric().toLong());
            }
        }
        return this.getValue().refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, long index) {
        this.needArray();
        switch (this.getValue().type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.getValue(), (int)index);
            }
        }
        return this.getValue().refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, double index) {
        this.needArray();
        switch (this.getValue().type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.getValue(), (int)index);
            }
        }
        return this.getValue().refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, String index) {
        this.needArray();
        int _index = -1;
        Memory tmp = StringMemory.toLong(index);
        if (tmp != null) {
            _index = tmp.toInteger();
        }
        switch (this.getValue().type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.getValue(), _index);
            }
        }
        return this.getValue().refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, boolean index) {
        this.needArray();
        switch (this.getValue().type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.getValue(), index ? 1 : 0);
            }
        }
        return this.getValue().refOfIndex(trace, index);
    }

    @Override
    public void unsetOfIndex(TraceInfo trace, Memory index) {
        this.getValue().unsetOfIndex(trace, index);
    }

    @Override
    public Memory issetOfIndex(TraceInfo trace, Memory index) {
        return this.getValue().issetOfIndex(trace, index);
    }

    @Override
    public Memory emptyOfIndex(TraceInfo trace, Memory index) {
        return this.getValue().emptyOfIndex(trace, index);
    }

    @Override
    public boolean isShortcut() {
        return this.getValue().isReference();
    }

    @Override
    public boolean identical(Memory memory) {
        return this.getValue().identical(memory);
    }

    @Override
    public boolean identical(long value) {
        return this.getValue().identical(value);
    }

    @Override
    public boolean identical(double value) {
        return this.getValue().identical(value);
    }

    @Override
    public boolean identical(boolean value) {
        return this.getValue().identical(value);
    }

    @Override
    public boolean identical(String value) {
        return this.getValue().identical(value);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return this.getValue().getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public Memory.Type getRealType() {
        if (this.getValue().type == Memory.Type.REFERENCE) {
            return this.getValue().getRealType();
        }
        return this.getValue().type;
    }

    @Override
    public Memory assignConcat(Memory memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(long memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(double memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(boolean memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(String memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public boolean instanceOf(String className, String lowerClassName) {
        return this.getValue().instanceOf(className, lowerClassName);
    }

    @Override
    public boolean instanceOf(String name) {
        return this.getValue().instanceOf(name);
    }

    @Override
    public Memory toArray() {
        return this.getValue().toArray();
    }

    @Override
    public Memory toObject(Environment env) {
        return this.getValue().toObject(env);
    }

    @Override
    public Memory clone(Environment env, TraceInfo trace) throws Throwable {
        return this.getValue().clone(env, trace);
    }

    @Override
    public boolean isClosure() {
        return this.getValue().isClosure();
    }

    @Override
    public String toBinaryString() {
        return this.getValue().toBinaryString();
    }

    @Override
    public boolean instanceOf(Class<? extends IObject> clazz) {
        return this.getValue().instanceOf(clazz);
    }

    @Override
    public <T extends IObject> T toObject(Class<T> clazz) {
        return this.getValue().toObject(clazz);
    }

    @Override
    public int compareTo(Memory o) {
        return this.getValue().compareTo(o);
    }
}

