/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.ext.java.JavaObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;

public class MemoryUtils {
    protected static final Map<Class<?>, Unconverter> UNCONVERTERS = new HashMap<Class<?>, Unconverter>(){
        {
            this.put(Double.class, new Unconverter<Double>(){

                @Override
                public Memory run(Double value) {
                    return new DoubleMemory(value);
                }
            });
            this.put(Double.TYPE, this.get(Double.class));
            this.put(Float.class, new Unconverter<Float>(){

                @Override
                public Memory run(Float value) {
                    return new DoubleMemory(value.floatValue());
                }
            });
            this.put(Float.TYPE, this.get(Float.class));
            this.put(Long.class, new Unconverter<Long>(){

                @Override
                public Memory run(Long value) {
                    return LongMemory.valueOf(value);
                }
            });
            this.put(Long.TYPE, this.get(Long.class));
            this.put(Integer.class, new Unconverter<Integer>(){

                @Override
                public Memory run(Integer value) {
                    return LongMemory.valueOf(value);
                }
            });
            this.put(Integer.TYPE, this.get(Integer.class));
            this.put(Short.class, new Unconverter<Short>(){

                @Override
                public Memory run(Short value) {
                    return LongMemory.valueOf(value);
                }
            });
            this.put(Short.TYPE, this.get(Short.class));
            this.put(Short.class, new Unconverter<Byte>(){

                @Override
                public Memory run(Byte value) {
                    return LongMemory.valueOf(value);
                }
            });
            this.put(Byte.TYPE, this.get(Byte.class));
            this.put(Character.class, new Unconverter<Character>(){

                @Override
                public Memory run(Character value) {
                    return new StringMemory(value.charValue());
                }
            });
            this.put(Character.TYPE, this.get(Character.class));
            this.put(Boolean.class, new Unconverter<Boolean>(){

                @Override
                public Memory run(Boolean value) {
                    return value != false ? Memory.TRUE : Memory.FALSE;
                }
            });
            this.put(Boolean.TYPE, this.get(Boolean.class));
            this.put(String.class, new Unconverter<String>(){

                @Override
                public Memory run(String value) {
                    return new StringMemory(value);
                }
            });
            this.put(Memory.class, new Unconverter<Memory>(){

                @Override
                public Memory run(Memory value) {
                    return value;
                }
            });
            this.put(Memory[].class, new Unconverter<Memory[]>(){

                @Override
                public Memory run(Memory[] value) {
                    return new ArrayMemory(false, value);
                }
            });
        }
    };
    protected static final Map<Class<?>, Converter> CONVERTERS = new HashMap<Class<?>, Converter>(){
        {
            this.put(Double.class, new Converter<Double>(){

                @Override
                public Double run(Environment env, TraceInfo trace, Memory value) {
                    return value.toDouble();
                }
            });
            this.put(Double.TYPE, this.get(Double.class));
            this.put(Float.class, new Converter<Float>(){

                @Override
                public Float run(Environment env, TraceInfo trace, Memory value) {
                    return Float.valueOf((float)value.toDouble());
                }
            });
            this.put(Float.TYPE, this.get(Float.class));
            this.put(Long.class, new Converter<Long>(){

                @Override
                public Long run(Environment env, TraceInfo trace, Memory value) {
                    return value.toLong();
                }
            });
            this.put(Long.TYPE, this.get(Long.class));
            this.put(Integer.class, new Converter<Integer>(){

                @Override
                public Integer run(Environment env, TraceInfo trace, Memory value) {
                    return (int)value.toLong();
                }
            });
            this.put(Integer.TYPE, this.get(Integer.class));
            this.put(Short.class, new Converter<Short>(){

                @Override
                public Short run(Environment env, TraceInfo trace, Memory value) {
                    return (short)value.toLong();
                }
            });
            this.put(Short.TYPE, this.get(Short.class));
            this.put(Byte.class, new Converter<Byte>(){

                @Override
                public Byte run(Environment env, TraceInfo trace, Memory value) {
                    return (byte)value.toLong();
                }
            });
            this.put(Byte.TYPE, this.get(Byte.class));
            this.put(Character.class, new Converter<Character>(){

                @Override
                public Character run(Environment env, TraceInfo trace, Memory value) {
                    return Character.valueOf(value.toChar());
                }
            });
            this.put(Character.TYPE, this.get(Character.class));
            this.put(Boolean.class, new Converter<Boolean>(){

                @Override
                public Boolean run(Environment env, TraceInfo trace, Memory value) {
                    return value.toBoolean();
                }
            });
            this.put(Boolean.TYPE, this.get(Boolean.class));
            this.put(String.class, new Converter<String>(){

                @Override
                public String run(Environment env, TraceInfo trace, Memory value) {
                    return value.toString();
                }
            });
            this.put(Memory.class, new Converter<Memory>(){

                @Override
                public Memory run(Environment env, TraceInfo trace, Memory value) {
                    return value;
                }
            });
            this.put(Memory[].class, new Converter<Memory[]>(){

                @Override
                public Memory[] run(Environment env, TraceInfo trace, Memory value) {
                    if (value.isArray()) {
                        ArrayList<Memory> result = new ArrayList<Memory>();
                        for (Memory one : (ArrayMemory)value) {
                            result.add(one.toImmutable());
                        }
                        return result.toArray(new Memory[0]);
                    }
                    return null;
                }
            });
        }
    };

    public static Converter<?> getConverter(Class<?> type) {
        return CONVERTERS.get(type);
    }

    public static Converter<?>[] getConverters(Class<?>[] types) {
        Converter[] result = new Converter[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = MemoryUtils.getConverter(types[i]);
        }
        return result;
    }

    public static Unconverter getUnconverter(Class<?> type) {
        return UNCONVERTERS.get(type);
    }

    public static Object fromMemory(Memory value, Class<?> type) {
        if (value.instanceOf("php\\lang\\JavaObject")) {
            return ((JavaObject)value.toValue(ObjectMemory.class).value).getObject();
        }
        Converter<?> converter = MemoryUtils.getConverter(type);
        if (converter != null) {
            return converter.run(value);
        }
        return value;
    }

    @Deprecated
    public static Object toValue(Memory value, Class<?> type) {
        if (type == Double.TYPE || type == Double.class) {
            return value.toDouble();
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf((float)value.toDouble());
        }
        if (type == Long.TYPE || type == Long.class) {
            return value.toLong();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (int)value.toLong();
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)value.toLong();
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)value.toLong();
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(value.toChar());
        }
        if (type == String.class) {
            return value.toString();
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return value.toBoolean();
        }
        if (type == Memory.class) {
            return value;
        }
        if (type == Memory[].class) {
            if (value.isArray()) {
                ArrayList<Memory> result = new ArrayList<Memory>();
                for (Memory one : (ArrayMemory)value) {
                    result.add(one.toImmutable());
                }
                return result.toArray(new Memory[0]);
            }
            return null;
        }
        throw new IllegalArgumentException("Unexpected class type: " + type.getName());
    }

    @Deprecated
    public static Memory valueOf(Object value) {
        return MemoryUtils.valueOf(null, value);
    }

    @Deprecated
    public static Memory valueOf(Environment env, Object value) {
        if (value == null) {
            return Memory.NULL;
        }
        Unconverter unconverter = MemoryUtils.getUnconverter(value.getClass());
        if (unconverter != null) {
            return unconverter.run(value);
        }
        if (value instanceof Memory) {
            return (Memory)value;
        }
        if (env == null) {
            if (value instanceof Collection) {
                ArrayMemory result = new ArrayMemory();
                for (Object el : (Collection)value) {
                    result.add(MemoryUtils.valueOf(el));
                }
                return result;
            }
            if (value instanceof Map) {
                ArrayMemory result = new ArrayMemory();
                for (Map.Entry el : ((Map)value).entrySet()) {
                    result.refOfIndex(MemoryUtils.valueOf(el.getKey())).assign(MemoryUtils.valueOf(el.getValue()));
                }
                return result;
            }
            if (value.getClass().isArray()) {
                ArrayMemory result = new ArrayMemory();
                for (Object el : (Object[])value) {
                    result.add(MemoryUtils.valueOf(el));
                }
                return result;
            }
        }
        if (env != null) {
            return new ObjectMemory(JavaObject.of(env, value));
        }
        return null;
    }

    @Deprecated
    public static Memory valueOf(String value, HintType type) {
        switch (type) {
            case STRING: {
                return new StringMemory(value);
            }
            case ANY: {
                if (value.equals("false")) {
                    return Memory.FALSE;
                }
                if (value.equals("true")) {
                    return Memory.TRUE;
                }
                if (value.equalsIgnoreCase("null")) {
                    return Memory.NULL;
                }
                Memory m = StringMemory.toNumeric(value, false, null);
                return m != null ? m : new StringMemory(value);
            }
            case DOUBLE: {
                return new DoubleMemory(Double.parseDouble(value));
            }
            case INT: {
                return LongMemory.valueOf(Long.parseLong(value));
            }
            case ARRAY: {
                return new ArrayMemory();
            }
            case BOOLEAN: {
                return new StringMemory(value).toBoolean() ? Memory.TRUE : Memory.FALSE;
            }
            case CALLABLE: {
                return new StringMemory(value);
            }
        }
        throw new IllegalArgumentException("Unsupported type - " + (Object)((Object)type));
    }

    public static Memory valueForList(Memory memory, long index) {
        if (memory.isArray()) {
            return memory.valueOfIndex(index);
        }
        return Memory.NULL;
    }

    public static Memory valueForList(Memory memory, String index) {
        if (memory.isArray()) {
            return memory.valueOfIndex(index);
        }
        return Memory.NULL;
    }

    public static Memory valueForList(Memory memory, Memory index) {
        if (memory.isArray()) {
            return memory.valueOfIndex(index);
        }
        return Memory.NULL;
    }

    public static interface Unconverter<T> {
        public Memory run(T var1);
    }

    public static abstract class Converter<T> {
        public abstract T run(Environment var1, TraceInfo var2, Memory var3);

        public final T run(Memory value) {
            return this.run(null, null, value);
        }
    }
}

