/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.util.generator;

import java.util.NoSuchElementException;
import java.util.concurrent.SynchronousQueue;
import php.runtime.util.generator.CollectionAbortedException;
import php.runtime.util.generator.Collector;
import php.runtime.util.generator.ResultHandler;
import php.runtime.util.generator.YieldAdapter;
import php.runtime.util.generator.YieldAdapterIterable;
import php.runtime.util.generator.YieldAdapterIterator;

public class ThreadedYieldAdapter<T>
implements YieldAdapter<T> {
    @Override
    public YieldAdapterIterable<T> adapt(final Collector<T> client) {
        return new YieldAdapterIterable<T>(){

            @Override
            public YieldAdapterIterator<T> iterator() {
                final SynchronousQueue synchronousQueue = new SynchronousQueue();
                final SynchronousQueue returnQueue = new SynchronousQueue();
                final VarContainer<2> collectThread = new VarContainer<2>();
                final YieldAdapterIterator iterator = new YieldAdapterIterator<T>(){
                    private Message messageWaiting = null;

                    @Override
                    public boolean hasNext() {
                        this.readNextMessage();
                        return !StopMessage.class.isAssignableFrom(this.messageWaiting.getClass());
                    }

                    @Override
                    public T next() {
                        this.readNextMessage();
                        if (StopMessage.class.isAssignableFrom(this.messageWaiting.getClass())) {
                            throw new NoSuchElementException();
                        }
                        this.currentValue = ((ValueMessage)this.messageWaiting).value;
                        Object value = this.currentValue;
                        this.messageWaiting = null;
                        return value;
                    }

                    private void readNextMessage() {
                        if (this.messageWaiting == null) {
                            try {
                                returnQueue.put(new Object());
                                this.messageWaiting = (Message)synchronousQueue.take();
                            }
                            catch (InterruptedException e) {
                                this.messageWaiting = new EndMessage();
                            }
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Generators don't support remove()");
                    }

                    protected void finalize() throws Throwable {
                        this.close();
                        super.finalize();
                    }

                    @Override
                    public void close() {
                        ((Thread)collectThread.getVar()).interrupt();
                    }
                };
                collectThread.setVar(new Thread(){

                    @Override
                    public void run() {
                        try {
                            returnQueue.take();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        try {
                            try {
                                client.collect(new ResultHandler<T>(){

                                    @Override
                                    public T handleResult(T value) throws CollectionAbortedException {
                                        try {
                                            Object oldValue = iterator.getCurrentValue();
                                            synchronousQueue.put(new ValueMessage(value));
                                            returnQueue.take();
                                            return oldValue;
                                        }
                                        catch (InterruptedException e) {
                                            throw new CollectionAbortedException(e);
                                        }
                                    }
                                });
                                synchronousQueue.put(new EndMessage());
                            }
                            catch (CollectionAbortedException collectionAborted) {
                                if (!(collectionAborted.getCause() instanceof InterruptedException)) {
                                    synchronousQueue.put(new AbortedMessage());
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                ((Thread)collectThread.getVar()).setDaemon(true);
                ((Thread)collectThread.getVar()).start();
                return iterator;
            }
        };
    }

    class ValueMessage
    extends Message {
        final T value;

        ValueMessage(T value) {
            this.value = value;
        }
    }

    private static class VarContainer<T> {
        T var;

        private VarContainer() {
        }

        public T getVar() {
            return this.var;
        }

        public void setVar(T var) {
            this.var = var;
        }
    }

    private class AbortedMessage
    extends StopMessage {
        private AbortedMessage() {
        }
    }

    private class EndMessage
    extends StopMessage {
        private EndMessage() {
        }
    }

    private abstract class StopMessage
    extends Message {
        private StopMessage() {
        }
    }

    class Message {
        Message() {
        }
    }
}

