/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXCheckBoxSkin;
import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXCheckBox
extends CheckBox {
    private static final String DEFAULT_STYLE_CLASS = "jfx-check-box";
    private StyleableObjectProperty<Paint> checkedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)this, "checkedColor", (Object)Color.valueOf((String)"#0F9D58"));
    private StyleableObjectProperty<Paint> unCheckedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$100(), (Object)this, "unCheckedColor", (Object)Color.valueOf((String)"#5A5A5A"));
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXCheckBox(String text) {
        super(text);
        this.initialize();
    }

    public JFXCheckBox() {
        this.initialize();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElements.length && i < 15; ++i) {
            if (!stackTraceElements[i].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("CheckBox");
            break;
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXCheckBoxSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/css/controls/jfx-check-box.css").toExternalForm();
    }

    public Paint getCheckedColor() {
        return this.checkedColor == null ? Color.valueOf((String)"#0F9D58") : (Paint)this.checkedColor.get();
    }

    public StyleableObjectProperty<Paint> checkedColorProperty() {
        return this.checkedColor;
    }

    public void setCheckedColor(Paint color) {
        this.checkedColor.set((Object)color);
    }

    public Paint getUnCheckedColor() {
        return this.unCheckedColor == null ? Color.valueOf((String)"#5A5A5A") : (Paint)this.unCheckedColor.get();
    }

    public StyleableObjectProperty<Paint> unCheckedColorProperty() {
        return this.unCheckedColor;
    }

    public void setUnCheckedColor(Paint color) {
        this.unCheckedColor.set((Object)color);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXCheckBox.getClassCssMetaData());
            styleables.addAll(Labeled.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXCheckBox, Paint> CHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-checked-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#0F9D58")){

            public boolean isSettable(JFXCheckBox control) {
                return control.checkedColor == null || !control.checkedColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox control) {
                return control.checkedColorProperty();
            }
        };
        private static final CssMetaData<JFXCheckBox, Paint> UNCHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-unchecked-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#5A5A5A")){

            public boolean isSettable(JFXCheckBox control) {
                return control.unCheckedColor == null || !control.unCheckedColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox control) {
                return control.unCheckedColorProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return CHECKED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNCHECKED_COLOR;
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, CHECKED_COLOR, UNCHECKED_COLOR);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

