/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXRippler$$Lambda$1;
import com.jfoenix.controls.JFXRippler$$Lambda$2;
import com.jfoenix.controls.JFXRippler$$Lambda$3;
import com.jfoenix.controls.JFXRippler$$Lambda$4;
import com.jfoenix.controls.JFXRippler$$Lambda$5;
import com.jfoenix.controls.JFXRippler$RippleGenerator$$Lambda$1;
import com.jfoenix.controls.JFXRippler$RippleGenerator$$Lambda$2;
import com.jfoenix.controls.JFXRippler$RippleGenerator$$Lambda$3;
import com.jfoenix.controls.JFXRippler$RippleGenerator$OverLayRipple$$Lambda$1;
import com.jfoenix.converters.RipplerMaskTypeConverter;
import com.jfoenix.transitions.CachedAnimation;
import com.jfoenix.transitions.CachedTransition;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

@DefaultProperty(value="control")
public class JFXRippler
extends StackPane {
    protected RippleGenerator rippler;
    protected Pane ripplerPane;
    protected Node control;
    private static final double RIPPLE_MAX_RADIUS = 300.0;
    private boolean enabled = true;
    private boolean forceOverlay = false;
    private Interpolator rippleInterpolator = Interpolator.SPLINE((double)0.0825, (double)0.3025, (double)0.0875, (double)0.9975);
    private static final String DEFAULT_STYLE_CLASS = "jfx-rippler";
    private StyleableObjectProperty<Boolean> ripplerRecenter = new SimpleStyleableObjectProperty(StyleableProperties.access$1000(), (Object)this, "ripplerRecenter", (Object)false);
    private StyleableObjectProperty<Number> ripplerRadius = new SimpleStyleableObjectProperty(StyleableProperties.access$1100(), (Object)this, "ripplerRadius", (Object)-1.0);
    private StyleableObjectProperty<Paint> ripplerFill = new SimpleStyleableObjectProperty(StyleableProperties.access$1200(), (Object)this, "ripplerFill", (Object)Color.rgb((int)0, (int)200, (int)255));
    private StyleableObjectProperty<RipplerMask> maskType = new SimpleStyleableObjectProperty(StyleableProperties.access$1300(), (Object)this, "maskType", (Object)RipplerMask.RECT);
    private StyleableBooleanProperty ripplerDisabled = new SimpleStyleableBooleanProperty(StyleableProperties.access$1400(), (Object)this, "ripplerDisabled", false);
    protected ObjectProperty<RipplerPos> position = new SimpleObjectProperty();

    public JFXRippler() {
        this(null, RipplerMask.RECT, RipplerPos.FRONT);
    }

    public JFXRippler(Node control) {
        this(control, RipplerMask.RECT, RipplerPos.FRONT);
    }

    public JFXRippler(Node control, RipplerPos pos) {
        this(control, RipplerMask.RECT, pos);
    }

    public JFXRippler(Node control, RipplerMask mask) {
        this(control, mask, RipplerPos.FRONT);
    }

    public JFXRippler(Node control, RipplerMask mask, RipplerPos pos) {
        this.initialize();
        this.setMaskType(mask);
        this.setPosition(pos);
        this.setControl(control);
        this.position.addListener(JFXRippler$$Lambda$1.lambdaFactory$(this));
        this.setPickOnBounds(false);
        this.setCache(true);
        this.setCacheHint(CacheHint.SPEED);
        this.setCacheShape(true);
        this.setSnapToPixel(false);
    }

    public void setControl(Node control) {
        if (control != null) {
            this.control = control;
            this.rippler = new RippleGenerator();
            this.ripplerPane = new StackPane();
            this.ripplerPane.setMouseTransparent(true);
            this.ripplerPane.getChildren().add((Object)this.rippler);
            if (this.position.get() == RipplerPos.BACK) {
                this.getChildren().setAll((Object[])new Node[]{this.ripplerPane, control});
            } else {
                this.getChildren().setAll((Object[])new Node[]{control, this.ripplerPane});
            }
            this.initControlListeners();
        }
    }

    public void updateControlPosition() {
        if (this.position.get() == RipplerPos.BACK) {
            this.ripplerPane.toBack();
        } else {
            this.ripplerPane.toFront();
        }
    }

    public Node getControl() {
        return this.control;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    protected Node getMask() {
        Rectangle mask;
        double borderWidth = this.ripplerPane.getBorder() != null ? this.ripplerPane.getBorder().getInsets().getTop() : 0.0;
        Bounds bounds = this.control.getBoundsInParent();
        double width = this.control.getLayoutBounds().getWidth();
        double height = this.control.getLayoutBounds().getHeight();
        double diffMinX = Math.abs(this.control.getBoundsInLocal().getMinX() - this.control.getLayoutBounds().getMinX());
        double diffMinY = Math.abs(this.control.getBoundsInLocal().getMinY() - this.control.getLayoutBounds().getMinY());
        double diffMaxX = Math.abs(this.control.getBoundsInLocal().getMaxX() - this.control.getLayoutBounds().getMaxX());
        double diffMaxY = Math.abs(this.control.getBoundsInLocal().getMaxY() - this.control.getLayoutBounds().getMaxY());
        switch (this.getMaskType()) {
            case RECT: {
                mask = new Rectangle(bounds.getMinX() + diffMinX - this.snappedLeftInset(), bounds.getMinY() + diffMinY - this.snappedTopInset(), width - 0.1 - 2.0 * borderWidth, height - 0.1 - 2.0 * borderWidth);
                break;
            }
            case CIRCLE: {
                double radius = Math.min(width / 2.0 - 0.1 - 2.0 * borderWidth, height / 2.0 - 0.1 - 2.0 * borderWidth);
                mask = new Circle((bounds.getMinX() + diffMinX + bounds.getMaxX() - diffMaxX) / 2.0 - this.snappedLeftInset(), (bounds.getMinY() + diffMinY + bounds.getMaxY() - diffMaxY) / 2.0 - this.snappedTopInset(), radius, (Paint)Color.BLUE);
                break;
            }
            default: {
                mask = new Rectangle(bounds.getMinX() + diffMinX - this.snappedLeftInset(), bounds.getMinY() + diffMinY - this.snappedTopInset(), width - 0.1 - 2.0 * borderWidth, height - 0.1 - 2.0 * borderWidth);
            }
        }
        if (this.control instanceof Shape || this.control instanceof Region && ((Region)this.control).getShape() != null) {
            mask = new StackPane();
            ((Region)mask).setShape(this.control instanceof Shape ? (Shape)this.control : ((Region)this.control).getShape());
            ((Region)mask).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
            mask.resize(width, height);
            mask.relocate(bounds.getMinX() + diffMinX, bounds.getMinY() + diffMinY);
        }
        return mask;
    }

    protected double computeRippleRadius() {
        double width2 = this.control.getLayoutBounds().getWidth() * this.control.getLayoutBounds().getWidth();
        double height2 = this.control.getLayoutBounds().getHeight() * this.control.getLayoutBounds().getHeight();
        return Math.min(Math.sqrt(width2 + height2), 300.0) * 1.1 + 5.0;
    }

    protected void initControlListeners() {
        this.control.layoutBoundsProperty().addListener(JFXRippler$$Lambda$2.lambdaFactory$(this));
        this.control.boundsInParentProperty().addListener(JFXRippler$$Lambda$3.lambdaFactory$(this));
        this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, JFXRippler$$Lambda$4.lambdaFactory$(this));
    }

    protected void createRipple(double x, double y) {
        if (!this.isRipplerDisabled().booleanValue()) {
            this.rippler.setGeneratorCenterX(x);
            this.rippler.setGeneratorCenterY(y);
            this.rippler.createMouseRipple();
        }
    }

    public Runnable createManualRipple() {
        this.rippler.setGeneratorCenterX(this.control.getLayoutBounds().getWidth() / 2.0);
        this.rippler.setGeneratorCenterY(this.control.getLayoutBounds().getHeight() / 2.0);
        return this.rippler.createManualRipple();
    }

    public void setOverlayVisible(boolean visible, boolean forceOverlay) {
        this.forceOverlay = forceOverlay;
        this.setOverlayVisible(visible);
    }

    public void setOverlayVisible(boolean visible) {
        if (visible) {
            this.showOverlay();
        } else {
            this.forceOverlay = !visible ? false : this.forceOverlay;
            this.hideOverlay();
        }
    }

    @Deprecated
    public void showOverlay() {
        if (this.rippler.overlayRect != null) {
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.stop();
        }
        this.rippler.createOverlay();
        ((RippleGenerator)this.rippler).overlayRect.inAnimation.play();
    }

    @Deprecated
    public void hideOverlay() {
        if (!this.forceOverlay) {
            if (this.rippler.overlayRect != null) {
                ((RippleGenerator)this.rippler).overlayRect.inAnimation.stop();
            }
            if (this.rippler.overlayRect != null) {
                ((RippleGenerator)this.rippler).overlayRect.outAnimation.play();
            }
        } else {
            System.err.println("Ripple Overlay is forced!");
        }
    }

    private void resetOverLay() {
        if (this.rippler.overlayRect != null) {
            ((RippleGenerator)this.rippler).overlayRect.inAnimation.stop();
            RippleGenerator.OverLayRipple oldOverlay = this.rippler.overlayRect;
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.setOnFinished(JFXRippler$$Lambda$5.lambdaFactory$(this, oldOverlay));
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.play();
            this.rippler.overlayRect = null;
        }
    }

    private void resetClip() {
        this.rippler.resetClip = true;
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public Boolean isRipplerRecenter() {
        return this.ripplerRecenter == null ? Boolean.valueOf(false) : (Boolean)this.ripplerRecenter.get();
    }

    public StyleableObjectProperty<Boolean> ripplerRecenterProperty() {
        return this.ripplerRecenter;
    }

    public void setRipplerRecenter(Boolean radius) {
        this.ripplerRecenter.set((Object)radius);
    }

    public Number getRipplerRadius() {
        return this.ripplerRadius == null ? (Number)-1.0 : (Number)((Number)this.ripplerRadius.get());
    }

    public StyleableObjectProperty<Number> ripplerRadiusProperty() {
        return this.ripplerRadius;
    }

    public void setRipplerRadius(Number radius) {
        this.ripplerRadius.set((Object)radius);
    }

    public Paint getRipplerFill() {
        return this.ripplerFill == null ? Color.rgb((int)0, (int)200, (int)255) : (Paint)this.ripplerFill.get();
    }

    public StyleableObjectProperty<Paint> ripplerFillProperty() {
        return this.ripplerFill;
    }

    public void setRipplerFill(Paint color) {
        this.ripplerFill.set((Object)color);
    }

    public RipplerMask getMaskType() {
        return this.maskType == null ? RipplerMask.RECT : (RipplerMask)((Object)this.maskType.get());
    }

    public StyleableObjectProperty<RipplerMask> maskTypeProperty() {
        return this.maskType;
    }

    public void setMaskType(RipplerMask type) {
        this.maskType.set((Object)type);
    }

    public Boolean isRipplerDisabled() {
        return this.ripplerDisabled == null ? false : this.ripplerDisabled.get();
    }

    public StyleableBooleanProperty ripplerDisabledProperty() {
        return this.ripplerDisabled;
    }

    public void setRipplerDisabled(Boolean disabled) {
        this.ripplerDisabled.set(disabled.booleanValue());
    }

    public void setPosition(RipplerPos pos) {
        this.position.set((Object)pos);
    }

    public RipplerPos getPosition() {
        return this.position == null ? RipplerPos.FRONT : (RipplerPos)((Object)this.position.get());
    }

    public ObjectProperty<RipplerPos> positionProperty() {
        return this.position;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXRippler.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    static /* synthetic */ void lambda$resetOverLay$4(JFXRippler this_, RippleGenerator.OverLayRipple oldOverlay, ActionEvent finish) {
        this_.rippler.getChildren().remove((Object)oldOverlay);
    }

    static /* synthetic */ void lambda$initControlListeners$3(JFXRippler this_, MouseEvent event) {
        this_.createRipple(event.getX(), event.getY());
    }

    static /* synthetic */ void lambda$initControlListeners$2(JFXRippler this_, Observable observable) {
        this_.resetOverLay();
        this_.resetClip();
    }

    static /* synthetic */ void lambda$initControlListeners$1(JFXRippler this_, Observable observable) {
        this_.resetOverLay();
        this_.resetClip();
    }

    static /* synthetic */ void lambda$new$0(JFXRippler this_, Observable observable) {
        this_.updateControlPosition();
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXRippler, Boolean> RIPPLER_RECENTER = new CssMetaData<JFXRippler, Boolean>("-jfx-rippler-recenter", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerRecenter == null || !control.ripplerRecenter.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(JFXRippler control) {
                return control.ripplerRecenterProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Boolean> RIPPLER_DISABLED = new CssMetaData<JFXRippler, Boolean>("-jfx-rippler-disabled", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerDisabled == null || !control.ripplerDisabled.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(JFXRippler control) {
                return control.ripplerDisabledProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Paint> RIPPLER_FILL = new CssMetaData<JFXRippler, Paint>("-jfx-rippler-fill", PaintConverter.getInstance(), (Paint)Color.rgb((int)0, (int)200, (int)255)){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerFill == null || !control.ripplerFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXRippler control) {
                return control.ripplerFillProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Number> RIPPLER_RADIUS = new CssMetaData<JFXRippler, Number>("-jfx-rippler-radius", SizeConverter.getInstance(), (Number)-1.0){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerRadius == null || !control.ripplerRadius.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(JFXRippler control) {
                return control.ripplerRadiusProperty();
            }
        };
        private static final CssMetaData<JFXRippler, RipplerMask> MASK_TYPE = new CssMetaData<JFXRippler, RipplerMask>("-jfx-mask-type", RipplerMaskTypeConverter.getInstance(), RipplerMask.RECT){

            public boolean isSettable(JFXRippler control) {
                return control.maskType == null || !control.maskType.isBound();
            }

            public StyleableProperty<RipplerMask> getStyleableProperty(JFXRippler control) {
                return control.maskTypeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$1000() {
            return RIPPLER_RECENTER;
        }

        static /* synthetic */ CssMetaData access$1100() {
            return RIPPLER_RADIUS;
        }

        static /* synthetic */ CssMetaData access$1200() {
            return RIPPLER_FILL;
        }

        static /* synthetic */ CssMetaData access$1300() {
            return MASK_TYPE;
        }

        static /* synthetic */ CssMetaData access$1400() {
            return RIPPLER_DISABLED;
        }

        static {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            Collections.addAll(styleables, RIPPLER_RECENTER, RIPPLER_RADIUS, RIPPLER_FILL, MASK_TYPE, RIPPLER_DISABLED);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    final class RippleGenerator
    extends Group {
        private double generatorCenterX = 0.0;
        private double generatorCenterY = 0.0;
        private OverLayRipple overlayRect;
        private AtomicBoolean generating = new AtomicBoolean(false);
        private boolean cacheRipplerClip = false;
        private boolean resetClip = false;

        RippleGenerator() {
            this.setManaged(false);
        }

        void createMouseRipple() {
            if (JFXRippler.this.enabled && !this.generating.getAndSet(true)) {
                this.createOverlay();
                if (this.getClip() == null || this.getChildren().size() == 1 && !this.cacheRipplerClip || this.resetClip) {
                    this.setClip(JFXRippler.this.getMask());
                }
                this.resetClip = false;
                final Ripple ripple = new Ripple(this.generatorCenterX, this.generatorCenterY);
                this.getChildren().add((Object)ripple);
                this.overlayRect.outAnimation.stop();
                this.overlayRect.inAnimation.play();
                ripple.inAnimation.getAnimation().play();
                JFXRippler.this.control.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent e) {
                        JFXRippler.this.control.removeEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)this);
                        RippleGenerator.this.releaseRipple(ripple);
                    }
                });
            }
        }

        private void releaseRipple(Ripple ripple) {
            if (this.generating.getAndSet(false)) {
                if (this.overlayRect != null) {
                    this.overlayRect.inAnimation.stop();
                }
                ripple.inAnimation.getAnimation().stop();
                ripple.outAnimation = new CachedAnimation((Animation)new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)Math.min(800.0, 450.0 / ripple.getScaleX())), ripple.outKeyValues)}), new Node[]{this});
                ripple.outAnimation.getAnimation().setOnFinished(JFXRippler$RippleGenerator$$Lambda$1.lambdaFactory$(this, ripple));
                ripple.outAnimation.getAnimation().play();
                if (this.overlayRect != null && !JFXRippler.this.forceOverlay) {
                    this.overlayRect.outAnimation.play();
                }
            }
        }

        Runnable createManualRipple() {
            if (JFXRippler.this.enabled && !this.generating.getAndSet(true)) {
                this.createOverlay();
                if (this.getClip() == null || this.getChildren().size() == 1 && !this.cacheRipplerClip || this.resetClip) {
                    this.setClip(JFXRippler.this.getMask());
                }
                this.resetClip = false;
                Ripple ripple = new Ripple(this.generatorCenterX, this.generatorCenterY);
                this.getChildren().add((Object)ripple);
                this.overlayRect.outAnimation.stop();
                this.overlayRect.inAnimation.play();
                ripple.inAnimation.getAnimation().play();
                return JFXRippler$RippleGenerator$$Lambda$2.lambdaFactory$(this, ripple);
            }
            return JFXRippler$RippleGenerator$$Lambda$3.lambdaFactory$();
        }

        void cacheRippleClip(boolean cached) {
            this.cacheRipplerClip = cached;
        }

        void createOverlay() {
            if (this.overlayRect == null) {
                this.overlayRect = new OverLayRipple();
                this.overlayRect.setClip(JFXRippler.this.getMask());
                this.getChildren().add(0, (Object)this.overlayRect);
                if (JFXRippler.this.ripplerFill.get() instanceof Color) {
                    this.overlayRect.setFill((Paint)new Color(((Color)JFXRippler.this.ripplerFill.get()).getRed(), ((Color)JFXRippler.this.ripplerFill.get()).getGreen(), ((Color)JFXRippler.this.ripplerFill.get()).getBlue(), 0.2));
                } else {
                    this.overlayRect.setFill((Paint)Color.TRANSPARENT);
                }
            }
        }

        void setGeneratorCenterX(double generatorCenterX) {
            this.generatorCenterX = generatorCenterX;
        }

        void setGeneratorCenterY(double generatorCenterY) {
            this.generatorCenterY = generatorCenterY;
        }

        public void clear() {
            this.getChildren().clear();
            this.generating.set(false);
        }

        static /* synthetic */ void lambda$createManualRipple$2() {
        }

        static /* synthetic */ void lambda$createManualRipple$1(RippleGenerator this_, Ripple ripple) {
            this_.releaseRipple(ripple);
        }

        static /* synthetic */ void lambda$releaseRipple$0(RippleGenerator this_, Ripple ripple, ActionEvent event) {
            this_.getChildren().remove((Object)ripple);
        }

        private final class Ripple
        extends Circle {
            KeyValue[] outKeyValues;
            CachedAnimation outAnimation;
            CachedAnimation inAnimation;

            private Ripple(double centerX, double centerY) {
                super(centerX, centerY, ((Number)JFXRippler.this.ripplerRadius.get()).doubleValue() == -1.0 ? JFXRippler.this.computeRippleRadius() : ((Number)JFXRippler.this.ripplerRadius.get()).doubleValue(), null);
                this.outAnimation = null;
                this.inAnimation = null;
                KeyValue[] inKeyValues = new KeyValue[JFXRippler.this.isRipplerRecenter() != false ? 4 : 2];
                this.outKeyValues = new KeyValue[JFXRippler.this.isRipplerRecenter() != false ? 5 : 3];
                inKeyValues[0] = new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.9, JFXRippler.this.rippleInterpolator);
                inKeyValues[1] = new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.9, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[0] = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[1] = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[2] = new KeyValue((WritableValue)this.opacityProperty(), (Object)0, JFXRippler.this.rippleInterpolator);
                if (JFXRippler.this.isRipplerRecenter().booleanValue()) {
                    double dx = (JFXRippler.this.control.getLayoutBounds().getWidth() / 2.0 - centerX) / 1.55;
                    double dy = (JFXRippler.this.control.getLayoutBounds().getHeight() / 2.0 - centerY) / 1.55;
                    inKeyValues[2] = this.outKeyValues[3] = new KeyValue((WritableValue)this.translateXProperty(), (Object)(Math.signum(dx) * Math.min(Math.abs(dx), this.getRadius() / 2.0)), JFXRippler.this.rippleInterpolator);
                    inKeyValues[3] = this.outKeyValues[4] = new KeyValue((WritableValue)this.translateYProperty(), (Object)(Math.signum(dy) * Math.min(Math.abs(dy), this.getRadius() / 2.0)), JFXRippler.this.rippleInterpolator);
                }
                this.inAnimation = new CachedAnimation((Animation)new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.scaleXProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.scaleYProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.translateXProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)1, JFXRippler.this.rippleInterpolator)}), new KeyFrame(Duration.millis((double)900.0), inKeyValues)}), new Node[]{this});
                this.setCache(true);
                this.setCacheHint(CacheHint.SPEED);
                JFXRippler.this.setCacheShape(true);
                JFXRippler.this.setSnapToPixel(false);
                this.setScaleX(0.0);
                this.setScaleY(0.0);
                if (JFXRippler.this.ripplerFill.get() instanceof Color) {
                    Color circleColor = new Color(((Color)JFXRippler.this.ripplerFill.get()).getRed(), ((Color)JFXRippler.this.ripplerFill.get()).getGreen(), ((Color)JFXRippler.this.ripplerFill.get()).getBlue(), 0.3);
                    this.setStroke((Paint)circleColor);
                    this.setFill((Paint)circleColor);
                } else {
                    this.setStroke((Paint)JFXRippler.this.ripplerFill.get());
                    this.setFill((Paint)JFXRippler.this.ripplerFill.get());
                }
            }
        }

        private final class OverLayRipple
        extends Rectangle {
            CachedTransition inAnimation;
            CachedTransition outAnimation;

            OverLayRipple() {
                super(JFXRippler.this.control.getLayoutBounds().getWidth() - 0.1, JFXRippler.this.control.getLayoutBounds().getHeight() - 0.1);
                this.inAnimation = new CachedTransition((Node)this, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Interpolator.EASE_IN)})})){
                    {
                        this.setDelay(Duration.millis((double)0.0));
                        this.setCycleDuration(Duration.millis((double)300.0));
                    }
                };
                this.outAnimation = new CachedTransition((Node)this, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Interpolator.EASE_OUT)})})){
                    {
                        this.setDelay(Duration.millis((double)0.0));
                        this.setCycleDuration(Duration.millis((double)300.0));
                    }
                };
                this.getStyleClass().add((Object)"jfx-rippler-overlay");
                double diffMinX = Math.abs(JFXRippler.this.control.getBoundsInLocal().getMinX() - JFXRippler.this.control.getLayoutBounds().getMinX());
                double diffMinY = Math.abs(JFXRippler.this.control.getBoundsInLocal().getMinY() - JFXRippler.this.control.getLayoutBounds().getMinY());
                Bounds bounds = JFXRippler.this.control.getBoundsInParent();
                this.setX(bounds.getMinX() + diffMinX - JFXRippler.this.snappedLeftInset());
                this.setY(bounds.getMinY() + diffMinY - JFXRippler.this.snappedTopInset());
                this.setOpacity(0.0);
                this.setCache(true);
                this.setCacheHint(CacheHint.SPEED);
                JFXRippler.this.setCacheShape(true);
                JFXRippler.this.setSnapToPixel(false);
                this.outAnimation.setOnFinished(JFXRippler$RippleGenerator$OverLayRipple$$Lambda$1.lambdaFactory$(this));
            }

            static /* synthetic */ void lambda$new$0(OverLayRipple this_, ActionEvent finish) {
                this_.JFXRippler.this.resetOverLay();
            }
        }
    }

    public static enum RipplerMask {
        CIRCLE,
        RECT;

    }

    public static enum RipplerPos {
        FRONT,
        BACK;

    }
}

