/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.behavior.JFXColorPickerBehavior;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXColorPalette;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$1;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$2;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$3;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$4;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class JFXColorPickerSkin
extends ComboBoxPopupControl<Color> {
    private Label displayNode;
    private Pane pickerColorBox;
    private StackPane pickerColorClip;
    private JFXColorPalette popupContent;
    StyleableBooleanProperty colorLabelVisible = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "colorLabelVisible", true);

    public JFXColorPickerSkin(ColorPicker colorPicker) {
        super((ComboBoxBase)colorPicker, (ComboBoxBaseBehavior)new JFXColorPickerBehavior(colorPicker));
        this.displayNode = new Label();
        this.displayNode.getStyleClass().add((Object)"color-picker-label");
        this.displayNode.setManaged(false);
        this.displayNode.setMouseTransparent(true);
        this.pickerColorBox = new Pane();
        this.pickerColorBox.getStyleClass().add((Object)"picker-color");
        this.pickerColorBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#fafafa"), new CornerRadii(3.0), Insets.EMPTY)}));
        this.pickerColorClip = new StackPane();
        this.pickerColorClip.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding((Callable)JFXColorPickerSkin$$Lambda$1.lambdaFactory$(this), (Observable[])new Observable[]{this.pickerColorBox.backgroundProperty()}));
        this.pickerColorBox.setClip((Node)this.pickerColorClip);
        JFXButton button = new JFXButton("");
        button.ripplerFillProperty().bind((ObservableValue)this.displayNode.textFillProperty());
        button.minWidthProperty().bind((ObservableValue)this.pickerColorBox.widthProperty());
        button.minHeightProperty().bind((ObservableValue)this.pickerColorBox.heightProperty());
        button.addEventHandler(MouseEvent.ANY, JFXColorPickerSkin$$Lambda$2.lambdaFactory$(this));
        this.pickerColorBox.getChildren().add((Object)button);
        this.updateColor();
        this.getChildren().add((Object)this.pickerColorBox);
        this.getChildren().remove((Object)this.arrowButton);
        JFXDepthManager.setDepth((Node)this.getSkinnable(), 1);
        this.getPopupContent();
        this.registerChangeListener((ObservableValue)colorPicker.valueProperty(), "VALUE");
        this.colorLabelVisible.addListener(JFXColorPickerSkin$$Lambda$3.lambdaFactory$(this));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (!this.colorLabelVisible.get()) {
            return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        }
        String displayNodeText = this.displayNode.getText();
        double width = 0.0;
        this.displayNode.setText("#00000000");
        width = Math.max(width, super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset));
        this.displayNode.setText(displayNodeText);
        return width;
    }

    static String colorDisplayName(Color c) {
        if (c != null) {
            return JFXColorPickerSkin.formatHexString(c);
        }
        return null;
    }

    static String tooltipString(Color c) {
        if (c != null) {
            return JFXColorPickerSkin.formatHexString(c);
        }
        return null;
    }

    static String formatHexString(Color c) {
        if (c != null) {
            return String.format((Locale)null, "#%02x%02x%02x", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0)).toUpperCase();
        }
        return null;
    }

    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new JFXColorPalette((ColorPicker)this.getSkinnable());
            this.popupContent.setPopupControl(this.getPopup());
        }
        return this.popupContent;
    }

    protected void focusLost() {
    }

    public void show() {
        super.show();
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.popupContent.updateSelection((Color)colorPicker.getValue());
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SHOWING".equals(p)) {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            } else if (!this.popupContent.isCustomColorDialogShowing()) {
                this.hide();
            }
        } else if ("VALUE".equals(p)) {
            this.updateColor();
        }
    }

    public Node getDisplayNode() {
        return this.displayNode;
    }

    private void updateColor() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        Circle ColorCircle = new Circle();
        ColorCircle.setFill((Paint)colorPicker.getValue());
        ColorCircle.setLayoutX(this.pickerColorBox.getWidth() / 4.0);
        ColorCircle.setLayoutY(this.pickerColorBox.getHeight() / 2.0);
        this.pickerColorBox.getChildren().add((Object)ColorCircle);
        Timeline animateColor = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)ColorCircle.radiusProperty(), (Object)200, Interpolator.EASE_BOTH)})});
        animateColor.setOnFinished(JFXColorPickerSkin$$Lambda$4.lambdaFactory$(this, ColorCircle));
        animateColor.play();
        this.displayNode.setTextFill((Paint)(((Color)colorPicker.getValue()).grayscale().getRed() < 0.5 ? Color.valueOf((String)"rgba(255, 255, 255, 0.87)") : Color.valueOf((String)"rgba(0, 0, 0, 0.87)")));
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(JFXColorPickerSkin.colorDisplayName((Color)colorPicker.getValue()));
        } else {
            this.displayNode.setText("");
        }
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && ((ComboBoxBase)this.getSkinnable()).isShowing()) {
            ((ComboBoxBase)this.getSkinnable()).hide();
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.pickerColorBox.resizeRelocate(x - 1.0, y - 1.0, w + 2.0, h + 2.0);
        this.pickerColorClip.resize(w + 2.0, h + 2.0);
        super.layoutChildren(x, y, w, h);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXColorPickerSkin.getClassCssMetaData();
    }

    protected TextField getEditor() {
        return null;
    }

    protected StringConverter<Color> getConverter() {
        return null;
    }

    static /* synthetic */ void lambda$updateColor$3(JFXColorPickerSkin this_, Circle ColorCircle, ActionEvent finish) {
        this_.pickerColorBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(ColorCircle.getFill(), ((BackgroundFill)this_.pickerColorBox.getBackground().getFills().get(0)).getRadii(), ((BackgroundFill)this_.pickerColorBox.getBackground().getFills().get(0)).getInsets())}));
        this_.pickerColorBox.getChildren().remove((Object)ColorCircle);
    }

    static /* synthetic */ void lambda$new$2(JFXColorPickerSkin this_, Observable invalidate) {
        if (this_.displayNode != null) {
            if (this_.colorLabelVisible.get()) {
                this_.displayNode.setText(JFXColorPickerSkin.colorDisplayName((Color)((ComboBoxBase)this_.getSkinnable()).getValue()));
            } else {
                this_.displayNode.setText("");
            }
        }
    }

    static /* synthetic */ void lambda$new$1(JFXColorPickerSkin this_, MouseEvent event) {
        if (!event.isConsumed()) {
            event.consume();
            ((ComboBoxBase)this_.getSkinnable()).fireEvent((Event)event);
        }
    }

    static /* synthetic */ Background lambda$new$0(JFXColorPickerSkin this_) throws Exception {
        return new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, this_.pickerColorBox.backgroundProperty().get() != null ? ((BackgroundFill)this_.pickerColorBox.getBackground().getFills().get(0)).getRadii() : new CornerRadii(3.0), this_.pickerColorBox.backgroundProperty().get() != null ? ((BackgroundFill)this_.pickerColorBox.getBackground().getFills().get(0)).getInsets() : Insets.EMPTY)});
    }

    private static class StyleableProperties {
        private static final CssMetaData<ColorPicker, Boolean> COLOR_LABEL_VISIBLE = new CssMetaData<ColorPicker, Boolean>("-fx-color-label-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(ColorPicker n) {
                JFXColorPickerSkin skin = (JFXColorPickerSkin)n.getSkin();
                return skin.colorLabelVisible == null || !skin.colorLabelVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(ColorPicker n) {
                JFXColorPickerSkin skin = (JFXColorPickerSkin)n.getSkin();
                return skin.colorLabelVisible;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return COLOR_LABEL_VISIBLE;
        }

        static {
            ArrayList<CssMetaData<ColorPicker, Boolean>> styleables = new ArrayList<CssMetaData<ColorPicker, Boolean>>(ComboBoxBaseSkin.getClassCssMetaData());
            styleables.add(COLOR_LABEL_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

