/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSpinner;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collections;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class JFXSpinnerSkin
extends BehaviorSkinBase<JFXSpinner, BehaviorBase<JFXSpinner>> {
    boolean invalid = true;
    private JFXSpinner control;
    private Color greenColor;
    private Color redColor;
    private Color yellowColor;
    private Color blueColor = Color.valueOf((String)"#4285f4");
    private Timeline timeline;
    private Arc arc;
    private final StackPane arcPane;
    private final Rectangle fillRect;

    public JFXSpinnerSkin(JFXSpinner control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.redColor = Color.valueOf((String)"#db4437");
        this.yellowColor = Color.valueOf((String)"#f4b400");
        this.greenColor = Color.valueOf((String)"#0F9D58");
        this.arc = new Arc();
        this.arc.setManaged(false);
        this.arc.setStartAngle(0.0);
        this.arc.setLength(180.0);
        this.arc.getStyleClass().setAll((Object[])new String[]{"arc"});
        this.arc.setFill((Paint)Color.TRANSPARENT);
        this.arc.setStrokeWidth(3.0);
        this.fillRect = new Rectangle();
        this.fillRect.setFill((Paint)Color.TRANSPARENT);
        Group group = new Group(new Node[]{this.fillRect, this.arc});
        group.setManaged(false);
        this.arcPane = new StackPane(new Node[]{group});
        this.arcPane.setPrefSize(50.0, 50.0);
        this.getChildren().setAll((Object[])new Node[]{this.arcPane});
        this.control = control;
        this.registerChangeListener((ObservableValue)control.indeterminateProperty(), "INDETERMINATE");
        this.registerChangeListener((ObservableValue)control.progressProperty(), "PROGRESS");
        this.registerChangeListener((ObservableValue)control.visibleProperty(), "VISIBLE");
        this.registerChangeListener((ObservableValue)control.parentProperty(), "PARENT");
        this.registerChangeListener((ObservableValue)control.sceneProperty(), "SCENE");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("VISIBLE".equals(p)) {
            this.updateAnimation();
        } else if ("PARENT".equals(p)) {
            this.updateAnimation();
        } else if ("SCENE".equals(p)) {
            this.updateAnimation();
        }
    }

    private KeyFrame[] getKeyFrames(double angle, double duration, Color color) {
        KeyFrame[] frames = new KeyFrame[]{new KeyFrame(Duration.seconds((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 45.0 + this.control.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(duration + 0.4)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 90.0 + this.control.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(duration + 0.7)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 135.0 + this.control.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(duration + 1.1)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 435.0 + this.control.getStartingAngle()), Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.strokeProperty(), (Object)color, Interpolator.EASE_BOTH)})};
        return frames;
    }

    private void pauseTimeline(boolean pause) {
        if (((JFXSpinner)this.getSkinnable()).isIndeterminate()) {
            if (this.timeline == null) {
                this.createTransition();
            }
            if (pause) {
                this.timeline.pause();
            } else {
                this.timeline.play();
            }
        }
    }

    private void updateAnimation() {
        boolean isTreeVisible;
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean bl = isTreeVisible = control.isVisible() && control.getParent() != null && control.getScene() != null;
        if (this.timeline != null) {
            this.pauseTimeline(!isTreeVisible);
        } else if (isTreeVisible) {
            this.createTransition();
        }
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (-1.0 == this.control.getRadius()) {
            return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        return this.control.getRadius() * 2.0 + this.arc.getStrokeWidth() * 2.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (-1.0 == this.control.getRadius()) {
            return super.computeMaxHeight(height, topInset, rightInset, bottomInset, leftInset);
        }
        return this.control.getRadius() * 2.0 + this.arc.getStrokeWidth() * 2.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.arcPane.prefWidth(-1.0);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.arcPane.prefHeight(-1.0);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double strokeWidth = this.arc.getStrokeWidth();
        double radius = Math.min(contentWidth, contentHeight) / 2.0 - strokeWidth / 2.0;
        double arcSize = this.snapSize(radius * 2.0 + strokeWidth);
        this.arcPane.resizeRelocate((contentWidth - arcSize) / 2.0 + 1.0, (contentHeight - arcSize) / 2.0 + 1.0, arcSize, arcSize);
        this.fillRect.setWidth(arcSize);
        this.fillRect.setHeight(arcSize);
        this.arc.setRadiusX(radius);
        this.arc.setRadiusY(radius);
        this.arc.setCenterX(arcSize / 2.0);
        this.arc.setCenterY(arcSize / 2.0);
        if (this.invalid) {
            this.createTransition();
            this.timeline.playFromStart();
            this.invalid = false;
        }
    }

    private void createTransition() {
        Color initialColor = (Color)this.arc.getStroke();
        if (initialColor == null) {
            this.arc.setStroke((Paint)this.blueColor);
        }
        KeyFrame[] blueFrame = this.getKeyFrames(0.0, 0.0, initialColor == null ? this.blueColor : initialColor);
        KeyFrame[] redFrame = this.getKeyFrames(450.0, 1.4, initialColor == null ? this.redColor : initialColor);
        KeyFrame[] yellowFrame = this.getKeyFrames(900.0, 2.8, initialColor == null ? this.yellowColor : initialColor);
        KeyFrame[] greenFrame = this.getKeyFrames(1350.0, 4.2, initialColor == null ? this.greenColor : initialColor);
        KeyFrame endingFrame = new KeyFrame(Duration.seconds((double)5.6), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(1845.0 + this.control.getStartingAngle()), Interpolator.LINEAR)});
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
        }
        this.timeline = new Timeline(new KeyFrame[]{blueFrame[0], blueFrame[1], blueFrame[2], blueFrame[3], redFrame[0], redFrame[1], redFrame[2], redFrame[3], yellowFrame[0], yellowFrame[1], yellowFrame[2], yellowFrame[3], greenFrame[0], greenFrame[1], greenFrame[2], greenFrame[3], endingFrame});
        this.timeline.setCycleCount(-1);
        this.timeline.setDelay(Duration.ZERO);
    }

    public void dispose() {
        super.dispose();
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
        if (this.arc != null) {
            this.arc = null;
        }
        this.control = null;
    }
}

