/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.launcher;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.ServiceLoader;
import org.develnext.jphp.core.opcode.ModuleOpcodePrinter;
import php.runtime.Information;
import php.runtime.Memory;
import php.runtime.Startup;
import php.runtime.common.Callback;
import php.runtime.common.LangMode;
import php.runtime.common.StringUtils;
import php.runtime.env.CallStackItem;
import php.runtime.env.CompileScope;
import php.runtime.env.ConcurrentEnvironment;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.core.classes.WrapClassLoader;
import php.runtime.ext.support.Extension;
import php.runtime.launcher.LaunchException;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.support.ReflectionUtils;

public class Launcher {
    protected final String[] args;
    protected CompileScope compileScope;
    protected Environment environment;
    protected Properties config;
    protected String pathToConf;
    protected OutputStream out;
    protected boolean isDebug;
    private static Launcher current;
    private ClassLoader classLoader = Launcher.class.getClassLoader();
    private long startTime = System.currentTimeMillis();

    public Launcher(String pathToConf, String[] args) {
        current = this;
        this.args = args;
        this.out = System.out != null ? System.out : new ByteArrayOutputStream();
        this.compileScope = new CompileScope();
        this.pathToConf = pathToConf == null ? "JPHP-INF/launcher.conf" : pathToConf;
    }

    public Launcher(String[] args) {
        this(null, args);
    }

    public Launcher(ClassLoader classLoader) {
        this();
        this.classLoader = classLoader;
    }

    public Launcher() {
        this(new String[0]);
    }

    public Memory getConfigValue(String key) {
        return this.getConfigValue(key, Memory.NULL);
    }

    public Memory getConfigValue(String key, Memory def) {
        String result = this.config.getProperty(key);
        if (result == null) {
            return def;
        }
        return new StringMemory(result);
    }

    public Memory getConfigValue(String key, String def) {
        return this.getConfigValue(key, new StringMemory(def));
    }

    public Collection<InputStream> getResources(String name) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        try {
            Enumeration<URL> urls = this.classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                result.add(url.openStream());
            }
            return result;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public InputStream getResource(String name) {
        InputStream stream = this.classLoader.getResourceAsStream(name);
        if (stream == null) {
            try {
                return new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return stream;
    }

    protected Context getContext(String file) {
        InputStream bootstrap = this.getResource(file);
        if (bootstrap != null) {
            return new Context(bootstrap, file, this.environment.getDefaultCharset());
        }
        return null;
    }

    public ModuleEntity loadFrom(String file) throws Throwable {
        return this.environment.getModuleManager().fetchModule(file);
    }

    protected void readConfig() {
        InputStream resource;
        this.config = new Properties();
        this.compileScope.configuration = new HashMap<String, Memory>();
        String externalConfig = System.getProperty("jphp.config");
        if (externalConfig != null) {
            try {
                FileInputStream inStream = new FileInputStream(externalConfig);
                this.config.load(inStream);
                inStream.close();
                for (String name : this.config.stringPropertyNames()) {
                    this.compileScope.configuration.put(name, new StringMemory(this.config.getProperty(name)));
                }
            }
            catch (IOException e) {
                throw new LaunchException("Unable to load the config -Djphp.config=" + externalConfig);
            }
        }
        if ((resource = this.getResource(this.pathToConf)) != null) {
            try {
                this.config.load(resource);
                for (String name : this.config.stringPropertyNames()) {
                    this.compileScope.configuration.put(name, new StringMemory(this.config.getProperty(name)));
                }
                this.isDebug = Startup.isDebug();
                this.compileScope.setDebugMode(this.isDebug);
                this.compileScope.setLangMode(LangMode.valueOf(this.getConfigValue("env.langMode", LangMode.MODERN.name()).toString().toUpperCase()));
            }
            catch (IOException e) {
                throw new LaunchException(e.getMessage());
            }
        }
    }

    protected void loadExtensions() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class, this.compileScope.getClassLoader());
        for (Extension extension : loader) {
            this.compileScope.registerExtension(extension);
        }
    }

    protected void initExtensions() {
        String tmp = this.getConfigValue("env.extensions", "spl").toString();
        String[] _extensions = StringUtils.split(tmp, ",");
        HashSet<String> extensions = new HashSet<String>();
        for (String ext : _extensions) {
            extensions.add(ext.trim());
        }
        this.loadExtensions();
        this.compileScope.getClassLoader().onAddLibrary(new Callback<Void, URL>(){

            @Override
            public Void call(URL param) {
                Launcher.this.loadExtensions();
                return null;
            }
        });
        if (this.getConfigValue("env.autoregister_extensions", Memory.TRUE).toBoolean()) {
            for (InputStream list : this.getResources("JPHP-INF/extensions.list")) {
                Scanner scanner = new Scanner(list);
                while (scanner.hasNext()) {
                    String line = scanner.nextLine().trim();
                    if (line.isEmpty()) continue;
                    System.out.println("WARNING!!! Auto-registration via JPHP-INF/extensions.list is deprected, " + line + ", use META-INF/services/php.runtime.ext.support.Extension file");
                    extensions.add(line);
                }
            }
        }
        for (String ext : extensions) {
            String className = Information.EXTENSIONS.get(ext.trim().toLowerCase());
            if (className == null) {
                className = ext.trim();
            }
            this.compileScope.registerExtension(className);
        }
        this.environment = this.getConfigValue("env.concurrent", "1").toBoolean() ? new ConcurrentEnvironment(this.compileScope, this.out) : new Environment(this.compileScope, this.out);
        this.environment.setErrorFlags(ErrorType.E_ALL.value ^ ErrorType.E_NOTICE.value);
        this.environment.getDefaultBuffer().setImplicitFlush(true);
    }

    public void printTrace(String name) {
        long t = System.currentTimeMillis() - this.startTime;
        System.out.printf("[%s] = " + t + " millis\n", name);
        this.startTime = System.currentTimeMillis();
    }

    public void run() throws Throwable {
        this.run(true);
    }

    public void run(boolean mustBootstrap) throws Throwable {
        this.run(mustBootstrap, false);
    }

    public void beforeIncludeBootstrap() {
    }

    public void afterIncludeBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean mustBootstrap, boolean disableExtensions) throws Throwable {
        block15: {
            this.readConfig();
            if (!disableExtensions) {
                this.initExtensions();
            }
            if (this.isDebug() && this.compileScope.getTickHandler() == null) {
                throw new LaunchException("Cannot find a debugger, please add the jphp-debugger dependency");
            }
            if (Startup.isShowInitDelay()) {
                long t = System.currentTimeMillis() - this.startTime;
                Startup.trace("Startup time = " + t + "ms");
            }
            String file = this.config.getProperty("bootstrap.file", "res://JPHP-INF/.bootstrap.php");
            String classLoader = this.config.getProperty("env.classLoader", ReflectionUtils.getClassName(WrapClassLoader.WrapLauncherClassLoader.class));
            if (classLoader != null && !classLoader.isEmpty()) {
                ClassEntity classLoaderEntity = this.environment.fetchClass(classLoader);
                if (classLoaderEntity == null) {
                    throw new LaunchException("Class loader class is not found: " + classLoader);
                }
                WrapClassLoader loader = (WrapClassLoader)classLoaderEntity.newObject(this.environment, TraceInfo.UNKNOWN, true, new Memory[0]);
                this.environment.invokeMethod(loader, "register", Memory.TRUE);
            }
            if (file != null && !file.isEmpty()) {
                try {
                    ModuleEntity bootstrap = this.loadFrom(file);
                    if (bootstrap == null) {
                        throw new IOException();
                    }
                    this.beforeIncludeBootstrap();
                    if (new StringMemory(this.config.getProperty("bootstrap.showBytecode", "")).toBoolean()) {
                        ModuleOpcodePrinter moduleOpcodePrinter = new ModuleOpcodePrinter(bootstrap);
                        System.out.println(moduleOpcodePrinter.toString());
                    }
                    ArrayMemory argv = ArrayMemory.ofStrings(this.args);
                    String path = URLDecoder.decode(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), "UTF-8");
                    argv.unshift(StringMemory.valueOf(path));
                    this.environment.getGlobals().put("argv", argv);
                    this.environment.getGlobals().put("argc", LongMemory.valueOf(argv.size()));
                    CallStackItem stackItem = new CallStackItem(bootstrap.getTrace());
                    this.environment.pushCall(stackItem);
                    try {
                        bootstrap.includeNoThrow(this.environment);
                        break block15;
                    }
                    finally {
                        this.afterIncludeBootstrap();
                        this.environment.popCall();
                        this.compileScope.triggerProgramShutdown(this.environment);
                        if (StringMemory.valueOf(this.config.getProperty("env.doFinal", "1")).toBoolean()) {
                            this.environment.doFinal();
                        }
                    }
                }
                catch (IOException e) {
                    throw new LaunchException("Cannot find '" + file + "' resource for `bootstrap.file` option");
                }
            }
            if (mustBootstrap) {
                throw new LaunchException("Please set value of the `bootstrap.file` option in the launcher.conf file");
            }
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public CompileScope getCompileScope() {
        return this.compileScope;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public static Launcher current() {
        return current;
    }

    public static void main(String[] args) throws Throwable {
        Launcher launcher;
        current = launcher = new Launcher(args);
        launcher.run();
    }
}

