/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\io\\FileStream")
public class FileStream
extends Stream {
    private static final String MSG_FILE_NOT_FOUND = "File '%s' not found";
    protected RandomAccessFile accessFile;
    protected boolean canRead = true;
    protected long position = 0L;

    public FileStream(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    private void throwFileNotFound(Environment env) {
        env.exception(WrapIOException.class, MSG_FILE_NOT_FOUND, this.getPath());
    }

    private void throwCannotRead(Environment env) {
        env.exception(WrapIOException.class, "Cannot read file", new Object[0]);
    }

    public RandomAccessFile getAccessFile() {
        return this.accessFile;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="r"))})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        super.__construct(env, args);
        try {
            if (this.getMode().equals("r")) {
                this.accessFile = new RandomAccessFile(this.getPath(), "r");
                this.position = 0L;
            } else if (this.getMode().equals("r+")) {
                if (!new File(this.getPath()).getAbsoluteFile().exists()) {
                    this.throwFileNotFound(env);
                }
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
            } else if (this.getMode().equals("w")) {
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
                this.accessFile.setLength(0L);
                this.canRead = false;
            } else if (this.getMode().equals("w+")) {
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
                this.accessFile.setLength(0L);
            } else if (this.getMode().equals("a")) {
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
                File file = new File(this.getPath());
                if (file.getAbsoluteFile().exists()) {
                    this.accessFile.seek(file.length());
                    this.position = file.length();
                }
                this.canRead = false;
            } else if (this.getMode().equals("a+")) {
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
                File file = new File(this.getPath());
                if (file.getAbsoluteFile().exists()) {
                    this.accessFile.seek(file.length());
                    this.position = file.length();
                }
            } else if (this.getMode().equals("x") || this.getMode().equals("x+")) {
                File file = new File(this.getPath());
                if (file.getAbsoluteFile().exists()) {
                    env.exception(WrapIOException.class, "File '%s' already exists (mode: %s)", this.getMode());
                }
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
                if (this.getMode().equals("x")) {
                    this.canRead = false;
                }
            } else if (this.getMode().equals("c") || this.getMode().equals("c+")) {
                this.accessFile = new RandomAccessFile(this.getPath(), "rw");
                if (this.getMode().equals("c")) {
                    this.canRead = false;
                }
            } else {
                env.exception(WrapIOException.class, "Unsupported mode - '%s'", this.getMode());
            }
        }
        catch (FileNotFoundException e) {
            this.throwFileNotFound(env);
        }
        catch (IOException e) {
            env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="length", optional=@Reflection.Optional(value="NULL"))})
    public Memory write(Environment env, Memory ... args) {
        int len = args[1].toInteger();
        byte[] bytes = args[0].getBinaryBytes(env.getDefaultCharset());
        try {
            this.accessFile.write(bytes, 0, len == 0 ? bytes.length : len);
            return LongMemory.valueOf(len == 0 ? bytes.length : len);
        }
        catch (IOException e) {
            env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="length")})
    public Memory read(Environment env, Memory ... args) {
        int len;
        if (!this.canRead) {
            this.throwCannotRead(env);
        }
        if ((len = args[0].toInteger()) < 1) {
            env.exception(WrapIOException.class, "Length must be greater than zero, %s given", len);
        }
        byte[] buff = new byte[len];
        try {
            int read = this.accessFile.read(buff, 0, len);
            if (read == -1) {
                return Memory.NULL;
            }
            this.position += (long)read;
            if (read != buff.length) {
                buff = Arrays.copyOf(buff, read);
            }
            return new BinaryMemory(buff);
        }
        catch (IOException e) {
            env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    @Override
    @Reflection.Signature
    public Memory readFully(Environment env, Memory ... args) {
        if (!this.canRead) {
            this.throwCannotRead(env);
        }
        long len = 0L;
        try {
            len = this.accessFile.length() - this.position;
            if (len <= 0L) {
                return Memory.FALSE;
            }
            byte[] buff = new byte[(int)len];
            this.accessFile.readFully(buff);
            this.position += len;
            return new BinaryMemory(buff);
        }
        catch (IOException e) {
            return Memory.FALSE;
        }
    }

    @Override
    @Reflection.Signature
    public Memory eof(Environment env, Memory ... args) {
        try {
            return this.position >= this.accessFile.length() ? Memory.TRUE : Memory.FALSE;
        }
        catch (IOException e) {
            return Memory.FALSE;
        }
    }

    @Override
    @Reflection.Signature
    public Memory close(Environment env, Memory ... args) throws IOException {
        this.accessFile.close();
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.position);
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="position")})
    public Memory seek(Environment env, Memory ... args) throws IOException {
        this.accessFile.seek(args[0].toLong());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getFilePointer(Environment env, Memory ... args) throws IOException {
        return LongMemory.valueOf(this.accessFile.getFilePointer());
    }

    @Reflection.Signature
    public Memory length(Environment env, Memory ... args) throws IOException {
        return LongMemory.valueOf(this.accessFile.length());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="size")})
    public Memory truncate(Environment env, Memory ... args) throws IOException {
        this.accessFile.setLength(args[0].toLong());
        return Memory.NULL;
    }
}

