/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import php.runtime.Memory;
import php.runtime.common.Modifier;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.support.Entity;

public class ConstantEntity
extends Entity {
    protected ModuleEntity module;
    protected ClassEntity clazz;
    protected Modifier modifier = Modifier.PUBLIC;
    protected DocumentComment docComment;
    protected Memory value;
    public final boolean caseSensitise;

    public ConstantEntity(Context context) {
        super(context);
        this.caseSensitise = true;
        this.name = null;
    }

    public ConstantEntity(String name, Memory value, boolean caseSensitise) {
        super(null);
        this.setName(name);
        this.value = value;
        this.caseSensitise = caseSensitise;
    }

    public boolean isDeprecated() {
        return false;
    }

    public DocumentComment getDocComment() {
        return this.docComment;
    }

    public void setDocComment(DocumentComment docComment) {
        this.docComment = docComment;
    }

    public ClassEntity getClazz() {
        return this.clazz;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.updateInternalName();
    }

    protected void updateInternalName() {
        if (this.name != null) {
            if (this.clazz != null) {
                this.internalName = "\u0000" + this.clazz.getLowerName() + "##" + (this.caseSensitise ? this.lowerName : this.name);
            } else if (this.module != null) {
                this.internalName = "\u0000" + this.module.getInternalName() + "##" + (this.caseSensitise ? this.lowerName : this.name);
            }
        }
    }

    public void setClazz(ClassEntity clazz) {
        this.clazz = clazz;
        this.module = clazz == null ? null : clazz.getModule();
        this.updateInternalName();
    }

    public ModuleEntity getModule() {
        return this.module;
    }

    public void setModule(ModuleEntity module) {
        this.module = module;
        this.updateInternalName();
    }

    public Memory getValue() {
        return this.value;
    }

    public Memory getValue(Environment env) {
        if (this.value == null) {
            return env.getStatic(this.internalName).toValue();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Memory value) {
        ConstantEntity constantEntity = this;
        synchronized (constantEntity) {
            this.value = value;
        }
    }

    public boolean isCaseSensitise() {
        return this.caseSensitise;
    }

    public boolean isOwned(ClassEntity entity) {
        return this.clazz != null && this.clazz.getId() == entity.getId();
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public boolean isPublic() {
        return this.modifier == Modifier.PUBLIC;
    }

    public boolean isProtected() {
        return this.modifier == Modifier.PROTECTED;
    }

    public boolean isPrivate() {
        return this.modifier == Modifier.PRIVATE;
    }

    public int canAccess(Environment env) {
        return this.canAccess(env, null, false);
    }

    public int canAccess(Environment env, ClassEntity context) {
        return this.canAccess(env, context, false);
    }

    public int canAccess(Environment env, ClassEntity context, boolean lateStaticCall) {
        return ObjectInvokeHelper.canAccess(env, this.modifier, this.clazz, context, lateStaticCall);
    }
}

