/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.develnext.jphp.ext.javafx.classes.UXWindow;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXForm")
public class UXForm
extends UXWindow {
    private EventHandler<WindowEvent> fixResizeBugEventFilter = windowEvent -> this.fixResizeBug();

    public UXForm(Environment env, Stage wrappedObject) {
        super(env, wrappedObject);
        if (wrappedObject.getScene() == null) {
            AnchorPane layout = new AnchorPane();
            Scene scene = new Scene((Parent)layout);
            this.getWrappedObject().setScene(scene);
        }
    }

    public UXForm(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Stage getWrappedObject() {
        return (Stage)super.getWrappedObject();
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__construct(null);
    }

    @Override
    @Reflection.Signature
    public void __construct(@Reflection.Nullable Stage stage) {
        this.__wrappedObject = stage == null ? new Stage() : stage;
        AnchorPane layout = new AnchorPane();
        Scene scene = new Scene((Parent)layout);
        this.getWrappedObject().setScene(scene);
    }

    @Reflection.Getter
    protected boolean getResizable() {
        return this.getWrappedObject().isResizable();
    }

    private void fixResizeBug() {
        this.getWrappedObject().sizeToScene();
    }

    @Reflection.Setter
    protected void setResizable(Environment env, boolean value) {
        if (!value) {
            this.getWrappedObject().setResizable(value);
        } else {
            this.getWrappedObject().setResizable(value);
        }
        this.getWrappedObject().removeEventFilter(WindowEvent.WINDOW_SHOWN, this.fixResizeBugEventFilter);
        this.getWrappedObject().addEventFilter(WindowEvent.WINDOW_SHOWN, this.fixResizeBugEventFilter);
    }

    @Reflection.Setter
    protected void setScene(@Reflection.Nullable Scene scene) {
        this.getWrappedObject().setScene(scene);
    }

    @Reflection.Setter
    protected void setOwner(@Reflection.Nullable Window window) {
        this.getWrappedObject().initOwner(window);
    }

    @Reflection.Setter
    protected void setStyle(StageStyle style) {
        this.getWrappedObject().initStyle(style);
    }

    @Reflection.Setter
    protected void setModality(Modality modality) {
        this.getWrappedObject().initModality(modality);
    }

    @Reflection.Setter
    protected void setVisible(boolean value) {
        if (value) {
            this.getWrappedObject().show();
        } else {
            this.getWrappedObject().hide();
        }
    }

    @Reflection.Signature
    public void maximize() {
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        this.getWrappedObject().setX(bounds.getMinX());
        this.getWrappedObject().setY(bounds.getMinY());
        this.getWrappedObject().setWidth(bounds.getWidth());
        this.getWrappedObject().setHeight(bounds.getHeight());
    }

    @Reflection.Setter
    public void setTransparent(boolean value) {
        if (value) {
            this.getWrappedObject().getScene().setFill(null);
        } else {
            this.getWrappedObject().getScene().setFill((Paint)Color.WHITE);
        }
    }

    @Reflection.Getter
    public boolean getTransparent() {
        return this.getWrappedObject().getScene().getFill() == null;
    }

    @Reflection.Setter
    public void setFullScreen(final boolean value) {
        this.getWrappedObject().setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        this.getWrappedObject().setFullScreenExitHint(null);
        this.getWrappedObject().setFullScreen(value);
        if (value) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UXForm.this.getWrappedObject().setFullScreen(false);
                    UXForm.this.getWrappedObject().setFullScreen(value);
                }
            });
        }
    }

    @Reflection.Getter
    public boolean getFullScreen() {
        return this.getWrappedObject().isFullScreen();
    }

    @Reflection.Signature
    public void showAndWait() {
        if (!this.getWrappedObject().isShowing()) {
            this.getWrappedObject().showAndWait();
        }
    }

    @Reflection.Signature
    public void show() {
        this.getWrappedObject().show();
    }

    static interface WrappedInterface {
        @Reflection.Property
        public String title();

        @Reflection.Property
        public double maxHeight();

        @Reflection.Property
        public double maxWidth();

        @Reflection.Property
        public double minHeight();

        @Reflection.Property
        public double minWidth();

        @Reflection.Property
        public Modality modality();

        @Reflection.Property
        public Window owner();

        @Reflection.Property
        public StageStyle style();

        @Reflection.Property
        public boolean iconified();

        @Reflection.Property
        public boolean alwaysOnTop();

        @Reflection.Property
        public boolean maximized();

        @Reflection.Property
        public ObservableList<Image> icons();

        public void toBack();

        public void toFront();

        public void close();
    }
}

