/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javax.imageio.ImageIO;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXImage")
public class UXImage
extends BaseWrapper<Image> {
    public UXImage(Environment env, Image wrappedObject) {
        super(env, (Object)wrappedObject);
    }

    public UXImage(Environment env, WritableImage wrappedObject) {
        super(env, (Object)wrappedObject);
    }

    public UXImage(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct(Environment env, InputStream is) throws IOException {
        this.__wrappedObject = new Image(is);
        Stream.closeStream((Environment)env, (InputStream)is);
    }

    @Reflection.Signature
    public void __construct(Environment env, InputStream is, double requiredWidth, double requiredHeight) throws IOException {
        this.__construct(env, is, requiredWidth, requiredHeight, true);
    }

    @Reflection.Signature
    public void __construct(Environment env, InputStream is, double requiredWidth, double requiredHeight, boolean proportional) throws IOException {
        this.__wrappedObject = new Image(is, requiredWidth, requiredHeight, proportional, false);
        Stream.closeStream((Environment)env, (InputStream)is);
    }

    @Reflection.Signature
    public Color getPixelColor(int x, int y) {
        PixelReader pixelReader = ((Image)this.getWrappedObject()).getPixelReader();
        try {
            return pixelReader == null ? null : pixelReader.getColor(x, y);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Reflection.Signature
    public int getPixelARGB(int x, int y) {
        PixelReader pixelReader = ((Image)this.getWrappedObject()).getPixelReader();
        try {
            return pixelReader == null ? -1 : pixelReader.getArgb(x, y);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    @Reflection.Signature
    public boolean isError() {
        return ((Image)this.getWrappedObject()).isError();
    }

    @Reflection.Signature
    public boolean isBackgroundLoading() {
        return ((Image)this.getWrappedObject()).isBackgroundLoading();
    }

    @Reflection.Signature
    public static Image ofUrl(String url) {
        return new Image(url);
    }

    @Reflection.Signature
    public static Image ofUrl(String url, boolean background) {
        return new Image(url, background);
    }

    @Reflection.Signature
    public void save(OutputStream stream) throws IOException {
        this.save(stream, "png");
    }

    public static BufferedImage convertToCompatible(BufferedImage image) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage compatible = gc.createCompatibleImage(image.getWidth(), image.getHeight());
        if (compatible.getType() == image.getType()) {
            return image;
        }
        ColorConvertOp op = new ColorConvertOp(image.getColorModel().getColorSpace(), compatible.getColorModel().getColorSpace(), null);
        return op.filter(image, compatible);
    }

    @Reflection.Signature
    public void save(OutputStream stream, String format) throws IOException {
        BufferedImage image = SwingFXUtils.fromFXImage((Image)((Image)this.getWrappedObject()), null);
        image = UXImage.convertToCompatible(image);
        ImageIO.write((RenderedImage)image, format, stream);
    }

    static interface WrappedInterface {
        @Reflection.Property
        public double width();

        @Reflection.Property
        public double height();

        @Reflection.Property
        public double progress();

        public void cancel();
    }
}

