/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.DepthTest;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.develnext.jphp.ext.javafx.classes.UXDragboard;
import org.develnext.jphp.ext.javafx.classes.UXForm;
import org.develnext.jphp.ext.javafx.classes.UXImage;
import org.develnext.jphp.ext.javafx.classes.UXScene;
import org.develnext.jphp.ext.javafx.classes.UXWindow;
import org.develnext.jphp.ext.javafx.classes.effect.UXEffectPipeline;
import org.develnext.jphp.ext.javafx.classes.support.Eventable;
import org.develnext.jphp.ext.javafx.support.JavaFxUtils;
import org.develnext.jphp.ext.javafx.support.UserData;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.CallStackItem;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="php\\gui\\UXNode")
public class UXNode<T extends Node>
extends BaseWrapper<Node>
implements Eventable {
    public UXNode(Environment env, T wrappedObject) {
        super(env, wrappedObject);
    }

    public UXNode(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public T getWrappedObject() {
        return (T)((Node)super.getWrappedObject());
    }

    public UXNode getRealObject() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class wrapperClass = MemoryOperation.getWrapper(this.getWrappedObject().getClass());
        if (wrapperClass != null) {
            return (UXNode)wrapperClass.getConstructor(Environment.class, this.getWrappedObject().getClass()).newInstance(this.getEnvironment(), this.getWrappedObject());
        }
        return this;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory info = new ArrayMemory();
        info.refOfIndex("*id").assign(this.getWrappedObject().getId());
        info.refOfIndex("*nativeType").assign(this.getWrappedObject().getClass().getName());
        info.refOfIndex("*classes").assign((Memory)ArrayMemory.ofStringCollection((Collection)this.getWrappedObject().getStyleClass()));
        return info.toConstant();
    }

    @Reflection.Getter
    public Memory getEffects(Environment env) {
        Memory effects = this.data("--effects");
        if (effects.instanceOf(UXEffectPipeline.class)) {
            return effects;
        }
        effects = ObjectMemory.valueOf((IObject)new UXEffectPipeline(env, (Node)this.getWrappedObject()));
        this.data(env, "--effects", effects);
        return effects;
    }

    @Reflection.Getter
    public double getX() {
        return this.getWrappedObject().getLayoutX();
    }

    @Reflection.Setter
    public void setX(double v) {
        this.getWrappedObject().setLayoutX(v);
    }

    @Reflection.Getter
    public double getY() {
        return this.getWrappedObject().getLayoutY();
    }

    @Reflection.Setter
    public void setY(double v) {
        this.getWrappedObject().setLayoutY(v);
    }

    @Reflection.Getter
    public Memory getUserData(Environment env) {
        Object userData = this.getWrappedObject().getUserData();
        if (userData == null) {
            return null;
        }
        if (userData instanceof UserData) {
            return ((UserData)userData).getValue();
        }
        return Memory.wrap((Environment)env, (Object)userData);
    }

    @Reflection.Setter
    public void setUserData(Environment env, @Reflection.Nullable Object value) {
        Object userData = this.getWrappedObject().getUserData();
        if (userData instanceof UserData) {
            ((UserData)userData).setValue(Memory.wrap((Environment)env, (Object)value));
        } else {
            this.getWrappedObject().setUserData(value);
        }
    }

    @Reflection.Getter
    public double[] getScreenPosition() {
        return new double[]{this.getScreenX(), this.getScreenY()};
    }

    @Reflection.Setter
    public void setScreenPosition(double[] value) {
        if (value.length >= 2) {
            this.setScreenX(value[0]);
            this.setScreenY(value[1]);
        }
    }

    @Reflection.Getter
    public double getScreenX() {
        Bounds pt = this.getWrappedObject().localToScreen(this.getWrappedObject().getLayoutBounds());
        if (pt == null) {
            return 0.0;
        }
        return pt.getMinX();
    }

    @Reflection.Setter
    public void setScreenX(double value) {
        Point2D pt = this.getWrappedObject().screenToLocal(value, this.getScreenY());
        this.getWrappedObject().setLayoutX(pt.getX());
    }

    @Reflection.Getter
    public double getScreenY() {
        Bounds pt = this.getWrappedObject().localToScreen(this.getWrappedObject().getLayoutBounds());
        if (pt == null) {
            return 0.0;
        }
        return pt.getMinY();
    }

    @Reflection.Setter
    public void setScreenY(double value) {
        Point2D pt = this.getWrappedObject().screenToLocal(this.getScreenX(), value);
        this.getWrappedObject().setLayoutY(pt.getY());
    }

    @Reflection.Getter
    public double[] getScale() {
        return new double[]{this.getWrappedObject().getScaleX(), this.getWrappedObject().getScaleY()};
    }

    @Reflection.Setter
    public void setScale(Memory value) {
        if (value.isArray()) {
            this.getWrappedObject().setScaleX(value.valueOfIndex(0L).toDouble());
            this.getWrappedObject().setScaleY(value.valueOfIndex(1L).toDouble());
        } else {
            this.getWrappedObject().setScaleX(value.toDouble());
            this.getWrappedObject().setScaleY(value.toDouble());
        }
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    public String getClassesString() {
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>();
        for (String s : this.getWrappedObject().getStyleClass()) {
            if (!set.add(s)) continue;
            sb.append(s.trim()).append(" ");
        }
        return sb.toString();
    }

    @Reflection.Setter
    public void setClassesString(String value) {
        String[] strings = value.split(" ");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String string : strings) {
            set.add(string.trim());
        }
        this.getWrappedObject().getStyleClass().clear();
        this.getWrappedObject().getStyleClass().addAll(set);
    }

    @Reflection.Getter
    public boolean getEnabled() {
        return !this.getWrappedObject().isDisable();
    }

    @Reflection.Setter
    public void setEnabled(boolean value) {
        this.getWrappedObject().setDisable(!value);
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    protected double[] getPosition() {
        return new double[]{this.getX(), this.getY()};
    }

    @Reflection.Setter
    protected void setPosition(double[] value) {
        if (value.length >= 2) {
            this.setX(value[0]);
            this.setY(value[1]);
        }
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    protected double[] getSize() {
        Bounds bounds = this.getWrappedObject().getLayoutBounds();
        return new double[]{bounds.getWidth(), bounds.getHeight()};
    }

    @Reflection.Setter
    protected void setSize(double[] size) {
        if (size.length >= 2) {
            this.setWidth(size[0]);
            this.setHeight(size[1]);
        }
    }

    @Reflection.Getter
    public Bounds getBoundsInParent() {
        return this.getWrappedObject().getBoundsInParent();
    }

    @Reflection.Getter
    public Bounds getLayoutBounds() {
        return this.getWrappedObject().getLayoutBounds();
    }

    @Reflection.Getter
    protected double getWidth() {
        return this.getWrappedObject().getLayoutBounds().getWidth();
    }

    @Reflection.Setter
    protected void setWidth(double v) {
        this.getWrappedObject().resize(v, this.getHeight());
    }

    @Reflection.Getter
    protected double getHeight() {
        return this.getWrappedObject().getLayoutBounds().getHeight();
    }

    @Reflection.Setter
    protected void setHeight(double v) {
        this.getWrappedObject().resize(this.getWidth(), v);
    }

    @Reflection.Getter
    public Memory getAnchors() {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("left").assign(this.getLeftAnchor());
        r.refOfIndex("top").assign(this.getTopAnchor());
        r.refOfIndex("right").assign(this.getRightAnchor());
        r.refOfIndex("bottom").assign(this.getBottomAnchor());
        return r.toConstant();
    }

    @Reflection.Getter
    public Memory getAnchorFlags() {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("left").assign(this.getLeftAnchor().isNotNull());
        r.refOfIndex("top").assign(this.getTopAnchor().isNotNull());
        r.refOfIndex("right").assign(this.getRightAnchor().isNotNull());
        r.refOfIndex("bottom").assign(this.getBottomAnchor().isNotNull());
        return r.toConstant();
    }

    @Reflection.Setter
    public void setAnchorFlags(ArrayMemory value) {
        Insets borderInsets;
        Bounds parentBounds;
        Parent parent = this.getWrappedObject().getParent();
        Bounds bounds = parentBounds = parent == null ? null : parent.getLayoutBounds();
        if (parent == null) {
            return;
        }
        Effect effect = this.getWrappedObject().getEffect();
        this.getWrappedObject().setEffect(null);
        Bounds bounds2 = this.getBoundsInParent();
        Border border = parent instanceof Region ? ((Region)parent).getBorder() : null;
        Insets insets = borderInsets = border == null ? Insets.EMPTY : border.getInsets();
        if (value.containsKey((Object)"left")) {
            boolean left = value.valueOfIndex("left").toBoolean();
            if (left) {
                this.setLeftAnchor(DoubleMemory.valueOf((double)(bounds2.getMinX() - borderInsets.getLeft())));
            } else {
                this.setLeftAnchor(Memory.NULL);
            }
        }
        if (value.containsKey((Object)"top")) {
            boolean top = value.valueOfIndex("top").toBoolean();
            if (top) {
                this.setTopAnchor(DoubleMemory.valueOf((double)(bounds2.getMinY() - borderInsets.getTop())));
            } else {
                this.setTopAnchor(Memory.NULL);
            }
        }
        if (value.containsKey((Object)"right")) {
            boolean right = value.valueOfIndex("right").toBoolean();
            if (right) {
                this.setRightAnchor(DoubleMemory.valueOf((double)(parentBounds.getWidth() - bounds2.getMaxX() - borderInsets.getRight())));
            } else {
                this.setRightAnchor(Memory.NULL);
            }
        }
        if (value.containsKey((Object)"bottom")) {
            boolean bottom = value.valueOfIndex("bottom").toBoolean();
            if (bottom) {
                this.setBottomAnchor(DoubleMemory.valueOf((double)(parentBounds.getHeight() - bounds2.getMaxY() - borderInsets.getBottom())));
            } else {
                this.setBottomAnchor(Memory.NULL);
            }
        }
        this.getWrappedObject().setEffect(effect);
    }

    @Reflection.Setter
    public void setAnchors(ArrayMemory value) {
        if (value.containsKey((Object)"left")) {
            this.setLeftAnchor(value.valueOfIndex("left"));
        }
        if (value.containsKey((Object)"top")) {
            this.setTopAnchor(value.valueOfIndex("top"));
        }
        if (value.containsKey((Object)"right")) {
            this.setRightAnchor(value.valueOfIndex("right"));
        }
        if (value.containsKey((Object)"bottom")) {
            this.setBottomAnchor(value.valueOfIndex("bottom"));
        }
    }

    @Reflection.Setter
    public void setLeftAnchor(Memory v) {
        AnchorPane.setLeftAnchor(this.getWrappedObject(), v.isNull() ? null : Double.valueOf(v.toDouble()));
    }

    @Reflection.Getter
    public Memory getLeftAnchor() {
        Double anchor = AnchorPane.getLeftAnchor(this.getWrappedObject());
        return anchor == null ? Memory.NULL : DoubleMemory.valueOf((double)anchor);
    }

    @Reflection.Setter
    public void setRightAnchor(Memory v) {
        AnchorPane.setRightAnchor(this.getWrappedObject(), v.isNull() ? null : Double.valueOf(v.toDouble()));
    }

    @Reflection.Getter
    public Memory getRightAnchor() {
        Double anchor = AnchorPane.getRightAnchor(this.getWrappedObject());
        return anchor == null ? Memory.NULL : DoubleMemory.valueOf((double)anchor);
    }

    @Reflection.Setter
    public void setTopAnchor(Memory v) {
        AnchorPane.setTopAnchor(this.getWrappedObject(), v.isNull() ? null : Double.valueOf(v.toDouble()));
    }

    @Reflection.Getter
    public Memory getTopAnchor() {
        Double anchor = AnchorPane.getTopAnchor(this.getWrappedObject());
        return anchor == null ? Memory.NULL : DoubleMemory.valueOf((double)anchor);
    }

    @Reflection.Setter
    public void setBottomAnchor(Memory v) {
        AnchorPane.setBottomAnchor(this.getWrappedObject(), v.isNull() ? null : Double.valueOf(v.toDouble()));
    }

    @Reflection.Getter
    public Memory getCursor(Environment env) {
        Cursor cursor = this.getWrappedObject().getCursor();
        if (cursor instanceof ImageCursor) {
            return ObjectMemory.valueOf((IObject)new UXImage(env, ((ImageCursor)cursor).getImage()));
        }
        return cursor == null ? Memory.NULL : StringMemory.valueOf((String)cursor.toString());
    }

    @Reflection.Setter
    public void setCursor(Memory value) {
        try {
            if (value.instanceOf(UXImage.class)) {
                this.getWrappedObject().setCursor((Cursor)new ImageCursor((Image)((UXImage)value.toObject(UXImage.class)).getWrappedObject()));
            } else {
                this.getWrappedObject().setCursor((Cursor)Cursor.class.getField(value.toString()).get(null));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Invalid cursor - " + value);
        }
    }

    @Reflection.Getter
    public Memory getBottomAnchor() {
        Double anchor = AnchorPane.getBottomAnchor(this.getWrappedObject());
        return anchor == null ? Memory.NULL : DoubleMemory.valueOf((double)anchor);
    }

    @Reflection.Signature
    public Memory css(Environment env, Memory name) {
        if (name.isArray()) {
            ForeachIterator iterator = name.getNewIterator(env);
            while (iterator.next()) {
                this.css(iterator.getStringKey(), iterator.getValue());
            }
            return Memory.NULL;
        }
        String property = name.toString();
        String style = this.getWrappedObject().getStyle();
        Pattern pattern = Pattern.compile(Pattern.quote(property) + "[ ]{0,}\\:[ ]{0,}(.+)\\;", 42);
        Matcher matcher = pattern.matcher(style);
        if (matcher.find()) {
            return StringMemory.valueOf((String)matcher.group(1));
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory css(String property, Memory value) {
        String style = this.getWrappedObject().getStyle();
        Pattern pattern = Pattern.compile(Pattern.quote(property) + "[ ]{0,}\\:[ ]{0,}(.+)\\;", 42);
        Matcher matcher = pattern.matcher(style);
        if (matcher.find()) {
            matcher.reset();
            style = value.isNull() ? matcher.replaceFirst("") : matcher.replaceFirst(property + ": " + value + ";");
        } else {
            if (value.isNull()) {
                return Memory.NULL;
            }
            style = style + "\n" + property + ": " + value + ";";
        }
        this.getWrappedObject().setStyle(style);
        return Memory.NULL;
    }

    @Reflection.Signature
    public void applyCss() {
        this.getWrappedObject().applyCss();
    }

    @Reflection.Signature
    public Memory data(String name) {
        return JavaFxUtils.data(this.getWrappedObject(), name);
    }

    @Reflection.Signature
    public Memory data(Environment env, String name, Memory value) {
        return JavaFxUtils.data(env, this.getWrappedObject(), name, value);
    }

    @Reflection.Signature
    public double[] screenToLocal(double x, double y) {
        Point2D pt = this.getWrappedObject().screenToLocal(x, y);
        if (pt == null) {
            return null;
        }
        return new double[]{pt.getX(), pt.getY()};
    }

    @Reflection.Signature
    public void show() {
        this.getWrappedObject().setVisible(true);
    }

    @Reflection.Signature
    public void hide() {
        this.getWrappedObject().setVisible(false);
    }

    @Reflection.Signature
    public void toggle() {
        this.getWrappedObject().setVisible(!this.getWrappedObject().isVisible());
    }

    @Reflection.Signature
    public Memory lookup(Environment env, TraceInfo trace, String selector) throws Throwable {
        Node result = UXNode.__globalLookup(this.getWrappedObject(), selector);
        if (result == null) {
            return null;
        }
        MemoryOperation operation = MemoryOperation.get(result.getClass(), null);
        if (operation == null) {
            return null;
        }
        return operation.unconvert(env, trace, (Object)result);
    }

    @Reflection.Signature
    public Memory lookupAll(Environment env, TraceInfo trace, String selector) throws Throwable {
        Set result = this.getWrappedObject().lookupAll(selector);
        ArrayMemory r = new ArrayMemory();
        for (Node node : result) {
            Memory el = MemoryOperation.get(node.getClass(), null).unconvert(env, trace, (Object)node);
            r.add(el);
        }
        return r.toConstant();
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    protected Memory getParent(Environment env) {
        return Memory.wrap((Environment)env, (Object)this.getWrappedObject().getParent());
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    protected UXScene getScene(Environment env) {
        if (this.getWrappedObject().getScene() == null) {
            return null;
        }
        return new UXScene(env, this.getWrappedObject().getScene());
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    protected UXForm getForm(Environment env) {
        Scene scene = this.getWrappedObject().getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        if (window == null && scene.getUserData() instanceof Window) {
            window = (Window)scene.getUserData();
        }
        if (window instanceof Stage) {
            return new UXForm(env, (Stage)window);
        }
        return null;
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    protected UXWindow getWindow(Environment env) {
        Scene scene = this.getWrappedObject().getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        if (window == null && scene.getUserData() instanceof Window) {
            window = (Window)scene.getUserData();
        }
        if (window != null) {
            return new UXWindow<Window>(env, window);
        }
        return null;
    }

    @Reflection.Signature
    public UXImage snapshot(Environment env) {
        SnapshotParameters snapParams = new SnapshotParameters();
        snapParams.setFill((Paint)Color.TRANSPARENT);
        WritableImage snapshot = this.getWrappedObject().snapshot(snapParams, null);
        return snapshot == null ? null : new UXImage(env, snapshot);
    }

    @Reflection.Signature
    public UXDragboard startDrag(Environment env, List<TransferMode> modes) {
        Dragboard dragboard = this.getWrappedObject().startDragAndDrop(modes.toArray(new TransferMode[0]));
        return dragboard == null ? null : new UXDragboard(env, dragboard);
    }

    @Reflection.Signature
    public ObservableValue observer(String property) {
        return JavaFxUtils.findObservable(this.getWrappedObject(), property);
    }

    @Reflection.Signature
    public void watch(final String property, final Invoker invoker) throws InvocationTargetException, IllegalAccessException {
        String name = property + "Property";
        Class<?> aClass = this.getWrappedObject().getClass();
        try {
            Method method = aClass.getMethod(name, new Class[0]);
            ReadOnlyProperty bindProperty = (ReadOnlyProperty)method.invoke(this.getWrappedObject(), new Object[0]);
            bindProperty.addListener(new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    invoker.callAny(new Object[]{UXNode.this, property, oldValue, newValue});
                }
            });
        }
        catch (ClassCastException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to find the '" + property + "' property for watching");
        }
    }

    @Override
    @Reflection.Signature
    public void on(String event, Invoker invoker, String group) {
        JavaFxUtils.on(this.getWrappedObject(), event, invoker, group);
    }

    @Override
    @Reflection.Signature
    public void on(String event, Invoker invoker) {
        JavaFxUtils.on(this.getWrappedObject(), event, invoker, "general");
    }

    @Override
    @Reflection.Signature
    public void off(String event, @Reflection.Nullable String group) {
        JavaFxUtils.off(this.getWrappedObject(), event, group);
    }

    @Override
    @Reflection.Signature
    public void off(String event) {
        JavaFxUtils.off(this.getWrappedObject(), event);
    }

    @Override
    @Reflection.Signature
    public void trigger(String event, @Reflection.Nullable Event e) {
        JavaFxUtils.trigger(this.getWrappedObject(), event, e);
    }

    @Reflection.Signature
    public boolean isFree() {
        return this.getWrappedObject().getParent() == null;
    }

    @Reflection.Signature
    public boolean free() {
        Parent parent = this.getWrappedObject().getParent();
        if (parent instanceof Pane) {
            return ((Pane)parent).getChildren().remove(this.getWrappedObject());
        }
        return false;
    }

    @Reflection.Signature
    public Memory __get(String name) {
        Memory data = this.data("--property-" + name);
        return data;
    }

    @Reflection.Signature
    public Memory __set(Environment env, String name, Memory value) throws Throwable {
        Invoker invoker;
        Memory data = this.data("--property-" + name + "-setter");
        if (data.isNotNull() && (invoker = Invoker.create((Environment)env, (Memory)data)) != null) {
            invoker.call(new Memory[]{value});
            return Memory.NULL;
        }
        this.data(env, "--property-" + name, value);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __isset(Environment env, String name) throws Throwable {
        Memory memory;
        if (this.data("--property-" + name).isNotNull()) {
            return Memory.TRUE;
        }
        CallStackItem callStackItem = env.peekCall(0);
        if (callStackItem != null) {
            callStackItem.classEntity = callStackItem.staticClassEntity;
            callStackItem.clazz = callStackItem.staticClazz;
        }
        return (memory = this.getReflection().getProperty(env, env.trace(), (IObject)this, name, null, 0)).isNotNull() ? Memory.TRUE : Memory.FALSE;
    }

    public int getPointer() {
        return this.getWrappedObject().hashCode();
    }

    public static Node __globalLookup(Node parent, String select) {
        if (parent == null) {
            return null;
        }
        Node node = parent.lookup(select);
        if (node != null) {
            return node;
        }
        if (parent instanceof Parent) {
            ObservableList nodes = ((Parent)parent).getChildrenUnmodifiable();
            if (parent instanceof SplitPane) {
                nodes = ((SplitPane)parent).getItems();
            }
            for (Node nd : nodes) {
                Node n;
                if (nd instanceof TitledPane && ((TitledPane)nd).getContent() instanceof Parent) {
                    node = UXNode.__globalLookup(((TitledPane)nd).getContent(), select);
                    if (node == null) continue;
                    return node;
                }
                if (nd instanceof ScrollPane && ((ScrollPane)nd).getContent() instanceof Parent) {
                    node = UXNode.__globalLookup(((ScrollPane)nd).getContent(), select);
                    if (node == null) continue;
                    return node;
                }
                if (nd instanceof SplitPane) {
                    for (Node one : ((SplitPane)nd).getItems()) {
                        if (!(one instanceof Parent) || (node = UXNode.__globalLookup(one, select)) == null) continue;
                        return node;
                    }
                    continue;
                }
                if (nd instanceof TabPane) {
                    for (Tab tab : ((TabPane)nd).getTabs()) {
                        if (!(tab.getContent() instanceof Parent) || (node = UXNode.__globalLookup(tab.getContent(), select)) == null) continue;
                        return node;
                    }
                    continue;
                }
                if (!(nd instanceof Parent) || (n = UXNode.__globalLookup(nd, select)) == null) continue;
                return n;
            }
        }
        return null;
    }

    static interface WrappedInterface {
        @Reflection.Property
        public double baselineOffset();

        @Reflection.Property
        public BlendMode blendMode();

        @Reflection.Property
        @Reflection.Nullable
        public Effect effect();

        @Reflection.Property(hiddenInDebugInfo=true)
        @Reflection.Nullable
        public Node clip();

        @Reflection.Property(hiddenInDebugInfo=true)
        public Orientation contentBias();

        @Reflection.Property(hiddenInDebugInfo=true)
        public DepthTest depthTest();

        @Reflection.Property
        public String id();

        @Reflection.Property(hiddenInDebugInfo=true)
        public double opacity();

        @Reflection.Property
        public double rotate();

        @Reflection.Property
        public double scaleX();

        @Reflection.Property
        public double scaleY();

        @Reflection.Property
        public double scaleZ();

        @Reflection.Property
        public String style();

        @Reflection.Property
        public double translateX();

        @Reflection.Property
        public double translateY();

        @Reflection.Property
        public double translateZ();

        @Reflection.Property
        public boolean cache();

        @Reflection.Property
        public CacheHint cacheHint();

        @Reflection.Property
        public boolean disabled();

        @Reflection.Property
        public boolean focused();

        @Reflection.Property
        public boolean focusTraversable();

        @Reflection.Property
        public boolean hover();

        @Reflection.Property
        public boolean managed();

        @Reflection.Property
        public boolean mouseTransparent();

        @Reflection.Property
        public boolean pickOnBounds();

        @Reflection.Property
        public boolean pressed();

        @Reflection.Property
        public boolean resizable();

        @Reflection.Property
        public boolean visible();

        @Reflection.Property(value="classes")
        public ObservableList<String> styleClass();

        public boolean contains(double var1, double var3);

        public void relocate(double var1, double var3);

        public void resize(double var1, double var3);

        public void startFullDrag();

        public void toBack();

        public void toFront();

        public void requestFocus();
    }
}

