/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.develnext.jphp.ext.javafx.classes.UXControl;
import org.develnext.jphp.ext.javafx.classes.UXTreeItem;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXTreeView")
public class UXTreeView
extends UXControl<TreeView> {
    public UXTreeView(Environment env, TreeView wrappedObject) {
        super(env, wrappedObject);
    }

    public UXTreeView(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new TreeView();
    }

    @Reflection.Getter
    public boolean getMultipleSelection() {
        return ((TreeView)this.getWrappedObject()).getSelectionModel().getSelectionMode() == SelectionMode.MULTIPLE;
    }

    @Reflection.Setter
    public void setMultipleSelection(boolean value) {
        ((TreeView)this.getWrappedObject()).getSelectionModel().setSelectionMode(value ? SelectionMode.MULTIPLE : SelectionMode.SINGLE);
    }

    @Reflection.Getter
    public List<Integer> getSelectedIndexes() {
        return ((TreeView)this.getWrappedObject()).getSelectionModel().getSelectedIndices();
    }

    @Reflection.Setter
    public void setSelectedIndexes(int[] indexes) {
        MultipleSelectionModel selectionModel = ((TreeView)this.getWrappedObject()).getSelectionModel();
        for (int index : indexes) {
            selectionModel.select(index);
        }
    }

    @Reflection.Getter
    public List<TreeItem> getSelectedItems() {
        return ((TreeView)this.getWrappedObject()).getSelectionModel().getSelectedItems();
    }

    @Reflection.Setter
    public void setSelectedItems(List<TreeItem> items) {
        MultipleSelectionModel selectionModel = ((TreeView)this.getWrappedObject()).getSelectionModel();
        selectionModel.clearSelection();
        for (TreeItem item : items) {
            selectionModel.select((Object)item);
        }
    }

    private void _getExpandedItems(Environment env, TreeItem item, ArrayMemory result) {
        if (item.isExpanded()) {
            result.add((IObject)new UXTreeItem(env, item));
        }
        ObservableList children = item.getChildren();
        for (TreeItem one : children) {
            this._getExpandedItems(env, one, result);
        }
    }

    @Reflection.Getter
    public Memory getExpandedItems(Environment env) {
        TreeItem root = ((TreeView)this.getWrappedObject()).getRoot();
        ArrayMemory result = new ArrayMemory();
        if (root != null) {
            this._getExpandedItems(env, root, result);
        }
        return result;
    }

    @Reflection.Getter
    public TreeItem getFocusedItem() {
        return (TreeItem)((TreeView)this.getWrappedObject()).getFocusModel().getFocusedItem();
    }

    @Reflection.Setter
    public void setFocusedItem(@Reflection.Nullable TreeItem item) {
        ((TreeView)this.getWrappedObject()).getFocusModel().focus(item == null ? -1 : ((TreeView)this.getWrappedObject()).getRow(item));
    }

    @Reflection.Signature
    public boolean isTreeItemFocused(TreeItem item) {
        return ((TreeView)this.getWrappedObject()).getFocusModel().isFocused(((TreeView)this.getWrappedObject()).getRow(item));
    }

    @Reflection.Signature
    public int getTreeItemIndex(TreeItem item) {
        return ((TreeView)this.getWrappedObject()).getRow(item);
    }

    @Reflection.Signature
    public void scrollTo(TreeItem item) {
        ((TreeView)this.getWrappedObject()).scrollTo(((TreeView)this.getWrappedObject()).getRow(item));
    }

    private void expandTreeView(TreeItem<?> item) {
        if (item != null && !item.isLeaf()) {
            item.setExpanded(true);
            for (TreeItem child : item.getChildren()) {
                this.expandTreeView(child);
            }
        }
    }

    private void collapseTreeView(TreeItem<?> item) {
        if (item != null && !item.isLeaf()) {
            item.setExpanded(false);
            for (TreeItem child : item.getChildren()) {
                this.collapseTreeView(child);
            }
        }
    }

    @Reflection.Signature
    public void collapseAll() {
        TreeItem root = ((TreeView)this.getWrappedObject()).getRoot();
        if (root != null) {
            this.collapseTreeView(root);
        }
    }

    @Reflection.Signature
    public void expandAll() {
        TreeItem root = ((TreeView)this.getWrappedObject()).getRoot();
        if (root != null) {
            this.expandTreeView(root);
        }
    }

    static interface WrappedInterface {
        @Reflection.Property
        public TreeItem root();

        @Reflection.Property
        public TreeItem editingItem();

        @Reflection.Property
        public int expandedItemCount();

        @Reflection.Property
        public double fixedCellSize();

        @Reflection.Property
        public boolean editable();

        @Reflection.Property(value="rootVisible")
        public boolean showRoot();

        public TreeItem getTreeItem(int var1);

        public int getTreeItemLevel(TreeItem var1);

        public void edit(TreeItem var1);
    }
}

