/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.develnext.jphp.core.compiler.common.misc.StackItem;
import org.develnext.jphp.core.compiler.common.util.CompilerUtils;
import org.develnext.jphp.core.compiler.jvm.JvmCompiler;
import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ClassStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.MethodStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.StmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BodyCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.ClassInitEnvironmentCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.DoCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.EchoCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.EchoRawCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.ForCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.ForeachCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.FunctionCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.GlobalDefinitionCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.GotoCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.GotoLabelCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.IfElseCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.JumpCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.OpenEchoTagCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.ReturnCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.StaticDefinitionCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.SwitchCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.ThrowCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.TryCatchCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.WhileCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.operator.DynamicAccessCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.operator.InstanceOfCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.BooleanValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.ClosureValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.DieCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.DoubleValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.EmptyCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.ImportCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.IntValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.IssetCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.ListCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.NewValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.NullValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.SelfValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.ShellExecValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.StaticAccessValueAsOperatorCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.StaticAccessValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.StaticValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.StringBuilderValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.StringValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.UnsetCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.VarVarValueCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.YieldValueCompiler;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.OpenEchoTagToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.ClassExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AmpersandRefToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetEmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayPushExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignConcatExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignMulExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignOperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignPlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignableOperatorToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanAnd2ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanAndExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanOr2ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanOrExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.CallOperatorToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ConcatExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessAssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessEmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.IncExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.InstanceofExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.KeyValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.LogicOperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MulExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.SilentToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.StaticAccessOperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ValueIfElseToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ValueNullCoalesceIfElseToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ArrayExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.BooleanExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.CallExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.CallableExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ClosureStmtToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DieExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DoubleExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.EmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.GetVarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IncludeExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IncludeOnceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IntegerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ListExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NewExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NullExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ParentExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.RequireExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.RequireOnceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ShellExecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringBuilderExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.UnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.YieldExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.ClassMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.DirMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.FileMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.FunctionMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.LineMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.MacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.MethodMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.NamespaceMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.TraitMacroToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BreakStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ContinueStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoRawToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForeachStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GlobalStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GotoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.IfStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.LabelStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ReturnStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StaticStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.SwitchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ThrowStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.WhileStmtToken;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import php.runtime.Memory;
import php.runtime.OperatorUtils;
import php.runtime.annotation.Runtime;
import php.runtime.common.Association;
import php.runtime.common.Messages;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.ext.support.compile.CompileClass;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.ext.support.compile.CompileFunction;
import php.runtime.invoke.InvokeHelper;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.FunctionCallCache;
import php.runtime.invoke.cache.MethodCallCache;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.FalseMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.NullMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.memory.helper.UndefinedMemory;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.support.Entity;

public class ExpressionStmtCompiler
extends StmtCompiler {
    protected final MethodStmtCompiler method;
    protected final MethodStmtToken methodStatement;
    protected final ExprStmtToken expression;
    private MethodNode node;
    private InsnList code;
    private Stack<Integer> exprStackInit = new Stack();
    private int lastLineNumber = -1;
    private Map<Class<? extends Token>, BaseStatementCompiler> compilers;
    private static final Map<Class<? extends Token>, Class<? extends BaseStatementCompiler>> compilerRules = new HashMap<Class<? extends Token>, Class<? extends BaseStatementCompiler>>();

    public ExpressionStmtCompiler(MethodStmtCompiler method, ExprStmtToken expression) {
        super(method.getCompiler());
        this.method = method;
        this.expression = expression;
        this.node = method.node;
        this.code = method.node.instructions;
        this.methodStatement = method.statement != null ? method.statement : MethodStmtToken.of("", method.clazz.statement);
    }

    public ExpressionStmtCompiler(JvmCompiler compiler) {
        super(compiler);
        this.expression = null;
        ClassStmtCompiler classStmtCompiler = new ClassStmtCompiler(compiler, new ClassStmtToken(new TokenMeta("", 0, 0, 0, 0)));
        this.method = new MethodStmtCompiler(classStmtCompiler, (MethodStmtToken)null);
        this.methodStatement = this.method.statement != null ? this.method.statement : MethodStmtToken.of("", this.method.clazz.statement);
        this.node = this.method.node;
        this.code = this.method.node.instructions;
    }

    public <T extends Token> T write(Class<? extends Token> clazz, T token) {
        BaseStatementCompiler<? extends Token> cmp = this.getCompiler(clazz);
        if (cmp == null) {
            throw new CriticalException("Cannot find compiler for " + clazz.getName());
        }
        cmp.write(token);
        return token;
    }

    public <T extends Token> T write(T token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        return this.write(token.getClass(), token);
    }

    public <T extends ValueExprToken> T writeValue(T token, boolean returnValue) {
        BaseStatementCompiler<?> cmp = this.getCompiler(token.getClass());
        if (cmp == null) {
            throw new CriticalException("Cannot find compiler for " + token.getClass().getName());
        }
        if (!(cmp instanceof BaseExprCompiler)) {
            throw new CriticalException("Compiler is not for values");
        }
        ((BaseExprCompiler)cmp).write(token, returnValue);
        return token;
    }

    public <T extends Token> BaseStatementCompiler<T> getCompiler(Class<T> clazz) {
        BaseStatementCompiler r;
        if (this.compilers == null) {
            this.compilers = new HashMap<Class<? extends Token>, BaseStatementCompiler>();
        }
        if ((r = this.compilers.get(clazz)) != null) {
            return r;
        }
        Class<? extends BaseStatementCompiler> rule = compilerRules.get(clazz);
        if (rule == null) {
            return null;
        }
        try {
            r = rule.getConstructor(ExpressionStmtCompiler.class).newInstance(this);
            this.compilers.put(clazz, r);
            return r;
        }
        catch (Exception e) {
            throw new CriticalException((Throwable)e);
        }
    }

    public MethodNode getMethodNode() {
        return this.node;
    }

    public MethodStmtCompiler getMethod() {
        return this.method;
    }

    public MethodStmtToken getMethodStatement() {
        return this.methodStatement;
    }

    public void makeVarStore(LocalVariable variable) {
        this.code.add((AbstractInsnNode)new VarInsnNode(58, variable.index));
    }

    public void makeVarLoad(LocalVariable variable) {
        this.code.add((AbstractInsnNode)new VarInsnNode(25, variable.index));
    }

    public void makeUnknown(AbstractInsnNode node) {
        this.code.add(node);
    }

    public LabelNode makeLabel() {
        LabelNode el = new LabelNode();
        this.code.add((AbstractInsnNode)el);
        return el;
    }

    protected Memory getMacros(ValueExprToken token) {
        if (token instanceof SelfExprToken) {
            if (((ClassEntity)this.method.clazz.entity).isTrait()) {
                throw new IllegalArgumentException("Cannot use this in Traits");
            }
            return new StringMemory(this.method.clazz.statement.getFulledName());
        }
        return null;
    }

    protected void stackPush(ValueExprToken token, StackItem.Type type) {
        this.method.push(new StackItem(token, type));
    }

    public void stackPush(StackItem item) {
        this.method.push(item);
    }

    public void stackPush(Memory memory) {
        this.method.push(new StackItem(memory));
    }

    public void stackPush(ValueExprToken token, Memory memory) {
        this.method.push(new StackItem(token, memory));
    }

    public void stackPush(Memory.Type type) {
        this.stackPush(null, StackItem.Type.valueOf(type));
    }

    public void stackPush(ValueExprToken token) {
        Memory o = CompilerUtils.toMemory(token, new Memory[0]);
        if (o != null) {
            this.stackPush(o);
        } else if (token instanceof StaticAccessExprToken) {
            StaticAccessExprToken access = (StaticAccessExprToken)token;
            if (access.getField() instanceof NameToken) {
                ConstantEntity c;
                String constant = ((NameToken)access.getField()).getName();
                String clazz = null;
                ClassEntity entity = null;
                if (access.getClazz() instanceof ParentExprToken) {
                    entity = ((ClassEntity)this.method.clazz.entity).getParent();
                    if (entity != null) {
                        clazz = entity.getName();
                    }
                } else if (access.getClazz() instanceof FulledNameToken) {
                    clazz = ((FulledNameToken)access.getClazz()).getName();
                    entity = this.compiler.getModule().findClass(clazz);
                }
                if (entity == null && this.method.clazz.entity != null && ((ClassEntity)this.method.clazz.entity).getName().equalsIgnoreCase(clazz)) {
                    entity = (ClassEntity)this.method.clazz.entity;
                }
                if (entity != null && (c = entity.findConstant(constant)) != null && c.getValue() != null && c.isPublic()) {
                    this.stackPush(c.getValue());
                    this.stackPeek().setLevel(-1);
                    return;
                }
            }
            this.stackPush(token, StackItem.Type.REFERENCE);
        } else {
            LocalVariable local;
            if (token instanceof VariableExprToken && !this.methodStatement.isUnstableVariable((VariableExprToken)token) && (local = this.method.getLocalVariable(((VariableExprToken)token).getName())) != null && local.getValue() != null) {
                this.stackPush(token, local.getValue());
                this.stackPeek().setLevel(-1);
                return;
            }
            this.stackPush(token, StackItem.Type.REFERENCE);
        }
        this.stackPeek().setLevel(-1);
    }

    public StackItem stackPop() {
        return this.method.pop();
    }

    public ValueExprToken stackPopToken() {
        return this.method.pop().getToken();
    }

    public StackItem stackPeek() {
        return this.method.peek();
    }

    public void setStackPeekAsImmutable(boolean value) {
        this.method.peek().immutable = value;
    }

    public void setStackPeekAsImmutable() {
        this.setStackPeekAsImmutable(true);
    }

    public ValueExprToken stackPeekToken() {
        return this.method.peek().getToken();
    }

    public boolean stackEmpty(boolean relative) {
        if (relative) {
            return this.method.getStackCount() == this.exprStackInit.peek().intValue();
        }
        return this.method.getStackCount() == 0;
    }

    public void writeLineNumber(Token token) {
        if (token.getMeta().getStartLine() > this.lastLineNumber) {
            this.lastLineNumber = token.getMeta().getStartLine();
            this.code.add((AbstractInsnNode)new LineNumberNode(this.lastLineNumber, new LabelNode()));
        }
    }

    public void writeWarning(Token token, String message) {
        this.writePushEnv();
        this.writePushTraceInfo(token);
        this.writePushConstString(message);
        this.writePushConstNull();
        this.writeSysDynamicCall(Environment.class, "warning", Void.TYPE, TraceInfo.class, String.class, Object[].class);
    }

    public void writePushBooleanAsMemory(boolean value) {
        if (value) {
            this.code.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Memory.class), "TRUE", Type.getDescriptor(Memory.class)));
        } else {
            this.code.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Memory.class), "FALSE", Type.getDescriptor(Memory.class)));
        }
        this.stackPush(Memory.Type.REFERENCE);
    }

    public void writePushMemory(Memory memory) {
        Memory.Type type = Memory.Type.REFERENCE;
        if (memory instanceof UndefinedMemory) {
            this.code.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Memory.class), "UNDEFINED", Type.getDescriptor(Memory.class)));
        } else if (memory instanceof NullMemory) {
            this.code.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Memory.class), "NULL", Type.getDescriptor(Memory.class)));
        } else {
            if (memory instanceof FalseMemory) {
                this.writePushConstBoolean(false);
                return;
            }
            if (memory instanceof TrueMemory) {
                this.writePushConstBoolean(true);
                return;
            }
            if (memory instanceof KeyValueMemory) {
                this.writePushMemory(((KeyValueMemory)memory).key);
                this.writePopBoxing();
                this.writePushMemory(((KeyValueMemory)memory).getValue());
                this.writePopBoxing();
                Object arrayKey = ((KeyValueMemory)memory).getArrayKey();
                if (arrayKey instanceof String) {
                    this.writePushConstString((String)arrayKey);
                    this.writeSysStaticCall(KeyValueMemory.class, "valueOf", Memory.class, Memory.class, Memory.class, String.class);
                } else if (arrayKey instanceof LongMemory) {
                    this.writePushConstantMemory((Memory)arrayKey);
                    this.writeSysStaticCall(KeyValueMemory.class, "valueOf", Memory.class, Memory.class, Memory.class, Memory.class);
                } else {
                    this.writeSysStaticCall(KeyValueMemory.class, "valueOf", Memory.class, Memory.class, Memory.class);
                }
                this.setStackPeekAsImmutable();
                return;
            }
            if (memory instanceof ReferenceMemory) {
                this.code.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(ReferenceMemory.class)));
                this.code.add((AbstractInsnNode)new InsnNode(89));
                this.code.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(ReferenceMemory.class), "<init>", "()V", false));
            } else {
                if (memory instanceof ArrayMemory) {
                    ArrayMemory array = (ArrayMemory)memory;
                    this.writePushConstInt(array.size());
                    if (!array.isList()) {
                        this.writeSysStaticCall(ArrayMemory.class, "createHashed", ArrayMemory.class, Integer.TYPE);
                    } else {
                        this.writeSysStaticCall(ArrayMemory.class, "createListed", ArrayMemory.class, Integer.TYPE);
                    }
                    ForeachIterator foreachIterator = ((ArrayMemory)memory).foreachIterator(false, false);
                    while (foreachIterator.next()) {
                        this.writePushDup();
                        if (array.isList()) {
                            this.writePushMemory(foreachIterator.getValue());
                            this.writePopBoxing();
                            this.writeSysDynamicCall(ArrayMemory.class, "add", ReferenceMemory.class, Memory.class);
                        } else {
                            Memory key = foreachIterator.getMemoryKey();
                            this.writePushMemory(key);
                            if (!key.isString()) {
                                this.writePopBoxing();
                            }
                            this.writePushMemory(foreachIterator.getValue());
                            this.writePopBoxing();
                            this.writeSysDynamicCall(ArrayMemory.class, "put", ReferenceMemory.class, Object.class, Memory.class);
                        }
                        this.writePopAll(1);
                    }
                    this.setStackPeekAsImmutable();
                    return;
                }
                switch (memory.type) {
                    case INT: {
                        this.code.add((AbstractInsnNode)new LdcInsnNode((Object)memory.toLong()));
                        type = Memory.Type.INT;
                        break;
                    }
                    case DOUBLE: {
                        this.code.add((AbstractInsnNode)new LdcInsnNode((Object)memory.toDouble()));
                        type = Memory.Type.DOUBLE;
                        break;
                    }
                    case STRING: {
                        this.code.add((AbstractInsnNode)new LdcInsnNode((Object)memory.toString()));
                        type = Memory.Type.STRING;
                    }
                }
            }
        }
        this.stackPush(type);
        this.setStackPeekAsImmutable();
    }

    public boolean writePopBoxing(boolean asImmutable) {
        return this.writePopBoxing(this.stackPeek().type, asImmutable);
    }

    public boolean writePopBoxing(boolean asImmutable, boolean useConstants) {
        return this.writePopBoxing(this.stackPeek().type, asImmutable, useConstants);
    }

    public boolean writePopBoxing() {
        return this.writePopBoxing(false);
    }

    public boolean writePopBoxing(Class<?> clazz, boolean asImmutable) {
        return this.writePopBoxing(StackItem.Type.valueOf(clazz), asImmutable);
    }

    public boolean writePopBoxing(Class<?> clazz) {
        return this.writePopBoxing(clazz, false);
    }

    public boolean writePopBoxing(StackItem.Type type) {
        return this.writePopBoxing(type, false);
    }

    public boolean writePopBoxing(StackItem.Type type, boolean asImmutable) {
        return this.writePopBoxing(type, asImmutable, true);
    }

    public boolean writePopBoxing(StackItem.Type type, boolean asImmutable, boolean useConstants) {
        switch (type) {
            case BOOL: {
                this.writeSysStaticCall(TrueMemory.class, "valueOf", Memory.class, type.toClass());
                this.setStackPeekAsImmutable();
                return true;
            }
            case SHORT: 
            case BYTE: 
            case LONG: 
            case INT: {
                if (useConstants && this.code.getLast() instanceof LdcInsnNode) {
                    LdcInsnNode node = (LdcInsnNode)this.code.getLast();
                    this.code.remove((AbstractInsnNode)node);
                    this.stackPop();
                    this.writePushConstantMemory(LongMemory.valueOf((long)((Long)node.cst)));
                } else {
                    this.writeSysStaticCall(LongMemory.class, "valueOf", Memory.class, type.toClass());
                }
                this.setStackPeekAsImmutable();
                return true;
            }
            case FLOAT: 
            case DOUBLE: {
                if (useConstants && this.code.getLast() instanceof LdcInsnNode) {
                    LdcInsnNode node = (LdcInsnNode)this.code.getLast();
                    this.code.remove((AbstractInsnNode)node);
                    this.stackPop();
                    if (type == StackItem.Type.FLOAT) {
                        this.writePushConstantMemory(DoubleMemory.valueOf((float)((Float)node.cst).floatValue()));
                    } else {
                        this.writePushConstantMemory(DoubleMemory.valueOf((double)((Double)node.cst)));
                    }
                } else {
                    this.writeSysStaticCall(DoubleMemory.class, "valueOf", Memory.class, type.toClass());
                }
                this.setStackPeekAsImmutable();
                return true;
            }
            case STRING: {
                if (useConstants && this.code.getLast() instanceof LdcInsnNode) {
                    LdcInsnNode node = (LdcInsnNode)this.code.getLast();
                    this.code.remove((AbstractInsnNode)node);
                    this.stackPop();
                    this.writePushConstantMemory(StringMemory.valueOf((String)node.cst.toString()));
                } else {
                    this.writeSysStaticCall(StringMemory.class, "valueOf", Memory.class, String.class);
                }
                this.setStackPeekAsImmutable();
                return true;
            }
            case REFERENCE: {
                if (!asImmutable) break;
                this.writePopImmutable();
            }
        }
        return false;
    }

    public void writePushSmallInt(int value) {
        switch (value) {
            case -1: {
                this.code.add((AbstractInsnNode)new InsnNode(2));
                break;
            }
            case 0: {
                this.code.add((AbstractInsnNode)new InsnNode(3));
                break;
            }
            case 1: {
                this.code.add((AbstractInsnNode)new InsnNode(4));
                break;
            }
            case 2: {
                this.code.add((AbstractInsnNode)new InsnNode(5));
                break;
            }
            case 3: {
                this.code.add((AbstractInsnNode)new InsnNode(6));
                break;
            }
            case 4: {
                this.code.add((AbstractInsnNode)new InsnNode(7));
                break;
            }
            case 5: {
                this.code.add((AbstractInsnNode)new InsnNode(8));
                break;
            }
            default: {
                this.code.add((AbstractInsnNode)new LdcInsnNode((Object)value));
            }
        }
        this.stackPush(Memory.Type.INT);
    }

    public void writePushScalarBoolean(boolean value) {
        this.writePushSmallInt(value ? 1 : 0);
        this.stackPop();
        this.stackPush(value ? Memory.TRUE : Memory.FALSE);
    }

    public void writePushString(String value) {
        this.writePushMemory((Memory)new StringMemory(value));
    }

    public void writePushConstString(String value) {
        this.writePushString(value);
    }

    public void writePushConstDouble(double value) {
        this.code.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        this.stackPush(null, StackItem.Type.DOUBLE);
    }

    public void writePushConstFloat(float value) {
        this.code.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(value)));
        this.stackPush(null, StackItem.Type.FLOAT);
    }

    public void writePushConstLong(long value) {
        this.code.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        this.stackPush(null, StackItem.Type.LONG);
    }

    public void writePushConstInt(int value) {
        this.writePushSmallInt(value);
    }

    public void writePushConstShort(short value) {
        this.writePushConstInt(value);
        this.stackPop();
        this.stackPush(null, StackItem.Type.SHORT);
    }

    public void writePushConstByte(byte value) {
        this.writePushConstInt(value);
        this.stackPop();
        this.stackPush(null, StackItem.Type.BYTE);
    }

    public void writePushConstBoolean(boolean value) {
        this.writePushConstInt(value ? 1 : 0);
        this.stackPop();
        this.stackPush(null, StackItem.Type.BOOL);
    }

    public void writePushSelf(boolean withLower) {
        if (((ClassEntity)this.method.clazz.entity).isTrait()) {
            if (this.method.getLocalVariable("~class_name") != null) {
                this.writeVarLoad("~class_name");
            } else {
                this.writePushEnv();
                this.writeSysDynamicCall(Environment.class, "__getMacroClass", Memory.class, new Class[0]);
            }
            this.writePopString();
            if (withLower) {
                this.writePushDupLowerCase();
            }
        } else {
            this.writePushConstString(this.method.clazz.statement.getFulledName());
            if (withLower) {
                this.writePushConstString(this.method.clazz.statement.getFulledName().toLowerCase());
            }
        }
    }

    public void writePushStatic() {
        this.writePushEnv();
        this.writeSysDynamicCall(Environment.class, "getLateStatic", String.class, new Class[0]);
    }

    public void writePushParent(Token token) {
        this.writePushEnv();
        this.writePushTraceInfo(token);
        if (this.method.getLocalVariable("~class_name") != null) {
            this.writeVarLoad("~class_name");
            this.writeSysDynamicCall(Environment.class, "__getParent", String.class, TraceInfo.class, String.class);
        } else {
            this.writeSysDynamicCall(Environment.class, "__getParent", String.class, TraceInfo.class);
        }
    }

    public void writePushLocal() {
        this.writeVarLoad("~local");
    }

    public void writePushEnv() {
        ((MethodEntity)this.method.entity).setUsesStackTrace(true);
        LocalVariable variable = this.method.getLocalVariable("~env");
        if (variable == null) {
            if (this.methodStatement.isStatic()) {
                throw new RuntimeException("Cannot find `~env` variable");
            }
            this.writePushEnvFromSelf();
            return;
        }
        this.stackPush(Memory.Type.REFERENCE);
        this.makeVarLoad(variable);
    }

    public void writePushEnvFromSelf() {
        ((MethodEntity)this.method.entity).setUsesStackTrace(true);
        this.writeVarLoad("~this");
        this.writeSysDynamicCall(null, "getEnvironment", Environment.class, new Class[0]);
    }

    public void writePushDup(StackItem.Type type) {
        this.stackPush(null, type);
        if (type.size() == 2) {
            this.code.add((AbstractInsnNode)new InsnNode(92));
        } else {
            this.code.add((AbstractInsnNode)new InsnNode(89));
        }
    }

    public void writePushDup() {
        StackItem item = this.method.peek();
        this.stackPush(item);
        if (item.type.size() == 2) {
            this.code.add((AbstractInsnNode)new InsnNode(92));
        } else {
            this.code.add((AbstractInsnNode)new InsnNode(89));
        }
    }

    public void writePushDupLowerCase() {
        this.writePushDup();
        this.writePopString();
        this.writeSysDynamicCall(String.class, "toLowerCase", String.class, new Class[0]);
    }

    public void writePushNull() {
        this.writePushMemory(Memory.NULL);
    }

    public void writePushVoid() {
        this.writePushMemory(Memory.UNDEFINED);
    }

    public void writePushConstNull() {
        this.stackPush(Memory.Type.REFERENCE);
        this.code.add((AbstractInsnNode)new InsnNode(1));
    }

    public void writePushNewObject(Class clazz) {
        this.code.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName((Class)clazz)));
        this.stackPush(Memory.Type.REFERENCE);
        this.writePushDup();
        this.writeSysCall(clazz, 183, "<init>", Void.TYPE, new Class[0]);
        this.stackPop();
    }

    public void writePushNewObject(String internalName, Class ... paramClasses) {
        this.code.add((AbstractInsnNode)new TypeInsnNode(187, internalName));
        this.stackPush(Memory.Type.REFERENCE);
        this.writePushDup();
        this.writeSysCall(internalName, 183, "<init>", Void.TYPE, paramClasses);
        this.stackPop();
    }

    public void writePushStaticCall(Method method) {
        this.writeSysStaticCall(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    Memory writePushCompileFunction(CallExprToken function, CompileFunction compileFunction, boolean returnValue, boolean writeOpcode, PushCallStatistic statistic) {
        CompileFunction.Method method = compileFunction.find(function.getParameters().size());
        if (method == null) {
            if (!writeOpcode) {
                return Memory.NULL;
            }
            this.writeWarning(function, Messages.ERR_EXPECT_LEAST_PARAMS.fetch(new Object[]{compileFunction.name, compileFunction.getMinArgs(), function.getParameters().size()}));
            if (returnValue) {
                this.writePushNull();
            }
            return null;
        }
        if (!method.isVarArg() && method.argsCount < function.getParameters().size()) {
            if (!writeOpcode) {
                return Memory.NULL;
            }
            this.writeWarning(function, Messages.ERR_EXPECT_EXACTLY_PARAMS.fetch(new Object[]{compileFunction.name, method.argsCount, function.getParameters().size()}));
            if (returnValue) {
                this.writePushNull();
            }
            return null;
        }
        if (statistic != null) {
            statistic.returnType = StackItem.Type.valueOf(method.resultType);
        }
        Class[] types = method.parameterTypes;
        ListIterator<ExprStmtToken> iterator = function.getParameters().listIterator();
        Object[] arguments = new Object[types.length];
        int j = 0;
        boolean immutable = method.isImmutable;
        boolean init = false;
        for (int i = 0; i < method.parameterTypes.length; ++i) {
            Class argType = method.parameterTypes[i];
            boolean isRef = method.references[i];
            boolean isMutable = method.isPresentAnnotationOfParam(i, Runtime.MutableValue.class);
            if (method.isPresentAnnotationOfParam(i, Runtime.GetLocals.class)) {
                if (!writeOpcode) {
                    return null;
                }
                immutable = false;
                this.writePushLocal();
                continue;
            }
            if (argType == Environment.class) {
                if (immutable) {
                    arguments[i] = this.compiler.getEnvironment();
                    continue;
                }
                if (!writeOpcode) {
                    return null;
                }
                this.writePushEnv();
                continue;
            }
            if (argType == TraceInfo.class) {
                if (immutable) {
                    arguments[i] = function.toTraceInfo(this.compiler.getContext());
                    continue;
                }
                if (!writeOpcode) {
                    return null;
                }
                this.writePushTraceInfo(function);
                continue;
            }
            if (argType == Memory[].class) {
                Memory[] args = new Memory[function.getParameters().size() - j];
                boolean arrCreated = false;
                for (int t = 0; t < function.getParameters().size() - j; ++t) {
                    ExprStmtToken next = iterator.next();
                    if (immutable) {
                        args[t] = this.writeExpression(next, true, true, false);
                    }
                    if (args[t] != null) continue;
                    if (!writeOpcode) {
                        return null;
                    }
                    if (!arrCreated) {
                        if (immutable) {
                            for (int n = 0; n < i; ++n) {
                                if (arguments[n] instanceof TraceInfo) {
                                    this.writePushTraceInfo(function);
                                    continue;
                                }
                                if (arguments[n] instanceof Environment) {
                                    this.writePushEnv();
                                    continue;
                                }
                                this.writePushMemory((Memory)arguments[n]);
                                this.writePop(types[n], true, true);
                                arguments[t] = null;
                            }
                        }
                        this.writePushSmallInt(args.length);
                        this.code.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Memory.class)));
                        this.stackPop();
                        this.stackPush(Memory.Type.REFERENCE);
                        arrCreated = true;
                    }
                    this.writePushDup();
                    this.writePushSmallInt(t);
                    this.writeExpression(next, true, false, writeOpcode);
                    this.writePopBoxing(!isRef);
                    this.code.add((AbstractInsnNode)new InsnNode(83));
                    this.stackPop();
                    this.stackPop();
                    this.stackPop();
                    immutable = false;
                }
                if (!immutable && !arrCreated) {
                    this.code.add((AbstractInsnNode)new InsnNode(1));
                    this.stackPush(Memory.Type.REFERENCE);
                }
                arguments[i] = MemoryUtils.valueOf((Object)args);
                continue;
            }
            ExprStmtToken next = iterator.next();
            if (!immutable && !init) {
                init = true;
                for (int k = 0; k < i; ++k) {
                    if (arguments[k] == null) continue;
                    if (arguments[k] instanceof TraceInfo) {
                        this.writePushTraceInfo(function);
                        continue;
                    }
                    if (arguments[k] instanceof Environment) {
                        this.writePushEnv();
                        continue;
                    }
                    this.writePushMemory((Memory)arguments[k]);
                    this.writePop(types[k], true, isRef);
                    arguments[k] = null;
                }
            }
            if (immutable) {
                arguments[i] = this.writeExpression(next, true, true, false);
            }
            if (arguments[i] == null) {
                if (!writeOpcode) {
                    return null;
                }
                if (!init) {
                    for (int n = 0; n < i; ++n) {
                        if (arguments[n] instanceof TraceInfo) {
                            this.writePushTraceInfo(function);
                        } else if (arguments[n] instanceof Environment) {
                            this.writePushEnv();
                        } else {
                            this.writePushMemory((Memory)arguments[n]);
                            this.writePop(types[n], true, false);
                        }
                        arguments[n] = null;
                    }
                    init = true;
                }
                if (isRef) {
                    this.writeExpression(next, true, false, writeOpcode);
                } else {
                    Memory tmp = this.writeExpression(next, true, true, true);
                    if (tmp != null) {
                        this.writePushMemory(tmp);
                    }
                }
                this.writePop(argType, true, isMutable && !isRef);
                if (!isMutable && !isRef && this.stackPeek().type.isReference()) {
                    this.writeSysDynamicCall(Memory.class, "toValue", Memory.class, new Class[0]);
                }
                immutable = false;
            }
            ++j;
        }
        if (immutable) {
            if (!returnValue) {
                return null;
            }
            Object[] typedArguments = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                typedArguments[i] = method.parameterTypes[i] != Memory.class && arguments[i] instanceof Memory ? method.converters[i].run((Memory)arguments[i]) : arguments[i];
            }
            try {
                Object value = method.method.invoke(null, typedArguments);
                return MemoryUtils.valueOf((Object)value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        if (!writeOpcode) {
            return null;
        }
        ((MethodEntity)this.method.entity).setImmutable(false);
        this.writeLineNumber(function);
        this.writePushStaticCall(method.method);
        if (returnValue) {
            if (method.resultType == Void.TYPE) {
                this.writePushNull();
            }
            this.setStackPeekAsImmutable();
        }
        return null;
    }

    public void writePushParameters(Collection<Memory> memories) {
        this.writePushSmallInt(memories.size());
        this.code.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Memory.class)));
        this.stackPop();
        this.stackPush(Memory.Type.REFERENCE);
        int i = 0;
        for (Memory param : memories) {
            this.writePushDup();
            this.writePushSmallInt(i);
            this.writePushMemory(param);
            this.writePopBoxing(true, false);
            this.code.add((AbstractInsnNode)new InsnNode(83));
            this.stackPop();
            this.stackPop();
            this.stackPop();
            ++i;
        }
    }

    public void writePushParameters(Collection<ExprStmtToken> parameters, Memory ... additional) {
        this.writePushParameters(parameters, true, additional);
    }

    public void writePushParameters(Collection<ExprStmtToken> parameters, boolean useConstants, Memory ... additional) {
        if (parameters.isEmpty()) {
            this.code.add((AbstractInsnNode)new InsnNode(1));
            this.stackPush(Memory.Type.REFERENCE);
            return;
        }
        if (useConstants && additional == null || additional.length == 0) {
            ExprStmtToken param;
            Memory paramMemory;
            ArrayList<Memory> constantParameters = new ArrayList<Memory>();
            Memory[] memoryArray = parameters.iterator();
            while (memoryArray.hasNext() && (paramMemory = this.writeExpression(param = memoryArray.next(), true, true, false)) != null && !paramMemory.isArray()) {
                constantParameters.add(paramMemory);
            }
            if (constantParameters.size() == parameters.size()) {
                this.writePushConstantMemoryArray(constantParameters);
                return;
            }
        }
        this.writePushSmallInt(parameters.size() + (additional == null ? 0 : additional.length));
        this.code.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Memory.class)));
        this.stackPop();
        this.stackPush(Memory.Type.REFERENCE);
        int i = 0;
        for (ExprStmtToken param : parameters) {
            this.writePushDup();
            this.writePushSmallInt(i);
            this.writeExpression(param, true, false);
            this.writePopBoxing();
            this.code.add((AbstractInsnNode)new InsnNode(83));
            this.stackPop();
            this.stackPop();
            this.stackPop();
            ++i;
        }
        if (additional != null) {
            for (Memory m : additional) {
                this.writePushDup();
                this.writePushSmallInt(i);
                this.writePushMemory(m);
                this.writePopBoxing();
                this.code.add((AbstractInsnNode)new InsnNode(83));
                this.stackPop();
                this.stackPop();
                this.stackPop();
                ++i;
            }
        }
    }

    Memory writePushParentDynamicMethod(CallExprToken function, boolean returnValue, boolean writeOpcode, PushCallStatistic statistic) {
        if (!writeOpcode) {
            return null;
        }
        StaticAccessExprToken dynamic = (StaticAccessExprToken)function.getName();
        this.writeLineNumber(function);
        this.writePushThis();
        if (dynamic.getField() != null) {
            if (dynamic.getField() instanceof NameToken) {
                String name = ((NameToken)dynamic.getField()).getName();
                this.writePushConstString(name);
                this.writePushConstString(name.toLowerCase());
            } else {
                this.writePush(dynamic.getField(), true, false);
                this.writePopString();
                this.writePushDupLowerCase();
            }
        } else {
            this.writeExpression(dynamic.getFieldExpr(), true, false);
            this.writePopString();
            this.writePushDupLowerCase();
        }
        this.writePushEnv();
        this.writePushTraceInfo(dynamic);
        this.writePushParameters(function.getParameters(), new Memory[0]);
        this.writeSysStaticCall(ObjectInvokeHelper.class, "invokeParentMethod", Memory.class, Memory.class, String.class, String.class, Environment.class, TraceInfo.class, Memory[].class);
        if (!returnValue) {
            this.writePopAll(1);
        }
        if (statistic != null) {
            statistic.returnType = StackItem.Type.REFERENCE;
        }
        return null;
    }

    Memory writePushDynamicMethod(CallExprToken function, boolean returnValue, boolean writeOpcode, PushCallStatistic statistic) {
        if (!writeOpcode) {
            return null;
        }
        DynamicAccessExprToken access = (DynamicAccessExprToken)function.getName();
        if (access instanceof DynamicAccessAssignExprToken) {
            this.unexpectedToken(access);
        }
        this.writeLineNumber(function);
        this.writeDynamicAccessPrepare(access, true);
        this.writePushParameters(function.getParameters(), new Memory[0]);
        this.writeSysStaticCall(ObjectInvokeHelper.class, "invokeMethod", Memory.class, Memory.class, String.class, String.class, Environment.class, TraceInfo.class, Memory[].class);
        if (!returnValue) {
            this.writePopAll(1);
        }
        if (statistic != null) {
            statistic.returnType = StackItem.Type.REFERENCE;
        }
        return null;
    }

    boolean writePushFastStaticMethod(CallExprToken function, boolean returnValue) {
        StaticAccessExprToken access = (StaticAccessExprToken)function.getName();
        CompileClass compileClass = this.compiler.getEnvironment().scope.findCompileClass(access.getClazz().getWord());
        if (compileClass == null) {
            return false;
        }
        ClassEntity classEntity = this.compiler.getEnvironment().fetchClass(compileClass.getNativeClass());
        MethodEntity methodEntity = classEntity.findMethod(access.getField().getWord().toLowerCase());
        if (methodEntity != null && methodEntity.getNativeMethod() != null && methodEntity.getNativeMethod().isAnnotationPresent(Runtime.FastMethod.class)) {
            int cnt = methodEntity.getRequiredParamCount();
            if (cnt > function.getParameters().size()) {
                this.writeWarning(function, Messages.ERR_EXPECT_EXACTLY_PARAMS.fetch(new Object[]{methodEntity.getClazzName() + "::" + methodEntity.getName(), cnt, function.getParameters().size()}));
                if (returnValue) {
                    this.writePushNull();
                }
                return true;
            }
            ArrayList<Memory> additional = new ArrayList<Memory>();
            for (ParameterEntity param : methodEntity.getParameters()) {
                if (param.getDefaultValue() != null) {
                    additional.add(param.getDefaultValue());
                    continue;
                }
                if (additional.isEmpty()) continue;
                throw new IllegalStateException("Arguments with default values must be located at the end");
            }
            this.writePushEnv();
            this.writePushParameters(function.getParameters(), additional.toArray(new Memory[0]));
            this.writeSysStaticCall(compileClass.getNativeClass(), methodEntity.getName(), Memory.class, Environment.class, Memory[].class);
            if (!returnValue) {
                this.writePopAll(1);
            }
            return true;
        }
        return false;
    }

    Memory writePushStaticMethod(CallExprToken function, boolean returnValue, boolean writeOpcode, PushCallStatistic statistic) {
        StaticAccessExprToken access = (StaticAccessExprToken)function.getName();
        if (!writeOpcode) {
            return null;
        }
        this.writeLineNumber(function);
        if (this.writePushFastStaticMethod(function, returnValue)) {
            return null;
        }
        this.writePushEnv();
        this.writePushTraceInfo(function.getName());
        String methodName = null;
        ValueExprToken clazz = access.getClazz();
        if ((clazz instanceof NameToken || clazz instanceof SelfExprToken && !((ClassEntity)this.method.clazz.entity).isTrait()) && access.getField() instanceof NameToken) {
            String className = clazz instanceof SelfExprToken ? this.getMacros(clazz).toString() : ((NameToken)clazz).getName();
            this.writePushString(className.toLowerCase());
            methodName = ((NameToken)access.getField()).getName();
            this.writePushString(methodName.toLowerCase());
            this.writePushString(className);
            this.writePushString(methodName);
            this.writePushParameters(function.getParameters(), new Memory[0]);
            if (this.method.clazz.statement.isTrait()) {
                this.writePushConstNull();
                this.writePushConstInt(0);
            } else {
                int cacheIndex = this.method.clazz.getAndIncCallMethCount();
                this.writeGetStatic("$CALL_METH_CACHE", MethodCallCache.class);
                this.writePushConstInt(cacheIndex);
            }
            this.writeSysStaticCall(InvokeHelper.class, "callStatic", Memory.class, Environment.class, TraceInfo.class, String.class, String.class, String.class, String.class, Memory[].class, MethodCallCache.class, Integer.TYPE);
        } else {
            if (clazz instanceof NameToken) {
                this.writePushString(((NameToken)clazz).getName());
                this.writePushDupLowerCase();
            } else if (clazz instanceof SelfExprToken) {
                this.writePushSelf(true);
            } else if (clazz instanceof StaticExprToken) {
                this.writePushStatic();
                this.writePushDupLowerCase();
            } else {
                this.writePush(clazz, true, false);
                this.writePopString();
                this.writePushDupLowerCase();
            }
            if (access.getField() != null) {
                ValueExprToken field = access.getField();
                if (field instanceof NameToken) {
                    this.writePushString(((NameToken)field).getName());
                    this.writePushString(((NameToken)field).getName().toLowerCase());
                } else if (field instanceof ClassExprToken) {
                    this.unexpectedToken(field);
                } else {
                    this.writePush(access.getField(), true, false);
                    this.writePopString();
                    this.writePushDupLowerCase();
                }
            } else {
                this.writeExpression(access.getFieldExpr(), true, false);
                this.writePopString();
                this.writePushDupLowerCase();
            }
            this.writePushParameters(function.getParameters(), new Memory[0]);
            if (clazz instanceof StaticExprToken || this.method.clazz.statement.isTrait() || clazz instanceof VariableExprToken) {
                this.writePushConstNull();
                this.writePushConstInt(0);
            } else {
                int cacheIndex = this.method.clazz.getAndIncCallMethCount();
                this.writeGetStatic("$CALL_METH_CACHE", MethodCallCache.class);
                this.writePushConstInt(cacheIndex);
            }
            this.writeSysStaticCall(InvokeHelper.class, "callStaticDynamic", Memory.class, Environment.class, TraceInfo.class, String.class, String.class, String.class, String.class, Memory[].class, MethodCallCache.class, Integer.TYPE);
        }
        if (statistic != null) {
            statistic.returnType = StackItem.Type.REFERENCE;
        }
        return null;
    }

    Memory writePushCall(CallExprToken function, boolean returnValue, boolean writeOpcode, PushCallStatistic statistic) {
        Token name = function.getName();
        if (name instanceof NameToken) {
            String realName = ((NameToken)name).getName();
            CompileFunction compileFunction = this.compiler.getScope().findCompileFunction(realName);
            if (compileFunction == null && name instanceof FulledNameToken && this.compiler.getEnvironment().fetchFunction(realName) == null && this.compiler.findFunction(realName) == null) {
                String tryName = ((FulledNameToken)name).getLastName().getName();
                compileFunction = this.compiler.getScope().findCompileFunction(tryName);
            }
            if (compileFunction != null) {
                return this.writePushCompileFunction(function, compileFunction, returnValue, writeOpcode, statistic);
            }
            if (!writeOpcode) {
                return null;
            }
            ((MethodEntity)this.method.entity).setImmutable(false);
            int index = this.method.clazz.getAndIncCallFuncCount();
            this.writePushEnv();
            this.writePushTraceInfo(function);
            this.writePushString(realName.toLowerCase());
            this.writePushString(realName);
            this.writePushParameters(function.getParameters(), new Memory[0]);
            this.writeGetStatic("$CALL_FUNC_CACHE", FunctionCallCache.class);
            this.writePushConstInt(index);
            this.writeSysStaticCall(InvokeHelper.class, "call", Memory.class, Environment.class, TraceInfo.class, String.class, String.class, Memory[].class, FunctionCallCache.class, Integer.TYPE);
            if (!returnValue) {
                this.writePopAll(1);
            }
        } else {
            if (name instanceof StaticAccessExprToken) {
                ((MethodEntity)this.method.entity).setImmutable(false);
                if (((StaticAccessExprToken)name).isAsParent()) {
                    return this.writePushParentDynamicMethod(function, returnValue, writeOpcode, statistic);
                }
                return this.writePushStaticMethod(function, returnValue, writeOpcode, statistic);
            }
            if (name instanceof DynamicAccessExprToken) {
                ((MethodEntity)this.method.entity).setImmutable(false);
                return this.writePushDynamicMethod(function, returnValue, writeOpcode, statistic);
            }
            if (!writeOpcode) {
                return null;
            }
            ((MethodEntity)this.method.entity).setImmutable(false);
            this.writeLineNumber(function);
            this.writePush((ValueExprToken)function.getName(), true, false);
            this.writePopBoxing();
            this.writePushParameters(function.getParameters(), new Memory[0]);
            this.writePushEnv();
            this.writePushTraceInfo(function);
            this.writeSysStaticCall(InvokeHelper.class, "callAny", Memory.class, Memory.class, Memory[].class, Environment.class, TraceInfo.class);
            if (!returnValue) {
                this.writePopAll(1);
            }
        }
        return null;
    }

    public void writeDefineVariables(Collection<VariableExprToken> values) {
        for (VariableExprToken value : values) {
            this.writeDefineVariable(value);
        }
    }

    public void writeUndefineVariables(Collection<VariableExprToken> values) {
        LabelNode end = new LabelNode();
        for (VariableExprToken value : values) {
            this.writeUndefineVariable(value, end);
        }
    }

    public void writeDefineGlobalVar(String name) {
        this.writePushEnv();
        this.writePushConstString(name);
        this.writeSysDynamicCall(Environment.class, "getOrCreateGlobal", Memory.class, String.class);
        this.makeVarStore(this.method.getLocalVariable(name));
        this.stackPop();
    }

    public void writePushThis() {
        if (this.method.clazz.isClosure() || this.method.getGeneratorEntity() != null) {
            this.writeVarLoad("~this");
            this.writeGetDynamic("self", Memory.class);
        } else {
            if (this.method.getLocalVariable("this") == null) {
                if (!this.methodStatement.isStatic()) {
                    LabelNode label = this.writeLabel(this.node);
                    LocalVariable local = this.method.addLocalVariable("this", label, Memory.class);
                    this.writeDefineThis(local);
                } else {
                    this.writePushNull();
                    return;
                }
            }
            this.writeVarLoad("this");
        }
    }

    protected void writeDefineThis(LocalVariable variable) {
        if (this.method.clazz.isClosure() || this.method.getGeneratorEntity() != null) {
            this.writeVarLoad("~this");
            this.writeGetDynamic("self", Memory.class);
            this.makeVarStore(variable);
            this.stackPop();
        } else {
            LabelNode endLabel = new LabelNode();
            LabelNode elseLabel = new LabelNode();
            if (this.methodStatement.isStatic()) {
                this.writePushMemory(Memory.UNDEFINED);
                this.writeVarStore(variable, false, false);
            } else {
                this.writeVarLoad("~this");
                this.writeSysDynamicCall(IObject.class, "isMock", Boolean.TYPE, new Class[0]);
                this.code.add((AbstractInsnNode)new JumpInsnNode(153, elseLabel));
                this.stackPop();
                if (variable.isReference()) {
                    this.writePushMemory(Memory.UNDEFINED);
                    this.writeSysStaticCall(ReferenceMemory.class, "valueOf", Memory.class, Memory.class);
                } else {
                    this.writePushMemory(Memory.UNDEFINED);
                }
                this.writeVarStore(variable, false, false);
                this.code.add((AbstractInsnNode)new JumpInsnNode(167, endLabel));
                this.code.add((AbstractInsnNode)elseLabel);
                this.writeVarLoad("~this");
                this.writeSysStaticCall(ObjectMemory.class, "valueOf", Memory.class, IObject.class);
                this.makeVarStore(variable);
                this.stackPop();
                this.code.add((AbstractInsnNode)endLabel);
            }
        }
        variable.pushLevel();
        variable.setValue(null);
        variable.setImmutable(false);
        variable.setReference(true);
    }

    protected void writeDefineVariable(VariableExprToken value) {
        if (this.methodStatement.isUnusedVariable(value)) {
            return;
        }
        LocalVariable variable = this.method.getLocalVariable(value.getName());
        if (variable == null) {
            LabelNode label = this.writeLabel(this.node, value.getMeta().getStartLine());
            variable = this.method.addLocalVariable(value.getName(), label, Memory.class);
            if (this.methodStatement.isReference(value) || this.compiler.getScope().superGlobals.contains(value.getName())) {
                variable.setReference(true);
            } else {
                variable.setReference(false);
            }
            if (variable.name.equals("this") && this.method.getLocalVariable("~this") != null) {
                this.writeDefineThis(variable);
            } else if (this.compiler.getScope().superGlobals.contains(value.getName())) {
                this.writeDefineGlobalVar(value.getName());
            } else if (this.methodStatement.isDynamicLocal()) {
                this.writePushLocal();
                this.writePushConstString(value.getName());
                this.writeSysDynamicCall(Memory.class, "refOfIndex", Memory.class, String.class);
                this.makeVarStore(variable);
                this.stackPop();
                variable.pushLevel();
                variable.setValue(null);
                variable.setReference(true);
            } else {
                if (variable.isReference()) {
                    this.writePushNewObject(ReferenceMemory.class);
                } else {
                    this.writePushNull();
                }
                this.makeVarStore(variable);
                this.stackPop();
                variable.pushLevel();
            }
        } else {
            variable.pushLevel();
        }
    }

    protected void writeUndefineVariable(VariableExprToken value, LabelNode end) {
        LocalVariable variable = this.method.getLocalVariable(value.getName());
        if (variable != null) {
            variable.popLevel();
        }
    }

    public void writePushVariable(VariableExprToken value) {
        LocalVariable variable = this.method.getLocalVariable(value.getName());
        if (variable == null || variable.getClazz() == null) {
            this.writePushNull();
        } else {
            this.writeVarLoad(variable);
        }
    }

    public Memory tryWritePushVariable(VariableExprToken value, boolean heavyObjects) {
        if (this.methodStatement.isUnstableVariable(value)) {
            return null;
        }
        if (this.compiler.getScope().superGlobals.contains(value.getName())) {
            return null;
        }
        LocalVariable variable = this.method.getLocalVariable(value.getName());
        if (variable == null || variable.getClazz() == null || this.methodStatement.isUnusedVariable(value)) {
            return Memory.NULL;
        }
        if (this.methodStatement.variable(value).isPassed()) {
            return null;
        }
        Memory mem = variable.getValue();
        if (mem != null) {
            if (!heavyObjects && (mem.isArray() || mem.toString().length() > 100)) {
                return null;
            }
            return mem;
        }
        return null;
    }

    public Memory writePushArray(ArrayExprToken array, boolean returnMemory, boolean writeOpcode) {
        if (array.getParameters().isEmpty()) {
            if (returnMemory) {
                return new ArrayMemory();
            }
            if (writeOpcode) {
                this.writeSysStaticCall(ArrayMemory.class, "valueOf", Memory.class, new Class[0]);
            }
        } else {
            ArrayMemory ret;
            ArrayMemory arrayMemory = ret = returnMemory ? new ArrayMemory() : null;
            if (ret == null) {
                boolean map = false;
                for (ExprStmtToken token : array.getParameters()) {
                    for (Token sub : token.getTokens()) {
                        if (!(sub instanceof KeyValueExprToken)) continue;
                        map = true;
                        break;
                    }
                    if (!map) continue;
                    break;
                }
                this.writePushConstInt(array.getParameters().size());
                if (map) {
                    this.writeSysStaticCall(ArrayMemory.class, "createHashed", ArrayMemory.class, Integer.TYPE);
                } else {
                    this.writeSysStaticCall(ArrayMemory.class, "createListed", ArrayMemory.class, Integer.TYPE);
                }
            }
            for (ExprStmtToken param : array.getParameters()) {
                Memory result;
                if (ret == null) {
                    this.writePushDup();
                }
                if ((result = this.writeExpression(param, true, true, ret == null)) != null) {
                    if (ret != null) {
                        ret.add(result);
                        continue;
                    }
                    this.writePushMemory(result);
                } else {
                    if (!writeOpcode) {
                        return null;
                    }
                    ret = null;
                }
                if (result == null && returnMemory) {
                    return this.writePushArray(array, false, writeOpcode);
                }
                this.writePopBoxing();
                this.writePopImmutable();
                this.writeSysDynamicCall(ArrayMemory.class, "add", ReferenceMemory.class, Memory.class);
                this.writePopAll(1);
            }
            if (ret != null) {
                return ret;
            }
        }
        this.setStackPeekAsImmutable();
        return null;
    }

    public int writePushTraceInfo(Token token) {
        return this.writePushTraceInfo(token.getMeta().getStartLine(), token.getMeta().getStartPosition());
    }

    void writePushGetFromArray(int index, Class clazz) {
        this.writePushSmallInt(index);
        this.code.add((AbstractInsnNode)new InsnNode(50));
        this.stackPop();
        this.stackPop();
        this.stackPush(null, StackItem.Type.valueOf(clazz));
    }

    void writePushGetArrayLength() {
        this.code.add((AbstractInsnNode)new InsnNode(190));
        this.stackPop();
        this.stackPush(null, StackItem.Type.INT);
    }

    int createTraceInfo(Token token) {
        return this.method.clazz.addTraceInfo(token);
    }

    int writePushTraceInfo(int line, int position) {
        int index = this.method.clazz.addTraceInfo(line, position);
        this.writePushTraceInfo(index);
        return index;
    }

    void writePushTraceInfo(int traceIndex) {
        this.writeGetStatic("$TRC", TraceInfo[].class);
        this.writePushGetFromArray(traceIndex, TraceInfo.class);
    }

    void writePushCreateTraceInfo(int line, int position) {
        this.writeGetStatic("$FN", String.class);
        this.writePushMemory(LongMemory.valueOf((int)line));
        this.writePushMemory(LongMemory.valueOf((int)position));
        this.writeSysStaticCall(TraceInfo.class, "valueOf", TraceInfo.class, String.class, Long.TYPE, Long.TYPE);
    }

    int writePushConstantMemory(Memory memory) {
        int index = this.method.clazz.addMemoryConstant(memory);
        this.writeGetStatic("$MEM", Memory[].class);
        this.writePushGetFromArray(index, Memory.class);
        return index;
    }

    int writePushConstantMemoryArray(Collection<Memory> memories) {
        int index = this.method.clazz.addMemoryArray(memories);
        this.writeGetStatic("$AMEM", Memory[][].class);
        this.writePushGetFromArray(index, Memory[].class);
        return index;
    }

    Memory tryWritePushMacro(MacroToken macro, boolean writeOpcode) {
        if (macro instanceof LineMacroToken) {
            return LongMemory.valueOf((int)(macro.getMeta().getStartLine() + 1));
        }
        if (macro instanceof FileMacroToken) {
            return new StringMemory(this.compiler.getSourceFile());
        }
        if (macro instanceof DirMacroToken) {
            String parent;
            String sourceFile = this.compiler.getSourceFile();
            if (sourceFile.startsWith((parent = new File(sourceFile).getParent()) + "//") && parent.endsWith(":")) {
                parent = parent + "//";
            }
            return new StringMemory(parent);
        }
        if (macro instanceof FunctionMacroToken) {
            if (this.method.clazz == null) {
                return Memory.CONST_EMPTY_STRING;
            }
            if (this.method.clazz.isClosure()) {
                return new StringMemory("{closure}");
            }
            if (StringUtils.isEmpty((String)this.method.clazz.getFunctionName())) {
                return this.method.clazz.isSystem() ? Memory.CONST_EMPTY_STRING : (this.method.getRealName() == null ? Memory.CONST_EMPTY_STRING : new StringMemory(this.method.getRealName()));
            }
            return this.method.clazz.getFunctionName() == null ? Memory.CONST_EMPTY_STRING : new StringMemory(this.method.clazz.getFunctionName());
        }
        if (macro instanceof MethodMacroToken) {
            if (this.method.clazz == null) {
                return Memory.CONST_EMPTY_STRING;
            }
            if (this.method.clazz.isClosure()) {
                return new StringMemory("{closure}");
            }
            if (this.method.clazz.isSystem()) {
                return this.method.clazz.getFunctionName() != null ? new StringMemory(this.method.clazz.getFunctionName()) : Memory.NULL;
            }
            return new StringMemory(((ClassEntity)this.method.clazz.entity).getName() + (this.method.getRealName() == null ? "" : "::" + this.method.getRealName()));
        }
        if (macro instanceof ClassMacroToken) {
            if (((ClassEntity)this.method.clazz.entity).isTrait()) {
                if (writeOpcode) {
                    this.writePushEnv();
                    this.writeSysDynamicCall(Environment.class, "__getMacroClass", Memory.class, new Class[0]);
                }
                return null;
            }
            if (this.method.clazz.getClassContext() != null) {
                return new StringMemory(this.method.clazz.getClassContext().getFulledName());
            }
            return new StringMemory(this.method.clazz.isSystem() ? "" : ((ClassEntity)this.method.clazz.entity).getName());
        }
        if (macro instanceof NamespaceMacroToken) {
            return new StringMemory(this.compiler.getNamespace() == null || this.compiler.getNamespace().getName() == null ? "" : this.compiler.getNamespace().getName().getName());
        }
        if (macro instanceof TraitMacroToken) {
            if (((ClassEntity)this.method.clazz.entity).isTrait()) {
                return new StringMemory(((ClassEntity)this.method.clazz.entity).getName());
            }
            return Memory.CONST_EMPTY_STRING;
        }
        throw new IllegalArgumentException("Unsupported macro value: " + macro.getWord());
    }

    Memory writePushName(NameToken token, boolean returnMemory, boolean writeOpcode) {
        CompileConstant constant = this.compiler.getScope().findCompileConstant(token.getName());
        if (constant != null) {
            if (returnMemory) {
                return constant.value;
            }
            if (writeOpcode) {
                this.writePushMemory(constant.value);
            }
        } else {
            ConstantEntity constantEntity = this.compiler.findConstant(token.getName());
            if (constantEntity != null) {
                if (returnMemory) {
                    return constantEntity.getValue();
                }
                if (writeOpcode) {
                    this.writePushMemory(constantEntity.getValue());
                    this.setStackPeekAsImmutable();
                }
            } else {
                if (!writeOpcode) {
                    return null;
                }
                this.writePushEnv();
                this.writePushString(token.getName());
                this.writePushString(token.getName().toLowerCase());
                this.writePushTraceInfo(token);
                this.writeSysDynamicCall(Environment.class, "__getConstant", Memory.class, String.class, String.class, TraceInfo.class);
                this.setStackPeekAsImmutable();
            }
        }
        return null;
    }

    Memory tryWritePushReference(StackItem item, boolean writeOpcode, boolean toStack, boolean heavyObjects) {
        if (item.getToken() instanceof VariableExprToken) {
            this.writePushVariable((VariableExprToken)item.getToken());
            return null;
        }
        return this.tryWritePush(item, writeOpcode, toStack, heavyObjects);
    }

    Memory tryWritePush(StackItem item, boolean writeOpcode, boolean toStack, boolean heavyObjects) {
        if (item.getToken() != null) {
            return this.tryWritePush(item.getToken(), true, writeOpcode, heavyObjects);
        }
        if (item.getMemory() != null) {
            return item.getMemory();
        }
        if (toStack) {
            this.stackPush(null, item.type);
        }
        return null;
    }

    StackItem.Type tryGetType(StackItem item) {
        if (item.getToken() != null) {
            return this.tryGetType(item.getToken());
        }
        if (item.getMemory() != null) {
            return StackItem.Type.valueOf(item.getMemory().type);
        }
        return item.type;
    }

    public boolean tryIsImmutable(StackItem item) {
        if (item.getToken() != null) {
            return this.tryIsImmutable(item.getToken());
        }
        if (item.getMemory() != null) {
            return true;
        }
        return item.type.isConstant();
    }

    public Memory tryWritePush(StackItem item) {
        return this.tryWritePush(item, true, true, true);
    }

    public void writePush(StackItem item) {
        this.writePush(item, true, false);
    }

    public void writePush(StackItem item, boolean tryGetMemory, boolean heavyObjects) {
        if (tryGetMemory) {
            Memory memory = this.tryWritePushReference(item, true, true, heavyObjects);
            if (memory != null) {
                this.writePushMemory(memory);
            }
        } else {
            this.tryWritePushReference(item, true, true, heavyObjects);
        }
    }

    public void writePush(StackItem item, StackItem.Type castType) {
        Memory memory = this.tryWritePush(item);
        if (memory != null) {
            switch (castType) {
                case DOUBLE: {
                    this.writePushConstDouble(memory.toDouble());
                    return;
                }
                case FLOAT: {
                    this.writePushConstFloat((float)memory.toDouble());
                    return;
                }
                case LONG: {
                    this.writePushConstLong(memory.toLong());
                    return;
                }
                case INT: {
                    this.writePushConstInt((int)memory.toLong());
                    return;
                }
                case SHORT: {
                    this.writePushConstInt((short)memory.toLong());
                    return;
                }
                case BYTE: {
                    this.writePushConstByte((byte)memory.toLong());
                    return;
                }
                case BOOL: {
                    this.writePushConstBoolean(memory.toBoolean());
                    return;
                }
                case STRING: {
                    this.writePushConstString(memory.toString());
                    return;
                }
            }
            this.writePushMemory(memory);
        }
        this.writePop(castType.toClass(), true, true);
    }

    boolean tryIsImmutable(ValueExprToken value) {
        if (value instanceof IntegerExprToken) {
            return true;
        }
        if (value instanceof DoubleExprToken) {
            return true;
        }
        if (value instanceof StringExprToken) {
            return true;
        }
        if (value instanceof LineMacroToken) {
            return true;
        }
        if (value instanceof MacroToken) {
            return true;
        }
        if (value instanceof ArrayExprToken) {
            return true;
        }
        if (value instanceof StringBuilderExprToken) {
            return true;
        }
        if (value instanceof NameToken) {
            return true;
        }
        if (value instanceof CallExprToken) {
            PushCallStatistic statistic = new PushCallStatistic();
            this.writePushCall((CallExprToken)value, true, false, statistic);
            return statistic.returnType.isConstant();
        }
        return false;
    }

    StackItem.Type tryGetType(ValueExprToken value) {
        if (value instanceof IntegerExprToken) {
            return StackItem.Type.LONG;
        }
        if (value instanceof DoubleExprToken) {
            return StackItem.Type.DOUBLE;
        }
        if (value instanceof StringExprToken) {
            return StackItem.Type.STRING;
        }
        if (value instanceof LineMacroToken) {
            return StackItem.Type.LONG;
        }
        if (value instanceof MacroToken) {
            return StackItem.Type.STRING;
        }
        if (value instanceof ArrayExprToken) {
            return StackItem.Type.ARRAY;
        }
        if (value instanceof StringBuilderExprToken) {
            return StackItem.Type.STRING;
        }
        if (value instanceof CallExprToken) {
            PushCallStatistic statistic = new PushCallStatistic();
            this.writePushCall((CallExprToken)value, true, false, statistic);
            return statistic.returnType;
        }
        if (value instanceof NameToken) {
            Memory tmpMemory = this.writePushName((NameToken)value, true, false);
            return tmpMemory == null ? StackItem.Type.REFERENCE : StackItem.Type.valueOf(tmpMemory.type);
        }
        return StackItem.Type.REFERENCE;
    }

    Memory tryWritePush(ValueExprToken value, boolean returnValue, boolean writeOpcode, boolean heavyObjects) {
        BaseStatementCompiler<?> compiler;
        if (writeOpcode && (compiler = this.getCompiler(value.getClass())) != null) {
            if (!(compiler instanceof BaseExprCompiler)) {
                throw new IllegalStateException("Compiler must be extended by " + BaseExprCompiler.class.getName());
            }
            ((BaseExprCompiler)compiler).write(value, returnValue);
            return null;
        }
        if (value instanceof NameToken) {
            return this.writePushName((NameToken)value, returnValue, writeOpcode);
        }
        if (value instanceof ArrayExprToken) {
            return this.writePushArray((ArrayExprToken)value, returnValue, writeOpcode);
        }
        if (value instanceof CallExprToken) {
            return this.writePushCall((CallExprToken)value, returnValue, writeOpcode, null);
        }
        if (value instanceof MacroToken) {
            return this.tryWritePushMacro((MacroToken)value, writeOpcode);
        }
        if (value instanceof VariableExprToken && writeOpcode) {
            this.writePushVariable((VariableExprToken)value);
        }
        return null;
    }

    public void writePush(ValueExprToken value, boolean returnValue, boolean heavyObjects) {
        if (value instanceof VariableExprToken) {
            this.writePushVariable((VariableExprToken)value);
            return;
        }
        Memory memory = this.tryWritePush(value, returnValue, true, heavyObjects);
        if (memory != null) {
            this.writePushMemory(memory);
        }
    }

    boolean methodExists(Class clazz, String method, Class ... paramClasses) {
        try {
            clazz.getDeclaredMethod(method, paramClasses);
            return true;
        }
        catch (java.lang.NoSuchMethodException e) {
            return false;
        }
    }

    void writeSysCall(String internalClassName, int INVOKE_TYPE, String method, Class returnClazz, Class ... paramClasses) {
        Type[] args = new Type[paramClasses.length];
        if (INVOKE_TYPE == 182 || INVOKE_TYPE == 185) {
            this.stackPop();
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = Type.getType((Class)paramClasses[i]);
            this.stackPop();
        }
        this.code.add((AbstractInsnNode)new MethodInsnNode(INVOKE_TYPE, internalClassName, method, Type.getMethodDescriptor((Type)Type.getType((Class)returnClazz), (Type[])args), false));
        if (returnClazz != Void.TYPE) {
            this.stackPush(null, StackItem.Type.valueOf(returnClazz));
        }
    }

    void writeSysCall(Class clazz, int INVOKE_TYPE, String method, Class returnClazz, Class ... paramClasses) {
        String owner;
        if (INVOKE_TYPE != 183 && clazz != null && this.compiler.getScope().isDebugMode() && !this.methodExists(clazz, method, paramClasses)) {
            throw new NoSuchMethodException(clazz, method, paramClasses);
        }
        Type[] args = new Type[paramClasses.length];
        if (INVOKE_TYPE == 182 || INVOKE_TYPE == 185) {
            this.stackPop();
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = Type.getType((Class)paramClasses[i]);
            this.stackPop();
        }
        String string = owner = clazz == null ? this.method.clazz.node.name : Type.getInternalName((Class)clazz);
        if (clazz == null && ((ClassEntity)this.method.clazz.entity).isTrait()) {
            throw new CriticalException("[Compiler Error] Cannot use current classname in Trait");
        }
        this.code.add((AbstractInsnNode)new MethodInsnNode(INVOKE_TYPE, owner, method, Type.getMethodDescriptor((Type)Type.getType((Class)returnClazz), (Type[])args), clazz != null && clazz.isInterface()));
        if (returnClazz != Void.TYPE) {
            this.stackPush(null, StackItem.Type.valueOf(returnClazz));
        }
    }

    public void writeTickTrigger(Token token) {
        this.writeTickTrigger(token.toTraceInfo(this.getCompiler().getContext()));
    }

    public void writeTickTrigger(TraceInfo trace) {
        int line;
        if (this.compiler.getScope().isDebugMode() && this.method.getLocalVariable("~local") != null && this.method.registerTickTrigger(line = trace.getStartLine())) {
            this.writePushEnv();
            this.writePushTraceInfo(trace.getStartLine(), trace.getStartPosition());
            this.writePushLocal();
            this.writeSysDynamicCall(Environment.class, "__tick", Void.TYPE, TraceInfo.class, ArrayMemory.class);
        }
    }

    public void writeSysDynamicCall(Class clazz, String method, Class returnClazz, Class ... paramClasses) throws NoSuchMethodException {
        this.writeSysCall(clazz, clazz != null && clazz.isInterface() ? 185 : 182, method, returnClazz, paramClasses);
    }

    public void writeSysStaticCall(Class clazz, String method, Class returnClazz, Class ... paramClasses) throws NoSuchMethodException {
        this.writeSysCall(clazz, 184, method, returnClazz, paramClasses);
    }

    public void writePopImmutable() {
        if (!this.stackPeek().immutable) {
            this.writeSysDynamicCall(Memory.class, "toImmutable", Memory.class, new Class[0]);
            this.setStackPeekAsImmutable();
        }
    }

    public void writeVarStore(LocalVariable variable, boolean returned, boolean asImmutable) {
        this.writePopBoxing();
        if (asImmutable) {
            this.writePopImmutable();
        }
        if (returned) {
            this.writePushDup();
        }
        this.makeVarStore(variable);
        this.stackPop();
    }

    public void checkAssignableVar(VariableExprToken var) {
        if ((this.method.clazz.isClosure() || !this.method.clazz.isSystem()) && var.getName().equals("this")) {
            this.compiler.getEnvironment().error(var.toTraceInfo(this.compiler.getContext()), "Cannot re-assign $this", new Object[0]);
        }
    }

    public void writeVarAssign(LocalVariable variable, VariableExprToken token, boolean returned, boolean asImmutable) {
        if (token != null) {
            this.checkAssignableVar(token);
        }
        this.writePopBoxing(asImmutable);
        if (variable.isReference()) {
            this.writeVarLoad(variable);
            this.writeSysStaticCall(Memory.class, "assignRight", Memory.class, Memory.class, Memory.class);
            if (!returned) {
                this.writePopAll(1);
            }
        } else {
            if (returned) {
                this.writePushDup();
            }
            this.makeVarStore(variable);
            this.stackPop();
        }
    }

    public void writeVarStore(LocalVariable variable, boolean returned) {
        this.writeVarStore(variable, returned, false);
    }

    public void writeVarLoad(LocalVariable variable) {
        this.stackPush(Memory.Type.valueOf((Class)variable.getClazz()));
        this.makeVarLoad(variable);
    }

    public void writeVarLoad(String name) {
        LocalVariable local = this.method.getLocalVariable(name);
        if (local == null) {
            throw new IllegalArgumentException("Variable '" + name + "' is not registered");
        }
        this.writeVarLoad(local);
    }

    public void writePutStatic(Class clazz, String name, Class fieldClass) {
        this.code.add((AbstractInsnNode)new FieldInsnNode(179, Type.getInternalName((Class)clazz), name, Type.getDescriptor((Class)fieldClass)));
        this.stackPop();
    }

    public void writePutStatic(String name, Class fieldClass) {
        this.code.add((AbstractInsnNode)new FieldInsnNode(179, this.method.clazz.node.name, name, Type.getDescriptor((Class)fieldClass)));
        this.stackPop();
    }

    public void writePutDynamic(String name, Class fieldClass) {
        this.code.add((AbstractInsnNode)new FieldInsnNode(181, this.method.clazz.node.name, name, Type.getDescriptor((Class)fieldClass)));
        this.stackPop();
    }

    public void writeGetStatic(Class clazz, String name, Class fieldClass) {
        this.code.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName((Class)clazz), name, Type.getDescriptor((Class)fieldClass)));
        this.stackPush(null, StackItem.Type.valueOf(fieldClass));
        this.setStackPeekAsImmutable();
    }

    public void writeGetStatic(String name, Class fieldClass) {
        this.code.add((AbstractInsnNode)new FieldInsnNode(178, this.method.clazz.node.name, name, Type.getDescriptor((Class)fieldClass)));
        this.stackPush(null, StackItem.Type.valueOf(fieldClass));
        this.setStackPeekAsImmutable();
    }

    public void writeGetDynamic(String name, Class fieldClass) {
        this.stackPop();
        this.code.add((AbstractInsnNode)new FieldInsnNode(180, this.method.clazz.node.name, name, Type.getDescriptor((Class)fieldClass)));
        this.stackPush(null, StackItem.Type.valueOf(fieldClass));
        this.setStackPeekAsImmutable();
    }

    void writeGetEnum(Enum enumInstance) {
        this.writeGetStatic(enumInstance.getDeclaringClass(), enumInstance.name(), enumInstance.getDeclaringClass());
    }

    void writeVariableAssign(VariableExprToken variable, StackItem R, AssignExprToken operator, boolean returnValue) {
        LocalVariable local = this.method.getLocalVariable(variable.getName());
        this.checkAssignableVar(variable);
        Memory value = R.getMemory();
        this.writeLineNumber(variable);
        if (local.isReference()) {
            String name = "assign";
            if (operator.isAsReference()) {
                name = "assignRef";
            }
            if (!R.isKnown()) {
                this.stackPush(R);
                this.writePopBoxing();
                this.writePopImmutable();
                this.writePushVariable(variable);
                this.writeSysStaticCall(Memory.class, name + "Right", Memory.class, this.stackPeek().type.toClass(), Memory.class);
            } else {
                this.writePushVariable(variable);
                Memory tmp = this.tryWritePush(R);
                if (tmp != null) {
                    value = tmp;
                    this.writePushMemory(value);
                }
                this.writePopBoxing();
                this.writePopImmutable();
                this.writeSysDynamicCall(Memory.class, name, Memory.class, this.stackPeek().type.toClass());
            }
            if (!returnValue) {
                this.writePopAll(1);
            }
        } else {
            Memory result = this.tryWritePush(R);
            if (result != null) {
                this.writePushMemory(result);
                value = result;
            }
            this.writePopBoxing();
            this.writeVarStore(local, returnValue, true);
        }
        local.setValue(null);
    }

    void writeScalarOperator(StackItem L, StackItem.Type Lt, StackItem R, StackItem.Type Rt, OperatorExprToken operator, Class operatorResult, String operatorName) {
        boolean isInvert;
        boolean bl = isInvert = !R.isKnown();
        if (!R.isKnown() && !L.isKnown() && R.getLevel() > L.getLevel()) {
            isInvert = false;
        }
        if (operator instanceof ConcatExprToken) {
            if (isInvert) {
                this.stackPush(R);
                this.writePopString();
                this.writePush(L, StackItem.Type.STRING);
                this.writeSysStaticCall(OperatorUtils.class, "concatRight", String.class, String.class, String.class);
            } else {
                this.writePush(L, StackItem.Type.STRING);
                this.writePush(R, StackItem.Type.STRING);
                this.writeSysDynamicCall(String.class, "concat", String.class, String.class);
            }
            return;
        }
        if ((operator instanceof PlusExprToken || operator instanceof MinusExprToken || operator instanceof MulExprToken) && (!(operator instanceof MinusExprToken) || !isInvert) && Lt.isLikeNumber() && Rt.isLikeNumber()) {
            StackItem.Type cast = StackItem.Type.LONG;
            if (Lt.isLikeDouble() || Rt.isLikeDouble()) {
                cast = StackItem.Type.DOUBLE;
            }
            this.writePush(L, cast);
            this.writePush(R, cast);
            this.code.add((AbstractInsnNode)new InsnNode(CompilerUtils.getOperatorOpcode(operator, cast)));
            this.stackPop();
            this.stackPop();
            this.stackPush(null, cast);
            return;
        }
        if (isInvert) {
            this.stackPush(R);
            this.writePopBoxing();
            this.writePush(L);
            if (operator.isSide()) {
                operatorName = operatorName + "Right";
            }
            this.writeSysDynamicCall(Memory.class, operatorName, operatorResult, this.stackPeek().type.toClass());
        } else {
            this.writePush(L);
            this.writePopBoxing();
            this.writePush(R);
            this.writeSysDynamicCall(Memory.class, operatorName, operatorResult, this.stackPeek().type.toClass());
        }
    }

    public void writePop(Class clazz, boolean boxing, boolean asImmutable) {
        if (clazz == String.class) {
            this.writePopString();
        } else if (clazz == Character.TYPE) {
            this.writePopChar();
        } else if (clazz == Boolean.TYPE) {
            this.writePopBoolean();
        } else if (clazz == Memory.class) {
            if (boxing) {
                this.writePopBoxing(asImmutable);
            }
        } else if (clazz == Double.TYPE) {
            this.writePopDouble();
        } else if (clazz == Float.TYPE) {
            this.writePopFloat();
        } else if (clazz == Long.TYPE) {
            this.writePopLong();
        } else if (clazz == Integer.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE) {
            this.writePopInteger();
        } else {
            throw new IllegalArgumentException("Cannot pop this class: " + clazz.getName());
        }
    }

    public void writePopInteger() {
        this.writePopLong();
        this.code.add((AbstractInsnNode)new InsnNode(136));
        this.stackPop();
        this.stackPush(null, StackItem.Type.INT);
    }

    public void writePopFloat() {
        this.writePopDouble();
        this.code.add((AbstractInsnNode)new InsnNode(144));
        this.stackPop();
        this.stackPush(null, StackItem.Type.FLOAT);
    }

    public void writePopLong() {
        switch (this.stackPeek().type) {
            case LONG: {
                break;
            }
            case FLOAT: {
                this.code.add((AbstractInsnNode)new InsnNode(137));
                this.stackPop();
                this.stackPush(Memory.Type.INT);
                break;
            }
            case BOOL: 
            case SHORT: 
            case BYTE: 
            case INT: 
            case CHAR: {
                this.code.add((AbstractInsnNode)new InsnNode(133));
                this.stackPop();
                this.stackPush(Memory.Type.INT);
                break;
            }
            case DOUBLE: {
                this.code.add((AbstractInsnNode)new InsnNode(143));
                this.stackPop();
                this.stackPush(Memory.Type.INT);
                break;
            }
            case STRING: {
                this.writeSysStaticCall(StringMemory.class, "toNumeric", Memory.class, String.class);
                this.writeSysDynamicCall(Memory.class, "toLong", Long.TYPE, new Class[0]);
                break;
            }
            default: {
                this.writeSysDynamicCall(Memory.class, "toLong", Long.TYPE, new Class[0]);
            }
        }
    }

    public void writePopDouble() {
        switch (this.stackPeek().type) {
            case DOUBLE: {
                break;
            }
            case BOOL: 
            case SHORT: 
            case BYTE: 
            case INT: 
            case CHAR: {
                this.code.add((AbstractInsnNode)new InsnNode(135));
                this.stackPop();
                this.stackPush(Memory.Type.DOUBLE);
                break;
            }
            case LONG: {
                this.code.add((AbstractInsnNode)new InsnNode(138));
                this.stackPop();
                this.stackPush(Memory.Type.DOUBLE);
                break;
            }
            case STRING: {
                this.writeSysStaticCall(StringMemory.class, "toNumeric", Memory.class, String.class);
                this.writeSysDynamicCall(Memory.class, "toDouble", Double.TYPE, new Class[0]);
                break;
            }
            default: {
                this.writeSysDynamicCall(Memory.class, "toDouble", Double.TYPE, new Class[0]);
            }
        }
    }

    public void writePopString() {
        StackItem.Type peek = this.stackPeek().type;
        switch (peek) {
            case STRING: {
                break;
            }
            default: {
                if (peek.isConstant()) {
                    if (peek == StackItem.Type.BOOL) {
                        this.writeSysStaticCall(Memory.class, "boolToString", String.class, peek.toClass());
                        break;
                    }
                    this.writeSysStaticCall(String.class, "valueOf", String.class, peek.toClass());
                    break;
                }
                this.writeSysDynamicCall(Memory.class, "toString", String.class, new Class[0]);
            }
        }
    }

    public void writePopChar() {
        StackItem.Type peek = this.stackPeek().type;
        if (peek == StackItem.Type.CHAR) {
            return;
        }
        if (peek.isConstant()) {
            this.writeSysStaticCall(OperatorUtils.class, "toChar", Character.TYPE, peek.toClass());
        } else {
            this.writePopBoxing();
            this.writeSysDynamicCall(Memory.class, "toChar", Character.TYPE, new Class[0]);
        }
    }

    public void writePopBooleanAsObject() {
        StackItem.Type peek = this.stackPeek().type;
        this.writeSysStaticCall(TrueMemory.class, "valueOf", Memory.class, peek.toClass());
        this.setStackPeekAsImmutable();
    }

    public void writePopBoolean() {
        StackItem.Type peek = this.stackPeek().type;
        switch (peek) {
            case BOOL: {
                break;
            }
            case SHORT: 
            case BYTE: 
            case LONG: 
            case INT: 
            case CHAR: {
                this.writeSysStaticCall(OperatorUtils.class, "toBoolean", Boolean.TYPE, peek.toClass());
                break;
            }
            case DOUBLE: {
                this.writeSysStaticCall(OperatorUtils.class, "toBoolean", Boolean.TYPE, Double.TYPE);
                break;
            }
            case STRING: {
                this.writeSysStaticCall(OperatorUtils.class, "toBoolean", Boolean.TYPE, String.class);
                break;
            }
            case REFERENCE: {
                this.writeSysDynamicCall(Memory.class, "toBoolean", Boolean.TYPE, new Class[0]);
            }
        }
    }

    public void writeDynamicAccessInfo(DynamicAccessExprToken dynamic, boolean addLowerName) {
        if (dynamic.getField() != null) {
            if (dynamic.getField() instanceof NameToken) {
                String name = ((NameToken)dynamic.getField()).getName();
                this.writePushString(name);
                if (addLowerName) {
                    this.writePushString(name.toLowerCase());
                }
            } else {
                this.writePush(dynamic.getField(), true, false);
                this.writePopString();
                if (addLowerName) {
                    this.writePushDupLowerCase();
                }
            }
        } else {
            this.writeExpression(dynamic.getFieldExpr(), true, false);
            this.writePopString();
            if (addLowerName) {
                this.writePushDupLowerCase();
            }
        }
        this.writePushEnv();
        this.writePushTraceInfo(dynamic);
    }

    public void writeDynamicAccessPrepare(DynamicAccessExprToken dynamic, boolean addLowerName) {
        if (this.stackEmpty(true)) {
            this.unexpectedToken(dynamic);
        }
        StackItem o = this.stackPop();
        this.writePush(o);
        if (this.stackPeek().isConstant()) {
            this.unexpectedToken(dynamic);
        }
        this.writePopBoxing();
        if (dynamic instanceof DynamicAccessAssignExprToken && ((DynamicAccessAssignExprToken)dynamic).getValue() != null) {
            this.writeExpression(((DynamicAccessAssignExprToken)dynamic).getValue(), true, false);
            this.writePopBoxing(true);
        }
        this.writeDynamicAccessInfo(dynamic, addLowerName);
    }

    void writeArrayGet(ArrayGetExprToken operator, boolean returnValue) {
        StackItem o = this.stackPeek();
        ValueExprToken L = null;
        if (o.getToken() != null) {
            this.stackPop();
            L = o.getToken();
            this.writePush(L, true, false);
            this.writePopBoxing();
        }
        String methodName = operator instanceof ArrayGetRefExprToken ? "refOfIndex" : "valueOfIndex";
        boolean isShortcut = operator instanceof ArrayGetRefExprToken && ((ArrayGetRefExprToken)operator).isShortcut();
        int i = 0;
        int size = operator.getParameters().size();
        int traceIndex = this.createTraceInfo(operator);
        for (ExprStmtToken param : operator.getParameters()) {
            this.writePushTraceInfo(traceIndex);
            this.writeExpression(param, true, false);
            if (operator instanceof ArrayGetUnsetExprToken && i == size - 1) {
                this.writePopBoxing();
                this.writeSysDynamicCall(Memory.class, "unsetOfIndex", Void.TYPE, TraceInfo.class, this.stackPeek().type.toClass());
                if (!returnValue) continue;
                this.writePushNull();
                continue;
            }
            if (operator instanceof ArrayGetIssetExprToken && i == size - 1) {
                this.writePopBoxing();
                this.writeSysDynamicCall(Memory.class, "issetOfIndex", Memory.class, TraceInfo.class, this.stackPeek().type.toClass());
                continue;
            }
            if (operator instanceof ArrayGetEmptyExprToken && i == size - 1) {
                this.writePopBoxing();
                this.writeSysDynamicCall(Memory.class, "emptyOfIndex", Memory.class, TraceInfo.class, this.stackPeek().type.toClass());
                continue;
            }
            this.writeSysDynamicCall(Memory.class, methodName, Memory.class, TraceInfo.class, this.stackPeek().type.toClass());
            ++i;
        }
    }

    Memory writeUnaryOperator(OperatorExprToken operator, boolean returnValue, boolean writeOpcode) {
        if (this.stackEmpty(true)) {
            this.unexpectedToken(operator);
        }
        StackItem o = this.stackPop();
        ValueExprToken L = o.getToken();
        Memory mem = this.tryWritePush(o, false, false, true);
        StackItem.Type type = this.tryGetType(o);
        if (mem != null) {
            Memory result = CompilerUtils.calcUnary(this.getCompiler().getEnvironment(), operator.toTraceInfo(this.getCompiler().getContext()), mem, operator);
            if (operator instanceof ValueIfElseToken) {
                ValueIfElseToken valueIfElseToken = (ValueIfElseToken)operator;
                ExprStmtToken ret = valueIfElseToken.getValue();
                result = mem.toBoolean() ? (ret == null ? mem : this.writeExpression(ret, true, true, false)) : this.writeExpression(valueIfElseToken.getAlternative(), true, true, false);
            } else if (!(operator instanceof ArrayGetExprToken) || !(operator instanceof ArrayGetRefExprToken)) {
                // empty if block
            }
            if (result != null) {
                this.stackPush(result);
                this.setStackPeekAsImmutable();
                return result;
            }
        }
        if (!writeOpcode) {
            return null;
        }
        this.writeLineNumber(operator);
        String name = operator.getCode();
        Class<?> operatorResult = operator.getResultClass();
        LocalVariable variable = null;
        if (L instanceof VariableExprToken) {
            variable = this.method.getLocalVariable(((VariableExprToken)L).getName());
            if (operator instanceof ArrayPushExprToken || operator instanceof ArrayGetRefExprToken) {
                variable.setValue(null);
            }
        }
        if (operator instanceof IncExprToken || operator instanceof DecExprToken) {
            if (variable == null || variable.isReference()) {
                if (operator.getAssociation() == Association.LEFT && returnValue) {
                    this.writePush(o);
                    if (this.stackPeek().type.isConstant()) {
                        this.unexpectedToken(operator);
                    }
                    this.writePushDup();
                    this.writePopImmutable();
                    this.code.add((AbstractInsnNode)new InsnNode(95));
                    this.writePushDup();
                } else {
                    this.writePush(o);
                    if (this.stackPeek().type.isConstant()) {
                        this.unexpectedToken(operator);
                    }
                    this.writePushDup();
                }
                this.writeSysDynamicCall(Memory.class, name, operatorResult, new Class[0]);
                this.writeSysDynamicCall(Memory.class, "assign", Memory.class, operatorResult);
                if (!returnValue || operator.getAssociation() == Association.LEFT) {
                    this.writePopAll(1);
                }
            } else {
                this.writePush(o);
                if (this.stackPeek().type.isConstant()) {
                    this.unexpectedToken(operator);
                }
                if (operator.getAssociation() == Association.LEFT && returnValue) {
                    this.writeVarLoad(variable);
                }
                this.writeSysDynamicCall(Memory.class, name, operatorResult, new Class[0]);
                variable.setValue(null);
                if (operator.getAssociation() == Association.RIGHT) {
                    this.writeVarStore(variable, returnValue);
                } else {
                    this.writeVarStore(variable, false);
                }
            }
        } else if (operator instanceof AmpersandRefToken) {
            this.writePush(o, false, false);
            this.setStackPeekAsImmutable();
            ValueExprToken token = o.getToken();
            if (token instanceof VariableExprToken) {
                LocalVariable local = this.method.getLocalVariable(((VariableExprToken)token).getName());
                local.setValue(null);
            }
        } else if (operator instanceof SilentToken) {
            this.writePushEnv();
            this.writeSysDynamicCall(Environment.class, "__pushSilent", Void.TYPE, new Class[0]);
            this.writePush(o);
            this.writePushEnv();
            this.writeSysDynamicCall(Environment.class, "__popSilent", Void.TYPE, new Class[0]);
        } else if (operator instanceof ValueIfElseToken) {
            this.writePush(o);
            ValueIfElseToken valueIfElseToken = (ValueIfElseToken)operator;
            LabelNode end = new LabelNode();
            LabelNode elseL = new LabelNode();
            if (valueIfElseToken.getValue() == null) {
                StackItem.Type dup = this.stackPeek().type;
                this.writePushDup();
                if (operator instanceof ValueNullCoalesceIfElseToken) {
                    this.writePopBoxing();
                    this.writeSysDynamicCall(Memory.class, "isNotNull", Boolean.TYPE, new Class[0]);
                } else {
                    this.writePopBoolean();
                }
                this.code.add((AbstractInsnNode)new JumpInsnNode(153, elseL));
                this.stackPop();
                this.writePopBoxing();
                this.stackPop();
                this.code.add((AbstractInsnNode)new JumpInsnNode(167, end));
                this.code.add((AbstractInsnNode)elseL);
                this.makePop(dup);
                this.writeExpression(valueIfElseToken.getAlternative(), true, false);
                this.writePopBoxing();
                this.code.add((AbstractInsnNode)end);
            } else {
                this.writePopBoolean();
                this.code.add((AbstractInsnNode)new JumpInsnNode(153, elseL));
                this.stackPop();
                this.writeExpression(valueIfElseToken.getValue(), true, false);
                this.writePopBoxing();
                this.stackPop();
                this.code.add((AbstractInsnNode)new JumpInsnNode(167, end));
                this.code.add((AbstractInsnNode)elseL);
                this.writeExpression(valueIfElseToken.getAlternative(), true, false);
                this.writePopBoxing();
                this.code.add((AbstractInsnNode)end);
            }
            this.setStackPeekAsImmutable(false);
        } else if (operator instanceof ArrayGetExprToken) {
            this.stackPush(o);
            this.writeArrayGet((ArrayGetExprToken)operator, returnValue);
        } else if (operator instanceof CallOperatorToken) {
            this.stackPush(o);
            CallOperatorToken call = (CallOperatorToken)operator;
            this.writePushParameters(call.getParameters(), new Memory[0]);
            this.writePushEnv();
            this.writePushTraceInfo(operator);
            this.writeSysStaticCall(InvokeHelper.class, "callAny", Memory.class, Memory.class, Memory[].class, Environment.class, TraceInfo.class);
            if (!returnValue) {
                this.writePopAll(1);
            }
        } else {
            this.writePush(o);
            this.writePopBoxing();
            if (operator.isEnvironmentNeeded() && operator.isTraceNeeded()) {
                this.writePushEnv();
                this.writePushTraceInfo(operator);
                this.writeSysDynamicCall(Memory.class, name, operatorResult, Environment.class, TraceInfo.class);
            } else if (operator.isEnvironmentNeeded()) {
                this.writePushEnv();
                this.writeSysDynamicCall(Memory.class, name, operatorResult, Environment.class);
            } else if (operator.isTraceNeeded()) {
                this.writePushTraceInfo(operator);
                this.writeSysDynamicCall(Memory.class, name, operatorResult, TraceInfo.class);
            } else {
                this.writeSysDynamicCall(Memory.class, name, operatorResult, new Class[0]);
            }
            if (!returnValue) {
                this.writePopAll(1);
            }
        }
        return null;
    }

    Memory writeLogicOperator(LogicOperatorExprToken operator, boolean returnValue, boolean writeOpcode) {
        if (this.stackEmpty(true)) {
            this.unexpectedToken(operator);
        }
        if (!writeOpcode) {
            StackItem top = this.stackPeek();
            Memory one = this.tryWritePush(top, false, false, true);
            if (one == null) {
                return null;
            }
            Memory two = this.writeExpression(operator.getRightValue(), true, true, false);
            if (two == null) {
                return null;
            }
            this.stackPop();
            Memory r = operator.calc(this.getCompiler().getEnvironment(), operator.toTraceInfo(this.getCompiler().getContext()), one, two);
            this.stackPush(r);
            return r;
        }
        this.writeLineNumber(operator);
        StackItem o = this.stackPop();
        this.writePush(o);
        this.writePopBoolean();
        LabelNode end = new LabelNode();
        LabelNode next = new LabelNode();
        if (operator instanceof BooleanOrExprToken || operator instanceof BooleanOr2ExprToken) {
            this.code.add((AbstractInsnNode)new JumpInsnNode(153, next));
            this.stackPop();
            if (returnValue) {
                this.writePushBooleanAsMemory(true);
                this.stackPop();
            }
        } else if (operator instanceof BooleanAndExprToken || operator instanceof BooleanAnd2ExprToken) {
            this.code.add((AbstractInsnNode)new JumpInsnNode(154, next));
            this.stackPop();
            if (returnValue) {
                this.writePushBooleanAsMemory(false);
                this.stackPop();
            }
        }
        this.code.add((AbstractInsnNode)new JumpInsnNode(167, end));
        this.code.add((AbstractInsnNode)next);
        this.writeExpression(operator.getRightValue(), returnValue, false);
        if (returnValue) {
            if (operator.getLast() instanceof ValueIfElseToken) {
                this.writePopBoxing();
            } else {
                this.writePopBooleanAsObject();
            }
        }
        this.code.add((AbstractInsnNode)end);
        return null;
    }

    Memory writeOperator(OperatorExprToken operator, boolean returnValue, boolean writeOpcode) {
        StackItem o1;
        BaseExprCompiler compiler;
        if (writeOpcode && (compiler = (BaseExprCompiler)this.getCompiler(operator.getClass())) != null) {
            if (writeOpcode) {
                this.writeLineNumber(operator);
            }
            compiler.write(operator, returnValue);
            return null;
        }
        if (operator instanceof LogicOperatorExprToken) {
            return this.writeLogicOperator((LogicOperatorExprToken)operator, returnValue, writeOpcode);
        }
        if (!operator.isBinary()) {
            return this.writeUnaryOperator(operator, returnValue, writeOpcode);
        }
        if (this.stackEmpty(true)) {
            this.unexpectedToken(operator);
        }
        if ((o1 = this.stackPop()).isInvalidForOperations()) {
            this.unexpectedToken(operator);
        }
        if (this.stackEmpty(true)) {
            this.unexpectedToken(operator);
        }
        StackItem o2 = this.stackPeek();
        ValueExprToken L = this.stackPopToken();
        if (o2.isInvalidForOperations()) {
            this.unexpectedToken(operator);
        }
        if (!(operator instanceof AssignExprToken) && !(operator instanceof AssignOperatorExprToken) && o1.getMemory() != null && o2.getMemory() != null) {
            Memory result = CompilerUtils.calcBinary(this.getCompiler().getEnvironment(), operator.toTraceInfo(this.getCompiler().getContext()), o2.getMemory(), o1.getMemory(), operator, false);
            this.stackPush(result);
            return result;
        }
        LocalVariable variable = null;
        if (L instanceof VariableExprToken) {
            variable = this.method.getLocalVariable(((VariableExprToken)L).getName());
        }
        if (operator instanceof AssignExprToken && L instanceof VariableExprToken) {
            if (!writeOpcode) {
                return null;
            }
            this.writeVariableAssign((VariableExprToken)L, o1, (AssignExprToken)operator, returnValue);
            return null;
        }
        Memory value1 = operator instanceof AssignableOperatorToken ? null : this.tryWritePush(o2, false, false, true);
        Memory value2 = this.tryWritePush(o1, false, false, true);
        if (value1 != null && value2 != null) {
            this.stackPush(value1);
            this.stackPush(value2);
            return this.writeOperator(operator, returnValue, writeOpcode);
        }
        if (!returnValue && CompilerUtils.isOperatorAlwaysReturn(operator)) {
            this.unexpectedToken(operator);
        }
        if (!writeOpcode) {
            this.stackPush(o2);
            this.stackPush(o1);
            return null;
        }
        if (writeOpcode) {
            this.writeLineNumber(operator);
        }
        StackItem.Type Lt = this.tryGetType(o2);
        StackItem.Type Rt = this.tryGetType(o1);
        String name = operator.getCode();
        Class<Object> operatorResult = operator.getResultClass();
        boolean isInvert = false;
        boolean sideOperator = operator.isSide();
        if (variable != null && !variable.isReference() && operator instanceof AssignOperatorExprToken) {
            name = ((AssignOperatorExprToken)operator).getOperatorCode();
            if (operator instanceof AssignConcatExprToken) {
                operatorResult = String.class;
            }
            if (operator instanceof AssignPlusExprToken || operator instanceof AssignMulExprToken) {
                sideOperator = false;
            }
        }
        if (operator instanceof AssignableOperatorToken && this.tryIsImmutable(o2)) {
            this.unexpectedToken(operator);
        }
        if (Lt.isConstant() && Rt.isConstant()) {
            if (operator instanceof AssignableOperatorToken) {
                this.unexpectedToken(operator);
            }
            this.writeScalarOperator(o2, Lt, o1, Rt, operator, operatorResult, name);
        } else {
            boolean bl = isInvert = !o1.isKnown();
            if (!o1.isKnown() && !o2.isKnown() && o1.getLevel() > o2.getLevel()) {
                isInvert = false;
            }
            if (Lt.isConstant() && !isInvert) {
                this.writePush(o2);
                if (this.methodExists(OperatorUtils.class, name, Lt.toClass(), Rt.toClass())) {
                    this.writePush(o1);
                    this.writeSysStaticCall(OperatorUtils.class, name, operatorResult, Lt.toClass(), Rt.toClass());
                } else {
                    this.writePopBoxing();
                    this.writePush(o1);
                    this.writeSysDynamicCall(Memory.class, name, operatorResult, Rt.toClass());
                }
            } else {
                if (isInvert) {
                    this.stackPush(o1);
                    if (o2.isKnown()) {
                        this.writePopBoxing(false);
                    }
                    this.writePush(o2);
                    if (!o2.isKnown() && !o2.type.isReference()) {
                        this.writeSysStaticCall(OperatorUtils.class, name, operatorResult, Lt.toClass(), Rt.toClass());
                        name = null;
                    } else if (sideOperator) {
                        name = name + "Right";
                    }
                } else {
                    this.writePush(o2);
                    this.writePopBoxing(false);
                    this.writePush(o1);
                    if (Rt.isReference()) {
                        this.writePopBoxing(false);
                    } else if (Rt.isLikeInt()) {
                        this.writePopLong();
                        Rt = StackItem.Type.LONG;
                    }
                    if (!o1.immutable && !operator.isMutableArguments()) {
                        this.writePopImmutable();
                    }
                }
                if (name != null) {
                    this.writeSysDynamicCall(Memory.class, name, operatorResult, isInvert ? Lt.toClass() : Rt.toClass());
                }
                if (operator.getCheckerCode() != null) {
                    this.writePopBoxing();
                    this.writePushEnv();
                    this.writePushTraceInfo(operator);
                    this.writeSysDynamicCall(Memory.class, operator.getCheckerCode(), Memory.class, Environment.class, TraceInfo.class);
                }
            }
            this.setStackPeekAsImmutable();
            if (operator instanceof AssignOperatorExprToken) {
                if (variable == null || variable.isReference()) {
                    if (!returnValue) {
                        this.writePopAll(1);
                    }
                } else {
                    if (returnValue) {
                        this.writePushDup(StackItem.Type.valueOf(operatorResult));
                    }
                    this.writePopBoxing(operatorResult);
                    this.makeVarStore(variable);
                    variable.setValue(!this.stackPeek().isConstant() ? null : this.stackPeek().getMemory());
                    this.stackPop();
                }
            }
        }
        return null;
    }

    void writeDebugMessage(String message) {
        this.writePushEnv();
        this.writePushConstString(message);
        this.writeSysDynamicCall(Environment.class, "echo", Void.TYPE, String.class);
    }

    public void writeConditional(ExprStmtToken condition, LabelNode successLabel) {
        this.writeExpression(condition, true, false);
        this.writePopBoolean();
        this.code.add((AbstractInsnNode)new JumpInsnNode(153, successLabel));
        this.stackPop();
    }

    public Memory writeExpression(ExprStmtToken expression, boolean returnValue, boolean returnMemory) {
        return this.writeExpression(expression, returnValue, returnMemory, true);
    }

    public Memory tryCalculateExpression(ExprStmtToken expression) {
        return this.writeExpression(expression, true, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public Memory writeExpression(ExprStmtToken expression, boolean returnValue, boolean returnMemory, boolean writeOpcode) {
        void var9_17;
        int initStackSize = this.method.getStackCount();
        this.exprStackInit.push(initStackSize);
        if (!expression.isStmtList()) {
            if (expression.getAsmExpr() == null) {
                throw new CriticalException("Invalid expression token without asm expr, on line " + expression.getMeta().getStartLine() + ", expr = " + expression.getWord());
            }
            expression = expression.getAsmExpr();
        }
        List<Token> tokens = expression.getTokens();
        int operatorCount = 0;
        for (Token token : tokens) {
            if (!(token instanceof OperatorExprToken)) continue;
            ++operatorCount;
        }
        boolean invalid = false;
        for (Token token : tokens) {
            if (token == null) continue;
            this.writeTickTrigger(token);
            if (writeOpcode) {
                BaseStatementCompiler<?> cmp;
                if (token instanceof StmtToken && !(token instanceof ReturnStmtToken)) {
                    ((MethodEntity)this.method.entity).setImmutable(false);
                }
                if ((cmp = this.getCompiler(token.getClass())) != null && !(cmp instanceof BaseExprCompiler)) {
                    cmp.write(token);
                    continue;
                }
            }
            if (token instanceof ValueExprToken) {
                if (token instanceof CallExprToken && ((CallExprToken)token).getName() instanceof OperatorExprToken) {
                    if (!writeOpcode) break;
                    this.writePush((ValueExprToken)token, true, true);
                    ((MethodEntity)this.method.entity).setImmutable(false);
                    continue;
                }
                this.stackPush((ValueExprToken)token);
                continue;
            }
            if (!(token instanceof OperatorExprToken)) break;
            if (--operatorCount < 0) continue;
            Memory result = operatorCount == 0 ? this.writeOperator((OperatorExprToken)token, returnValue, writeOpcode) : this.writeOperator((OperatorExprToken)token, true, writeOpcode);
            if (!writeOpcode && result == null) {
                invalid = true;
                break;
            }
            if (result != null) continue;
            ((MethodEntity)this.method.entity).setImmutable(false);
        }
        Object var9_12 = null;
        if (!invalid && returnMemory && returnValue && !this.stackEmpty(false) && this.stackPeek().isConstant()) {
            Memory memory = this.stackPop().memory;
            invalid = true;
        }
        if (!invalid) {
            if (returnValue && !this.stackEmpty(false) && this.stackPeek().isKnown()) {
                if (returnMemory) {
                    Memory memory = this.tryWritePush(this.stackPop(), writeOpcode, returnValue, true);
                } else {
                    this.writePush(this.stackPop());
                }
            } else if (this.method.getStackCount() > 0) {
                if (this.stackPeekToken() instanceof CallableExprToken) {
                    if (returnMemory) {
                        Memory memory = this.tryWritePush(this.stackPopToken(), returnValue, writeOpcode, true);
                    } else {
                        this.writePush(this.stackPopToken(), returnValue, true);
                    }
                } else if (this.stackPeek().isConstant()) {
                    this.stackPop();
                }
            }
        }
        if (!returnValue && writeOpcode) {
            this.writePopAll(this.method.getStackCount() - initStackSize);
        } else if (!writeOpcode) {
            int count = this.method.getStackCount() - initStackSize;
            for (int i = 0; i < count; ++i) {
                this.stackPop();
            }
        }
        this.exprStackInit.pop();
        return var9_17;
    }

    void makePop(StackItem.Type type) {
        switch (type.size()) {
            case 2: {
                this.code.add((AbstractInsnNode)new InsnNode(88));
                break;
            }
            case 1: {
                this.code.add((AbstractInsnNode)new InsnNode(87));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid of size StackItem: " + type.size());
            }
        }
    }

    public void writePopAll(int count) {
        block4: for (int i = 0; this.method.getStackCount() > 0 && i < count; ++i) {
            StackItem o = this.stackPop();
            ValueExprToken token = o.getToken();
            StackItem.Type type = o.type;
            if (token == null) {
                switch (type.size()) {
                    case 2: {
                        this.code.add((AbstractInsnNode)new InsnNode(88));
                        continue block4;
                    }
                    case 1: {
                        this.code.add((AbstractInsnNode)new InsnNode(87));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Invalid of size StackItem: " + type.size());
            }
            this.unexpectedToken(token);
        }
    }

    public Entity compile() {
        this.writeDefineVariables(this.methodStatement.getLocal());
        this.writeExpression(this.expression, false, false);
        this.method.popAll();
        return null;
    }

    static {
        compilerRules.put(IfStmtToken.class, IfElseCompiler.class);
        compilerRules.put(SwitchStmtToken.class, SwitchCompiler.class);
        compilerRules.put(FunctionStmtToken.class, FunctionCompiler.class);
        compilerRules.put(EchoRawToken.class, EchoRawCompiler.class);
        compilerRules.put(EchoStmtToken.class, EchoCompiler.class);
        compilerRules.put(OpenEchoTagToken.class, OpenEchoTagCompiler.class);
        compilerRules.put(ReturnStmtToken.class, ReturnCompiler.class);
        compilerRules.put(BodyStmtToken.class, BodyCompiler.class);
        compilerRules.put(WhileStmtToken.class, WhileCompiler.class);
        compilerRules.put(DoStmtToken.class, DoCompiler.class);
        compilerRules.put(ForStmtToken.class, ForCompiler.class);
        compilerRules.put(ForeachStmtToken.class, ForeachCompiler.class);
        compilerRules.put(TryStmtToken.class, TryCatchCompiler.class);
        compilerRules.put(ThrowStmtToken.class, ThrowCompiler.class);
        compilerRules.put(BreakStmtToken.class, JumpCompiler.class);
        compilerRules.put(ContinueStmtToken.class, JumpCompiler.class);
        compilerRules.put(GotoStmtToken.class, GotoCompiler.class);
        compilerRules.put(LabelStmtToken.class, GotoLabelCompiler.class);
        compilerRules.put(GlobalStmtToken.class, GlobalDefinitionCompiler.class);
        compilerRules.put(StaticStmtToken.class, StaticDefinitionCompiler.class);
        compilerRules.put(JvmCompiler.ClassInitEnvironment.class, ClassInitEnvironmentCompiler.class);
        compilerRules.put(BooleanExprToken.class, BooleanValueCompiler.class);
        compilerRules.put(IntegerExprToken.class, IntValueCompiler.class);
        compilerRules.put(NullExprToken.class, NullValueCompiler.class);
        compilerRules.put(DoubleExprToken.class, DoubleValueCompiler.class);
        compilerRules.put(StringExprToken.class, StringValueCompiler.class);
        compilerRules.put(ShellExecExprToken.class, ShellExecValueCompiler.class);
        compilerRules.put(IncludeExprToken.class, ImportCompiler.class);
        compilerRules.put(IncludeOnceExprToken.class, ImportCompiler.class);
        compilerRules.put(RequireExprToken.class, ImportCompiler.class);
        compilerRules.put(RequireOnceExprToken.class, ImportCompiler.class);
        compilerRules.put(NewExprToken.class, NewValueCompiler.class);
        compilerRules.put(StringBuilderExprToken.class, StringBuilderValueCompiler.class);
        compilerRules.put(UnsetExprToken.class, UnsetCompiler.class);
        compilerRules.put(IssetExprToken.class, IssetCompiler.class);
        compilerRules.put(EmptyExprToken.class, EmptyCompiler.class);
        compilerRules.put(DieExprToken.class, DieCompiler.class);
        compilerRules.put(StaticExprToken.class, StaticValueCompiler.class);
        compilerRules.put(ClosureStmtToken.class, ClosureValueCompiler.class);
        compilerRules.put(GetVarExprToken.class, VarVarValueCompiler.class);
        compilerRules.put(SelfExprToken.class, SelfValueCompiler.class);
        compilerRules.put(StaticAccessExprToken.class, StaticAccessValueCompiler.class);
        compilerRules.put(StaticAccessIssetExprToken.class, StaticAccessValueCompiler.class);
        compilerRules.put(StaticAccessUnsetExprToken.class, StaticAccessValueCompiler.class);
        compilerRules.put(ListExprToken.class, ListCompiler.class);
        compilerRules.put(YieldExprToken.class, YieldValueCompiler.class);
        compilerRules.put(InstanceofExprToken.class, InstanceOfCompiler.class);
        compilerRules.put(DynamicAccessAssignExprToken.class, DynamicAccessCompiler.class);
        compilerRules.put(DynamicAccessEmptyExprToken.class, DynamicAccessCompiler.class);
        compilerRules.put(DynamicAccessExprToken.class, DynamicAccessCompiler.class);
        compilerRules.put(DynamicAccessGetRefExprToken.class, DynamicAccessCompiler.class);
        compilerRules.put(DynamicAccessIssetExprToken.class, DynamicAccessCompiler.class);
        compilerRules.put(DynamicAccessUnsetExprToken.class, DynamicAccessCompiler.class);
        compilerRules.put(StaticAccessOperatorExprToken.class, StaticAccessValueAsOperatorCompiler.class);
    }

    public static class UnsupportedTokenException
    extends RuntimeException {
        protected final Token token;

        public UnsupportedTokenException(Token token) {
            this.token = token;
        }
    }

    public static class NoSuchMethodException
    extends RuntimeException {
        public NoSuchMethodException(Class clazz, String method, Class ... parameters) {
            super("No such method " + clazz.getName() + "." + method + "(" + StringUtils.join((Object[])parameters, (String)", ") + ")");
        }
    }

    public static class PushCallStatistic {
        public StackItem.Type returnType = StackItem.Type.REFERENCE;
    }
}

