/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators.manually;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.develnext.jphp.core.common.Separator;
import org.develnext.jphp.core.syntax.ExpressionInfo;
import org.develnext.jphp.core.syntax.Scope;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.ExprGenerator;
import org.develnext.jphp.core.syntax.generators.FunctionGenerator;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.Tokenizer;
import org.develnext.jphp.core.tokenizer.token.BreakToken;
import org.develnext.jphp.core.tokenizer.token.ColonToken;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ClassExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.DollarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AmpersandRefToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AndExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetEmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayPushExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignOperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignableOperatorToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.CallOperatorToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessAssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessEmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.IncExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.InstanceofExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.KeyValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.LogicOperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.StaticAccessOperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.UnarMinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ValueIfElseToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ValueNullCoalesceIfElseToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.CastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.UnsetCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ArrayExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.CallExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ClosureStmtToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DieExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DoubleExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.EmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FromExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.GetVarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ImportExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IntegerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ListExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NewExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ParentExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.PrintNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ShellExecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringBuilderExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.UnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.YieldExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.MacroToken;
import org.develnext.jphp.core.tokenizer.token.stmt.AsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;
import php.runtime.common.Callback;
import php.runtime.common.Messages;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.ParseException;
import php.runtime.exceptions.support.ErrorType;

public class SimpleExprGenerator
extends Generator<ExprStmtToken> {
    private boolean isRef = false;
    private boolean canStartByReference = false;
    private static final Set<String> dynamicLocalFunctions = new HashSet<String>(){
        {
            this.add("extract");
            this.add("compact");
            this.add("get_defined_vars");
            this.add("eval");
        }
    };

    public SimpleExprGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    public SimpleExprGenerator setCanStartByReference(boolean canStartByReference) {
        this.canStartByReference = canStartByReference;
        return this;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    protected Token processClosure(Token current, Token next, ListIterator<Token> iterator) {
        FunctionStmtToken functionStmtToken = this.analyzer.generator(FunctionGenerator.class).getToken(current, iterator, true);
        if (functionStmtToken.getName() == null) {
            ClosureStmtToken result = new ClosureStmtToken(current.getMeta());
            result.setFunction(functionStmtToken);
            result.setOwnerClass(this.analyzer.getClazz());
            this.analyzer.registerClosure(result);
            return result;
        }
        this.analyzer.registerFunction(functionStmtToken);
        return functionStmtToken;
    }

    public ListExprToken processSingleList(Token current, ListIterator<Token> iterator) {
        return this.processList(current, iterator, null, null, -1);
    }

    protected ListExprToken processList(Token current, ListIterator<Token> iterator, List indexes, BraceExprToken.Kind closedBraceKind, int braceOpened) {
        Token next;
        ListExprToken result;
        boolean arraySyntax = this.isOpenedBrace(current, BraceExprToken.Kind.ARRAY);
        ListExprToken listExprToken = result = arraySyntax ? new ListExprToken(current.getMeta()) : (ListExprToken)current;
        if (!arraySyntax && !this.isOpenedBrace(next = this.nextToken(iterator), BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, "(");
        }
        int i = 0;
        boolean withKeys = false;
        Object keyExpr = null;
        while (true) {
            Token single;
            if ((next = this.nextToken(iterator)) instanceof ListExprToken || this.isOpenedBrace(next, BraceExprToken.Kind.ARRAY)) {
                if (arraySyntax && next instanceof ListExprToken || !arraySyntax && this.isOpenedBrace(next, BraceExprToken.Kind.ARRAY)) {
                    this.analyzer.getEnvironment().error(next.toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_CANNOT_MIX_ARRAY_AND_LIST, new Object[0]);
                }
                ArrayList<Integer> indexes_ = new ArrayList<Integer>();
                if (indexes != null) {
                    indexes_.addAll(indexes);
                }
                indexes_.add((Integer)(keyExpr == null ? Integer.valueOf(i) : keyExpr));
                ListExprToken tmp = this.processList(next, iterator, indexes_, null, -1);
                result.addList(tmp);
                if (this.nextTokenAndPrev(iterator) instanceof CommaToken) {
                    iterator.next();
                }
                ++i;
                continue;
            }
            if (this.isClosedBrace(next, arraySyntax ? BraceExprToken.Kind.ARRAY : BraceExprToken.Kind.SIMPLE)) break;
            if (next instanceof CommaToken) {
                ++i;
                continue;
            }
            SimpleExprGenerator generator = this.analyzer.generator(SimpleExprGenerator.class);
            int currIndex = iterator.nextIndex() - 1;
            ExprStmtToken var = generator.getToken(next, iterator, Separator.COMMA, arraySyntax ? BraceExprToken.Kind.ARRAY : BraceExprToken.Kind.SIMPLE);
            int k = 0;
            keyExpr = null;
            ExprStmtToken valueExpr = var;
            for (Token token : var.getTokens()) {
                if (token instanceof KeyValueExprToken) {
                    keyExpr = new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), var.getTokens().subList(0, k));
                    valueExpr = new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), var.getTokens().subList(k + 1, var.getTokens().size()));
                    if (!(valueExpr.getSingle() instanceof ArrayExprToken) && !(valueExpr.getSingle() instanceof ListExprToken)) break;
                    if (arraySyntax && valueExpr.getSingle() instanceof ListExprToken || !arraySyntax && valueExpr.getSingle() instanceof ArrayExprToken) {
                        this.analyzer.getEnvironment().error(next.toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_CANNOT_MIX_ARRAY_AND_LIST, new Object[0]);
                    }
                    int doneIndex = iterator.nextIndex() - 1;
                    int prevCount = doneIndex - currIndex;
                    for (int m = 0; m < prevCount; ++m) {
                        iterator.previous();
                    }
                    do {
                        if (!((current = iterator.next()) instanceof KeyValueExprToken)) continue;
                        current = iterator.next();
                        break;
                    } while (iterator.hasNext());
                    ArrayList<Object> indexes_ = new ArrayList<Object>();
                    if (indexes != null) {
                        indexes_.addAll(indexes);
                    }
                    indexes_.add(keyExpr);
                    ListExprToken listExprToken2 = this.processList(current, iterator, indexes_, null, -1);
                    result.addList(listExprToken2);
                    if (!(this.nextTokenAndPrev(iterator) instanceof CommaToken)) break;
                    iterator.next();
                    break;
                }
                ++k;
            }
            if ((single = valueExpr.getLast()) instanceof ArrayExprToken || single instanceof ListExprToken) {
                ++i;
                continue;
            }
            if (!(single instanceof VariableExprToken || single instanceof ArrayGetExprToken || single instanceof DynamicAccessExprToken || single instanceof ArrayPushExprToken || single instanceof StaticAccessExprToken && ((StaticAccessExprToken)single).isGetStaticField())) {
                this.unexpectedToken(single);
            }
            if (single instanceof ArrayGetExprToken) {
                single = new ArrayGetRefExprToken((ArrayGetExprToken)single);
                valueExpr.getTokens().set(var.getTokens().size() - 1, single);
                valueExpr.updateAsmExpr(this.analyzer.getEnvironment(), this.analyzer.getContext());
            }
            if (keyExpr == null) {
                if (withKeys) {
                    this.analyzer.getEnvironment().error(next.toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_CANNOT_MIX_KEYED_AND_UNKEYED_ARRAY_ENTRIES, new Object[0]);
                }
                result.addVariable(valueExpr, i, (List<Integer>)indexes);
            } else {
                if (!withKeys && i > 0) {
                    this.analyzer.getEnvironment().error(next.toTraceInfo(this.analyzer.getContext()), ErrorType.E_ERROR, Messages.ERR_CANNOT_MIX_KEYED_AND_UNKEYED_ARRAY_ENTRIES, new Object[0]);
                }
                withKeys = true;
                result.addVariable(valueExpr, (ExprStmtToken)keyExpr, (List<Integer>)indexes);
            }
            ++i;
        }
        if (braceOpened != -1) {
            next = this.nextToken(iterator);
            if (!(next instanceof AssignExprToken)) {
                iterator.previous();
                return result;
            }
            ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, BraceExprToken.Kind.ANY);
            result.setValue(value);
        }
        return result;
    }

    protected DieExprToken processDie(Token current, Token next, ListIterator<Token> iterator) {
        DieExprToken die = (DieExprToken)current;
        if (this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            die.setValue(this.analyzer.generator(ExprGenerator.class).getInBraces(BraceExprToken.Kind.SIMPLE, iterator));
        }
        return die;
    }

    protected EmptyExprToken processEmpty(Token current, ListIterator<Token> iterator) {
        ExprStmtToken value = this.analyzer.generator(ExprGenerator.class).getInBraces(BraceExprToken.Kind.SIMPLE, iterator);
        if (value == null) {
            this.unexpectedToken(iterator.previous());
        }
        assert (value != null);
        Token last = value.getLast();
        if (last instanceof DynamicAccessExprToken) {
            last = new DynamicAccessEmptyExprToken((DynamicAccessExprToken)last);
            value.getTokens().set(value.getTokens().size() - 1, last);
        } else if (!(last instanceof VariableExprToken) && !(last instanceof GetVarExprToken)) {
            if (last instanceof StaticAccessExprToken && ((StaticAccessExprToken)last).isGetStaticField()) {
                last = new StaticAccessIssetExprToken((StaticAccessExprToken)last);
                value.getTokens().set(value.getTokens().size() - 1, last);
            } else if (last instanceof ArrayGetExprToken) {
                ArrayGetEmptyExprToken el = new ArrayGetEmptyExprToken(last.getMeta());
                el.setParameters(((ArrayGetExprToken)last).getParameters());
                value.getTokens().set(value.getTokens().size() - 1, el);
            } else {
                this.unexpectedToken(last);
            }
        }
        EmptyExprToken result = (EmptyExprToken)current;
        value.updateAsmExpr(this.analyzer.getEnvironment(), this.analyzer.getContext());
        result.setValue(value);
        return result;
    }

    protected IssetExprToken processIsset(Token previous, Token current, ListIterator<Token> iterator) {
        Token next = this.nextTokenAndPrev(iterator);
        if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, "(");
        }
        CallExprToken call = this.processCall(current, this.nextToken(iterator), iterator);
        for (ExprStmtToken param : call.getParameters()) {
            List<Token> tokens = param.getTokens();
            Token last = tokens.get(tokens.size() - 1);
            ExprToken newToken = null;
            if (last instanceof DynamicAccessExprToken) {
                newToken = new DynamicAccessIssetExprToken((DynamicAccessExprToken)last);
                if (this.analyzer.getClazz() != null && !"__isset".equals(this.analyzer.getFunction().getFulledName())) {
                    newToken.setWithMagic(false);
                }
            } else if (!(last instanceof VariableExprToken) && !(last instanceof GetVarExprToken)) {
                if (last instanceof StaticAccessExprToken && ((StaticAccessExprToken)last).isGetStaticField()) {
                    newToken = new StaticAccessIssetExprToken((StaticAccessExprToken)last);
                } else if (last instanceof ArrayGetExprToken) {
                    ArrayGetIssetExprToken el = new ArrayGetIssetExprToken(last.getMeta());
                    el.setParameters(((ArrayGetExprToken)last).getParameters());
                    newToken = el;
                } else {
                    this.unexpectedToken(param.getSingle());
                }
            }
            if (newToken == null) continue;
            tokens.set(tokens.size() - 1, newToken);
            param.updateAsmExpr(this.analyzer.getEnvironment(), this.analyzer.getContext());
        }
        IssetExprToken result = (IssetExprToken)current;
        result.setParameters(call.getParameters());
        return result;
    }

    protected UnsetExprToken processUnset(Token previous, Token current, ListIterator<Token> iterator) {
        Token next = this.nextTokenAndPrev(iterator);
        if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, "(");
        }
        CallExprToken call = this.processCall(current, this.nextToken(iterator), iterator);
        for (ExprStmtToken param : call.getParameters()) {
            List<Token> tokens = param.getTokens();
            Token last = tokens.get(tokens.size() - 1);
            Token newToken = null;
            if (!(param.getSingle() instanceof StaticAccessExprToken && ((StaticAccessExprToken)param.getSingle()).isGetStaticField() || param.getSingle() instanceof VariableValueExprToken)) {
                this.unexpectedToken(param);
            }
            if (last instanceof VariableExprToken || last instanceof GetVarExprToken) {
                newToken = last;
            } else if (last instanceof ArrayGetExprToken) {
                ArrayGetUnsetExprToken el = new ArrayGetUnsetExprToken(last.getMeta());
                el.setParameters(((ArrayGetExprToken)last).getParameters());
                newToken = el;
            } else if (last instanceof DynamicAccessExprToken) {
                newToken = new DynamicAccessUnsetExprToken((DynamicAccessExprToken)last);
            } else if (last instanceof StaticAccessExprToken) {
                newToken = new StaticAccessUnsetExprToken((StaticAccessExprToken)last);
            } else {
                this.unexpectedToken(last);
            }
            tokens.set(tokens.size() - 1, newToken);
            param.updateAsmExpr(this.analyzer.getEnvironment(), this.analyzer.getContext());
        }
        UnsetExprToken result = (UnsetExprToken)current;
        result.setParameters(call.getParameters());
        return result;
    }

    protected CallExprToken processCall(Token previous, Token current, ListIterator<Token> iterator) {
        ExprStmtToken param;
        ArrayList<ExprStmtToken> parameters = new ArrayList<ExprStmtToken>();
        do {
            if ((param = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, Separator.COMMA, BraceExprToken.Kind.SIMPLE)) == null) continue;
            parameters.add(param);
            if (!param.isSingle() || !(param.getTokens().get(0) instanceof VariableExprToken) || this.analyzer.getFunction() == null) continue;
            this.analyzer.getFunction().variable((VariableExprToken)param.getTokens().get(0)).setPassed(true);
        } while (!this.isClosedBrace(this.nextToken(iterator), BraceExprToken.Kind.SIMPLE) && param != null);
        CallExprToken result = new CallExprToken(TokenMeta.of(previous, current));
        if (previous instanceof ValueExprToken) {
            result.setName(this.analyzer.getRealName((ValueExprToken)previous, NamespaceUseStmtToken.UseType.FUNCTION));
            if (this.analyzer.getFunction() != null && result.getName() instanceof NameToken) {
                String name = ((NameToken)result.getName()).getName().toLowerCase();
                if (result.getName() instanceof FulledNameToken) {
                    name = ((FulledNameToken)result.getName()).getLastName().getName().toLowerCase();
                }
                if (dynamicLocalFunctions.contains(name.toLowerCase())) {
                    this.analyzer.getFunction().setDynamicLocal(true);
                }
                if ("get_called_class".equalsIgnoreCase(name)) {
                    this.analyzer.getScope().setStaticExists(true);
                }
            }
        } else if (previous instanceof DynamicAccessExprToken) {
            result.setName((ExprToken)previous);
        } else {
            result.setName(null);
        }
        result.setParameters(parameters);
        if (this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().setCallsExist(true);
        }
        return result;
    }

    protected Token processYield(Token current, Token next, ListIterator<Token> iterator, BraceExprToken.Kind closedBrace) {
        if (this.analyzer.getFunction() == null) {
            this.analyzer.getEnvironment().error(current.toTraceInfo(this.analyzer.getContext()), Messages.ERR_YIELD_CAN_ONLY_INSIDE_FUNCTION.fetch(new Object[0]), new Object[0]);
        }
        this.analyzer.getFunction().setGenerator(true);
        YieldExprToken result = (YieldExprToken)current;
        if (next instanceof FromExprToken) {
            this.nextToken(iterator);
            result.setDelegating(true);
        }
        if (next instanceof OperatorExprToken && ((OperatorExprToken)next).isBinary()) {
            result.setValue(null);
        } else {
            ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, BraceExprToken.Kind.ANY);
            result.setValue(value);
        }
        return result;
    }

    protected ImportExprToken processImport(Token current, Token next, ListIterator<Token> iterator, BraceExprToken.Kind closedBrace, int braceOpened) {
        ImportExprToken result = (ImportExprToken)current;
        ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, BraceExprToken.Kind.ANY);
        result.setValue(value);
        if (this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().setDynamicLocal(true);
        }
        return result;
    }

    protected CallExprToken processPrint(Token current, Token next, ListIterator<Token> iterator, BraceExprToken.Kind closedBrace, int braceOpened) {
        CallExprToken callExprToken = new CallExprToken(current.getMeta());
        callExprToken.setName((ExprToken)current);
        ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, BraceExprToken.Kind.ANY);
        if (value == null) {
            this.unexpectedToken(iterator.previous());
        }
        callExprToken.setParameters(Arrays.asList(value));
        return callExprToken;
    }

    protected Token processStaticAccess(Token current, Token previous, ListIterator<Token> iterator) {
        Token name = previous;
        if (name != null && !this.isTokenClass(name, SelfExprToken.class, StaticExprToken.class, ParentExprToken.class)) {
            name = this.makeSensitive(previous);
        }
        if (name == null || name instanceof NameToken || name instanceof VariableExprToken || name instanceof SelfExprToken || name instanceof StaticExprToken || name instanceof ParentExprToken) {
            if (name instanceof StaticExprToken) {
                this.analyzer.getScope().setStaticExists(true);
            }
            StaticAccessExprToken result = (StaticAccessExprToken)current;
            ValueExprToken clazz = (ValueExprToken)name;
            if (clazz instanceof NameToken) {
                clazz = this.analyzer.getRealName((NameToken)clazz);
            } else if (clazz instanceof SelfExprToken && this.analyzer.getClazz() != null && !this.analyzer.getClazz().isTrait()) {
                clazz = new FulledNameToken(clazz.getMeta(), (List<? extends Token>)new ArrayList<Token>(){
                    {
                        if (SimpleExprGenerator.this.analyzer.getClazz().getNamespace().getName() != null) {
                            this.addAll(SimpleExprGenerator.this.analyzer.getClazz().getNamespace().getName().getNames());
                        }
                        this.add(SimpleExprGenerator.this.analyzer.getClazz().getName());
                    }
                });
            }
            result.setClazz(clazz);
            if (name != null) {
                this.nextToken(iterator);
            }
            if (!this.isTokenClass(current = this.nextToken(iterator), ClassStmtToken.class)) {
                current = this.makeSensitive(current);
            }
            if (this.isOpenedBrace(current, BraceExprToken.Kind.BLOCK)) {
                ExprStmtToken expr = this.getToken(this.nextToken(iterator), iterator, false, BraceExprToken.Kind.BLOCK);
                result.setFieldExpr(expr);
                this.nextAndExpected(iterator, BraceExprToken.class);
            } else if (current instanceof NameToken || current instanceof VariableExprToken) {
                result.setField((ValueExprToken)current);
            } else if (current instanceof DollarExprToken) {
                Token nm = this.nextToken(iterator);
                if (nm instanceof VariableExprToken) {
                    result.setFieldExpr(new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), nm));
                } else if (nm instanceof DollarExprToken) {
                    result.setFieldExpr(new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), this.processVarVar(nm, this.nextTokenAndPrev(iterator), iterator)));
                } else if (this.isOpenedBrace(nm, BraceExprToken.Kind.BLOCK)) {
                    iterator.previous();
                    result.setFieldExpr(this.analyzer.generator(ExprGenerator.class).getInBraces(BraceExprToken.Kind.BLOCK, iterator));
                } else {
                    this.unexpectedToken(current);
                }
            } else if (current instanceof ClassStmtToken) {
                if (clazz instanceof ParentExprToken || clazz instanceof StaticExprToken) {
                    if (clazz instanceof StaticExprToken) {
                        this.analyzer.getScope().setStaticExists(true);
                    }
                    result.setField(new ClassExprToken(current.getMeta()));
                } else {
                    if (clazz instanceof NameToken) {
                        return new StringExprToken(TokenMeta.of(((NameToken)clazz).getName(), (Token)clazz), StringExprToken.Quote.SINGLE);
                    }
                    this.unexpectedToken(current);
                }
            } else {
                this.unexpectedToken(current);
            }
            if (name == null) {
                return new StaticAccessOperatorExprToken(result);
            }
            return result;
        }
        this.unexpectedToken(name);
        return null;
    }

    protected DynamicAccessExprToken processDynamicAccess(Token current, Token next, ListIterator<Token> iterator, BraceExprToken.Kind closedBraceKind, int braceOpened) {
        if (next != null && next.isNamedToken() && !(next instanceof NameToken)) {
            next = new NameToken(next.getMeta());
        }
        DynamicAccessExprToken result = (DynamicAccessExprToken)current;
        if (next instanceof NameToken || next instanceof VariableExprToken) {
            result.setField((ValueExprToken)next);
            next = iterator.next();
            if (result.getField() instanceof VariableExprToken && this.isOpenedBrace(this.nextTokenAndPrev(iterator), BraceExprToken.Kind.ARRAY)) {
                Token arr = this.processArrayToken(next, this.nextToken(iterator), iterator);
                result.setFieldExpr(new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), result.getField(), arr));
                result.setField(null);
            }
        } else if (this.isOpenedBrace(next, BraceExprToken.Kind.BLOCK)) {
            ExprStmtToken name = this.analyzer.generator(ExprGenerator.class).getInBraces(BraceExprToken.Kind.BLOCK, iterator);
            result.setFieldExpr(name);
        }
        if (iterator.hasNext()) {
            next = iterator.next();
            if (next instanceof AssignableOperatorToken) {
                DynamicAccessAssignExprToken dResult = new DynamicAccessAssignExprToken(result);
                dResult.setAssignOperator(next);
                ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).setCanStartByReference(true).getNextExpression(this.nextToken(iterator), iterator, BraceExprToken.Kind.ANY);
                dResult.setValue(value);
                return dResult;
            }
            iterator.previous();
        }
        return result;
    }

    public GetVarExprToken processVarVar(Token current, Token next, ListIterator<Token> iterator) {
        ExprStmtToken name = null;
        if (next instanceof VariableExprToken) {
            name = new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), next);
            this.nextToken(iterator);
        } else if (next instanceof DollarExprToken) {
            current = this.nextToken(iterator);
            next = this.nextToken(iterator);
            name = new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), this.processVarVar(current, next, iterator));
            iterator.previous();
        } else if (this.isOpenedBrace(next, BraceExprToken.Kind.BLOCK)) {
            name = this.analyzer.generator(ExprGenerator.class).getInBraces(BraceExprToken.Kind.BLOCK, iterator);
        } else if (next == null) {
            this.unexpectedEnd(current);
        }
        if (name == null) {
            this.unexpectedToken(next);
        }
        if (this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().setDynamicLocal(true);
            this.analyzer.getFunction().setVarsExists(true);
        }
        GetVarExprToken result = new GetVarExprToken(TokenMeta.of(current, name));
        result.setName(name);
        return result;
    }

    protected Token processValueIfElse(ValueIfElseToken current, Token next, ListIterator<Token> iterator, BraceExprToken.Kind closedBrace, int braceOpened, Separator separator) {
        ExprStmtToken value = null;
        if (current instanceof ValueNullCoalesceIfElseToken) {
            value = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, separator, BraceExprToken.Kind.ANY);
            current.setAlternative(value);
        } else {
            value = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COLON, closedBrace);
            current.setValue(value);
            next = iterator.previous();
            if (!(next instanceof ColonToken)) {
                this.unexpectedToken(next, ":");
            }
            iterator.next();
            ExprStmtToken alternative = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, separator, BraceExprToken.Kind.ANY);
            if (alternative == null) {
                this.unexpectedToken(iterator.next());
            }
            current.setAlternative(alternative);
        }
        return current;
    }

    protected ExprStmtToken processNewExpr(Token next, BraceExprToken.Kind closedBrace, int braceOpened, ListIterator<Token> iterator, boolean first) {
        ArrayList<Token> tmp = new ArrayList<Token>();
        if (first) {
            if (next instanceof VariableExprToken) {
                this.analyzer.getScope().addVariable((VariableExprToken)next);
                if (this.analyzer.getFunction() != null) {
                    this.analyzer.getFunction().setVarsExists(true);
                    this.analyzer.getFunction().variable((VariableExprToken)next).setUsed(true);
                }
            }
            tmp.add(next);
        }
        Token previous = next;
        Token token = this.nextToken(iterator);
        if (this.isOpenedBrace(token, BraceExprToken.Kind.ARRAY) || this.isOpenedBrace(token, BraceExprToken.Kind.BLOCK)) {
            tmp.add(this.processArrayToken(previous, token, iterator));
            if (iterator.hasNext() && this.nextTokenAndPrev(iterator) instanceof DynamicAccessExprToken) {
                tmp.addAll(this.processNewExpr(next, closedBrace, braceOpened, iterator, false).getTokens());
            }
        } else if (token instanceof DynamicAccessExprToken) {
            next = null;
            if (iterator.hasNext()) {
                next = iterator.next();
                iterator.previous();
            }
            tmp.add(this.processDynamicAccess(token, next, iterator, closedBrace, braceOpened));
            if (iterator.hasNext() && (this.isOpenedBrace(token = this.nextTokenAndPrev(iterator), BraceExprToken.Kind.ARRAY) || this.isOpenedBrace(token, BraceExprToken.Kind.BLOCK) || token instanceof DynamicAccessExprToken)) {
                tmp.addAll(this.processNewExpr(next, closedBrace, braceOpened, iterator, false).getTokens());
            }
        } else {
            iterator.previous();
        }
        if (!first) {
            return new ExprStmtToken(null, null, tmp);
        }
        return new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), tmp);
    }

    protected Token processNew(Token current, BraceExprToken.Kind closedBrace, int braceOpened, ListIterator<Token> iterator) {
        NewExprToken result = (NewExprToken)current;
        Token next = this.nextToken(iterator);
        if (!this.isTokenClass(next, StaticExprToken.class, ParentExprToken.class, SelfExprToken.class)) {
            next = this.makeSensitive(next);
        }
        if (next instanceof NameToken) {
            FulledNameToken nameToken = this.analyzer.getRealName((NameToken)next);
            result.setName(nameToken);
            iterator.previous();
            iterator.previous();
            if (iterator.hasPrevious()) {
                Token previous = iterator.previous();
                if (previous instanceof AssignExprToken && iterator.hasPrevious()) {
                    previous = iterator.previous();
                    if (previous instanceof VariableExprToken) {
                        this.analyzer.getScope().typeInfoOf(previous).addType(nameToken.getName());
                    }
                    iterator.next();
                }
                iterator.next();
            }
            iterator.next();
            iterator.next();
        } else if (next instanceof VariableExprToken) {
            result.setName(this.processNewExpr(next, closedBrace, braceOpened, iterator, true));
        } else if (next instanceof StaticExprToken) {
            Scope scope = this.analyzer.getScope();
            scope.setStaticExists(true);
            result.setName((StaticExprToken)next);
        } else if (next instanceof SelfExprToken) {
            if (this.analyzer.getClazz() == null) {
                result.setName((SelfExprToken)next);
            } else if (this.analyzer.getClazz().isTrait()) {
                result.setName((SelfExprToken)next);
            } else {
                result.setName(new FulledNameToken(next.getMeta(), (List<? extends Token>)new ArrayList<Token>(){
                    {
                        if (SimpleExprGenerator.this.analyzer.getClazz().getNamespace().getName() != null) {
                            this.addAll(SimpleExprGenerator.this.analyzer.getClazz().getNamespace().getName().getNames());
                        }
                        this.add(SimpleExprGenerator.this.analyzer.getClazz().getName());
                    }
                }));
            }
        } else {
            this.unexpectedToken(next);
        }
        next = this.nextToken(iterator);
        if (this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            ExprStmtToken param;
            ArrayList<ExprStmtToken> parameters = new ArrayList<ExprStmtToken>();
            do {
                if ((param = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, true, BraceExprToken.Kind.SIMPLE)) == null) continue;
                parameters.add(param);
            } while (param != null);
            this.nextToken(iterator);
            result.setParameters(parameters);
        } else {
            result.setParameters(new ArrayList<ExprStmtToken>());
            iterator.previous();
        }
        if (this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().setCallsExist(true);
        }
        return result;
    }

    protected Token processString(StringExprToken string) {
        if (string.getSegments().isEmpty()) {
            if (string.getQuote() == StringExprToken.Quote.SHELL) {
                return new ShellExecExprToken(string.getMeta(), Arrays.asList(string));
            }
            return string;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        int i = 0;
        String value = string.getValue();
        TokenMeta meta = string.getMeta();
        for (StringExprToken.Segment segment : string.getSegments()) {
            String prev = value.substring(i, segment.from);
            if (!prev.isEmpty()) {
                StringExprToken item = new StringExprToken(new TokenMeta(prev, meta.getStartLine() + i, meta.getEndLine(), meta.getStartLine(), meta.getEndLine()), StringExprToken.Quote.SINGLE);
                tokens.add(item);
            }
            String dynamic = value.substring(segment.from, segment.to);
            if (!segment.isVariable) {
                dynamic = dynamic.substring(1, dynamic.length() - 1);
            }
            Tokenizer tokenizer = new Tokenizer(dynamic + ";", this.analyzer.getContext());
            try {
                ExprStmtToken expr;
                SyntaxAnalyzer syntaxAnalyzer = new SyntaxAnalyzer(this.analyzer.getEnvironment(), tokenizer, this.analyzer.getFunction());
                List<Token> tree = syntaxAnalyzer.getTree();
                this.analyzer.getScope().addVariables(syntaxAnalyzer.getScope().getVariables());
                assert (tree.size() > 0);
                Token item = tree.get(0);
                if (!(item instanceof ExprStmtToken)) {
                    this.unexpectedToken(item);
                }
                if ((expr = (ExprStmtToken)item).isSingle()) {
                    tokens.add(expr.getSingle());
                } else {
                    tokens.add(expr);
                }
            }
            catch (ParseException e) {
                TraceInfo oldTrace = e.getTraceInfo();
                e.setTraceInfo(new TraceInfo(this.analyzer.getContext(), meta.getStartLine() + oldTrace.getStartLine(), meta.getEndLine() + oldTrace.getEndLine(), meta.getStartLine() + oldTrace.getStartLine(), meta.getEndLine() + oldTrace.getEndLine()));
                throw e;
            }
            i = segment.to;
        }
        String prev = value.substring(i);
        if (!prev.isEmpty()) {
            StringExprToken item = new StringExprToken(new TokenMeta(prev, meta.getStartLine() + i, meta.getEndLine(), meta.getStartLine(), meta.getEndLine()), StringExprToken.Quote.SINGLE);
            tokens.add(item);
        }
        if (string.getQuote() == StringExprToken.Quote.SHELL) {
            return new ShellExecExprToken(meta, tokens);
        }
        StringBuilderExprToken result = new StringBuilderExprToken(meta, tokens);
        result.setBinary(string.isBinary());
        return result;
    }

    protected Token processSimpleToken(Token current, Token previous, Token next, ListIterator<Token> iterator, BraceExprToken.Kind closedBraceKind, int braceOpened, Separator separator) {
        if (current instanceof DynamicAccessExprToken) {
            return this.processDynamicAccess(current, next, iterator, closedBraceKind, braceOpened);
        }
        if (current instanceof OperatorExprToken) {
            this.isRef = false;
            if (current instanceof InstanceofExprToken && next instanceof NameToken && previous instanceof VariableExprToken) {
                this.analyzer.getScope().typeInfoOf(previous).addType(this.analyzer.getRealName((NameToken)next, NamespaceUseStmtToken.UseType.CLASS).getName());
            }
        }
        if (current instanceof NameToken && next instanceof StringExprToken && ((NameToken)current).getName().equalsIgnoreCase("b")) {
            ((StringExprToken)next).setBinary(true);
            iterator.next();
            return this.processString((StringExprToken)next);
        }
        if (current instanceof YieldExprToken) {
            return this.processYield(current, next, iterator, closedBraceKind);
        }
        if (current instanceof ImportExprToken) {
            return this.processImport(current, next, iterator, closedBraceKind, braceOpened);
        }
        if (current instanceof PrintNameToken) {
            return this.processPrint(current, next, iterator, closedBraceKind, braceOpened);
        }
        if (current instanceof NewExprToken) {
            return this.processNew(current, closedBraceKind, braceOpened, iterator);
        }
        if (current instanceof DollarExprToken) {
            return this.processVarVar(current, next, iterator);
        }
        if (current instanceof VariableExprToken) {
            this.analyzer.getScope().addVariable((VariableExprToken)current);
            if (this.analyzer.getFunction() != null) {
                this.analyzer.getFunction().setVarsExists(true);
                this.analyzer.getFunction().variable((VariableExprToken)current).setUsed(true);
            }
        }
        if ((current instanceof AssignOperatorExprToken || current instanceof IncExprToken || current instanceof DecExprToken) && previous instanceof VariableExprToken && this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().variable((VariableExprToken)previous).setUnstable(true);
        }
        if (current instanceof AssignExprToken && previous instanceof VariableExprToken && next instanceof VariableExprToken) {
            ExpressionInfo info = this.analyzer.getScope().typeInfoOf(next);
            this.analyzer.getScope().typeInfoOf(previous).addTypes(info.getTypes());
        }
        if (current instanceof ValueIfElseToken) {
            return this.processValueIfElse((ValueIfElseToken)current, next, iterator, closedBraceKind, braceOpened, separator);
        }
        if (current instanceof AmpersandRefToken) {
            this.isRef = true;
            if (next instanceof VariableExprToken && this.analyzer.getFunction() != null) {
                this.analyzer.getFunction().variable((VariableExprToken)next).setReference(true).setMutable(true);
            }
            if (previous instanceof AssignExprToken || previous instanceof KeyValueExprToken || this.canStartByReference && previous == null) {
                if (previous instanceof AssignExprToken) {
                    ((AssignExprToken)previous).setAsReference(true);
                }
                iterator.previous();
                Token token = iterator.previous();
                if (iterator.hasPrevious()) {
                    token = iterator.previous();
                    if (token instanceof VariableExprToken && this.analyzer.getFunction() != null) {
                        this.analyzer.getFunction().variable((VariableExprToken)token).setReference(true).setMutable(true);
                    }
                    iterator.next();
                }
                iterator.next();
                iterator.next();
                if (!(next instanceof ValueExprToken)) {
                    this.unexpectedToken(token);
                }
            } else {
                return new AndExprToken(current.getMeta());
            }
            return current;
        }
        if (previous instanceof AmpersandRefToken && current instanceof VariableExprToken && this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().variable((VariableExprToken)current).setReference(true);
        }
        if (!(!(current instanceof MinusExprToken) && !(current instanceof PlusExprToken) || !(next instanceof IntegerExprToken) && !(next instanceof DoubleExprToken) || previous instanceof ValueExprToken || previous instanceof ArrayGetExprToken || previous instanceof DynamicAccessExprToken || this.isClosedBrace(previous, BraceExprToken.Kind.SIMPLE))) {
            iterator.next();
            if (current instanceof MinusExprToken) {
                if (next instanceof IntegerExprToken) {
                    return new IntegerExprToken(TokenMeta.of(current, next));
                }
                if (next instanceof DoubleExprToken) {
                    return new DoubleExprToken(TokenMeta.of(current, next));
                }
            }
            return next;
        }
        if (!(!(current instanceof MinusExprToken) || previous instanceof ValueExprToken || previous instanceof ArrayGetExprToken || previous instanceof DynamicAccessExprToken || this.isClosedBrace(previous))) {
            return new UnarMinusExprToken(current.getMeta());
        }
        if (current instanceof LogicOperatorExprToken) {
            if (next == null) {
                this.unexpectedToken(current);
            }
            LogicOperatorExprToken logic = (LogicOperatorExprToken)current;
            ExprStmtToken result = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(this.nextToken(iterator), iterator, separator, braceOpened > 0 ? BraceExprToken.Kind.SIMPLE : closedBraceKind);
            logic.setRightValue(result);
            return logic;
        }
        if (next instanceof StaticAccessExprToken) {
            return this.processStaticAccess(next, current, iterator);
        }
        if (current instanceof StaticAccessExprToken) {
            return this.processStaticAccess(current, null, iterator);
        }
        if (current instanceof StringExprToken) {
            return this.processString((StringExprToken)current);
        }
        if (current instanceof NameToken) {
            if (previous instanceof InstanceofExprToken) {
                return this.analyzer.getRealName((NameToken)current, NamespaceUseStmtToken.UseType.CLASS);
            }
            return this.analyzer.getRealName((NameToken)current, NamespaceUseStmtToken.UseType.CONSTANT);
        }
        if (current instanceof MacroToken) {
            return null;
        }
        if (current instanceof OperatorExprToken) {
            return null;
        }
        if (current.isNamedToken()) {
            return this.makeSensitive(current);
        }
        return null;
    }

    protected Token processNewArray(Token current, ListIterator<Token> iterator) {
        BraceExprToken.Kind braceKind;
        Token next;
        ArrayExprToken result = new ArrayExprToken(current.getMeta());
        ArrayList<ExprStmtToken> parameters = new ArrayList<ExprStmtToken>();
        if (this.isOpenedBrace(current, BraceExprToken.Kind.ARRAY)) {
            next = current;
            braceKind = BraceExprToken.Kind.ARRAY;
            result.setShortSyntax(true);
        } else {
            next = this.nextToken(iterator);
            if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
                this.unexpectedToken(next, "(");
            }
            braceKind = BraceExprToken.Kind.SIMPLE;
            result.setShortSyntax(false);
        }
        while (true) {
            SimpleExprGenerator generator = this.analyzer.generator(SimpleExprGenerator.class);
            generator.setCanStartByReference(true);
            Token nextToken = this.nextToken(iterator);
            if (nextToken instanceof CommaToken && result.isShortSyntax()) {
                result.setListSyntax(true);
                parameters.add(null);
                continue;
            }
            ExprStmtToken argument = generator.getToken(nextToken, iterator, Separator.COMMA, braceKind);
            if (argument == null) break;
            parameters.add(argument);
        }
        this.nextToken(iterator);
        result.setParameters(parameters);
        return result;
    }

    protected Token processArrayToken(Token previous, Token current, ListIterator<Token> iterator) {
        ExprStmtToken param;
        Token next;
        BraceExprToken.Kind braceKind = BraceExprToken.Kind.ARRAY;
        Separator separator = Separator.ARRAY;
        if (this.isOpenedBrace(current, BraceExprToken.Kind.BLOCK)) {
            braceKind = BraceExprToken.Kind.BLOCK;
            separator = Separator.ARRAY_BLOCK;
        }
        VariableExprToken var = null;
        if (previous instanceof VariableExprToken && this.analyzer.getFunction() != null) {
            var = (VariableExprToken)previous;
            this.analyzer.getFunction().variable(var).setArrayAccess(true);
        }
        if (this.isClosedBrace(next = this.nextToken(iterator), braceKind)) {
            return new ArrayPushExprToken(TokenMeta.of(current, next));
        }
        iterator.previous();
        ArrayList<ExprStmtToken> parameters = new ArrayList<ExprStmtToken>();
        boolean lastPush = false;
        do {
            Token token;
            if (this.isClosedBrace(token = this.nextToken(iterator), BraceExprToken.Kind.ARRAY)) {
                iterator.previous();
                if (iterator.hasPrevious()) {
                    iterator.previous();
                }
                lastPush = true;
                break;
            }
            param = this.analyzer.generator(SimpleExprGenerator.class).getNextExpression(token, iterator, separator, braceKind);
            if (param == null) continue;
            parameters.add(param);
            if (!iterator.hasNext()) continue;
            iterator.next();
            if (!iterator.hasNext()) break;
            Token tmp = this.nextToken(iterator);
            if (this.isOpenedBrace(tmp, BraceExprToken.Kind.ARRAY)) {
                braceKind = BraceExprToken.Kind.ARRAY;
                separator = Separator.ARRAY;
                continue;
            }
            if (this.isOpenedBrace(tmp, BraceExprToken.Kind.BLOCK)) {
                braceKind = BraceExprToken.Kind.BLOCK;
                separator = Separator.ARRAY_BLOCK;
                continue;
            }
            iterator.previous();
            break;
        } while (param != null);
        ArrayGetExprToken result = new ArrayGetExprToken(current.getMeta());
        result.setParameters(parameters);
        if (this.isRef) {
            result = new ArrayGetRefExprToken(result);
            ((ArrayGetRefExprToken)result).setShortcut(true);
            if (var != null && this.analyzer.getFunction() != null) {
                this.analyzer.getFunction().variable(var).setMutable(true);
            }
        } else if (iterator.hasNext()) {
            next = iterator.next();
            if (next instanceof AssignableOperatorToken || lastPush) {
                result = new ArrayGetRefExprToken(result);
                if (var != null && this.analyzer.getFunction() != null) {
                    this.analyzer.getFunction().variable(var).setMutable(true);
                }
            }
            iterator.previous();
        }
        return result;
    }

    public ExprStmtToken getToken(Token current, ListIterator<Token> iterator, boolean commaSeparator, BraceExprToken.Kind closedBraceKind) {
        return this.getToken(current, iterator, commaSeparator ? Separator.COMMA : Separator.SEMICOLON, closedBraceKind, null);
    }

    public ExprStmtToken getNextExpression(Token current, ListIterator<Token> iterator, BraceExprToken.Kind closedBraceKind) {
        return this.getNextExpression(current, iterator, Separator.COMMA_OR_SEMICOLON, closedBraceKind);
    }

    public ExprStmtToken getNextExpression(Token current, ListIterator<Token> iterator, Separator separator, BraceExprToken.Kind closedBraceKind) {
        ExprStmtToken value = this.getToken(current, iterator, separator, closedBraceKind);
        Token tk = iterator.previous();
        if (!(this.isBreak(tk) || separator != null && separator.is(tk))) {
            iterator.next();
        }
        return value;
    }

    public ExprStmtToken getToken(Token current, ListIterator<Token> iterator, Separator separator, BraceExprToken.Kind closedBraceKind) {
        return this.getToken(current, iterator, separator, closedBraceKind, null);
    }

    public ExprStmtToken getToken(Token current, ListIterator<Token> iterator, Separator separator, BraceExprToken.Kind closedBraceKind, Callback<Boolean, Token> breakCallback) {
        Token next;
        this.isRef = false;
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token previous = null;
        Token token = next = iterator.hasNext() ? iterator.next() : null;
        if (next != null) {
            iterator.previous();
        }
        int braceOpened = 0;
        boolean needBreak = false;
        while (breakCallback == null || current == null || !((Boolean)breakCallback.call((Object)current)).booleanValue()) {
            if (this.isOpenedBrace(current, BraceExprToken.Kind.SIMPLE)) {
                boolean isFunc = false;
                if (previous instanceof NameToken && previous.getMeta().getWord().equalsIgnoreCase("array")) {
                    iterator.previous();
                    current = this.processNewArray(previous, iterator);
                    tokens.set(tokens.size() - 1, current);
                } else {
                    if (previous instanceof NameToken || previous instanceof VariableExprToken || previous instanceof ClosureStmtToken || previous instanceof ArrayGetExprToken || previous instanceof CallExprToken) {
                        isFunc = true;
                    } else if (previous instanceof StaticAccessExprToken) {
                        isFunc = true;
                    } else if (previous instanceof DynamicAccessExprToken) {
                        isFunc = true;
                    }
                    if (isFunc) {
                        CallExprToken call = this.processCall(previous, current, iterator);
                        if (call.getName() != null) {
                            current = call;
                            tokens.set(tokens.size() - 1, call);
                        } else {
                            current = new CallOperatorToken(call);
                            tokens.add(current);
                        }
                    } else {
                        if (needBreak) {
                            this.unexpectedToken(current);
                        }
                        ++braceOpened;
                        tokens.add(current);
                    }
                }
            } else if (braceOpened > 0 && this.isClosedBrace(current, BraceExprToken.Kind.SIMPLE)) {
                --braceOpened;
                tokens.add(current);
                if (this.isOpenedBrace(previous, BraceExprToken.Kind.SIMPLE)) {
                    this.unexpectedToken(current);
                }
            } else if (this.isOpenedBrace(current, BraceExprToken.Kind.ARRAY) || this.isOpenedBrace(current, BraceExprToken.Kind.BLOCK)) {
                if (this.isTokenClass(previous, NameToken.class, VariableExprToken.class, GetVarExprToken.class, CallExprToken.class, ArrayGetExprToken.class, DynamicAccessExprToken.class, StringExprToken.class, StringBuilderExprToken.class, CallOperatorToken.class, ArrayPushExprToken.class) || previous instanceof StaticAccessExprToken && ((StaticAccessExprToken)previous).isGetStaticField()) {
                    current = this.processArrayToken(previous, current, iterator);
                    if (previous instanceof DynamicAccessExprToken && current instanceof ArrayGetRefExprToken) {
                        tokens.set(tokens.size() - 1, new DynamicAccessGetRefExprToken((DynamicAccessExprToken)previous));
                    }
                    tokens.add(current);
                } else if (previous instanceof OperatorExprToken || previous == null || this.isOpenedBrace(previous, BraceExprToken.Kind.SIMPLE) || this.isOpenedBrace(previous, BraceExprToken.Kind.BLOCK)) {
                    int currIndex = iterator.nextIndex() - 1;
                    ArrayExprToken arrToken = (ArrayExprToken)this.processNewArray(current, iterator);
                    boolean nextAssign = this.nextTokenAndPrev(iterator) instanceof AssignExprToken;
                    if (nextAssign) {
                        int doneIndex = iterator.nextIndex();
                        int prevCount = doneIndex - currIndex;
                        for (int i = 0; i < prevCount; ++i) {
                            current = iterator.previous();
                        }
                        iterator.next();
                        tokens.add(this.processList(current, iterator, null, closedBraceKind, braceOpened));
                    } else {
                        if (arrToken.isListSyntax()) {
                            this.unexpectedToken(this.nextToken(iterator), "=");
                        }
                        current = arrToken;
                        tokens.add(current);
                    }
                } else {
                    this.unexpectedToken(current);
                }
            } else if (braceOpened == 0 && this.isClosedBrace(current, BraceExprToken.Kind.ARRAY)) {
                if (separator == Separator.ARRAY) break;
                if (closedBraceKind == BraceExprToken.Kind.ARRAY || closedBraceKind == BraceExprToken.Kind.ANY) {
                    iterator.previous();
                    break;
                }
                this.unexpectedToken(current);
            } else {
                if (separator == Separator.ARRAY_BLOCK && braceOpened == 0 && this.isClosedBrace(current, BraceExprToken.Kind.BLOCK)) break;
                if (current instanceof FunctionStmtToken) {
                    current = this.processClosure(current, next, iterator);
                    tokens.add(current);
                } else if (current instanceof ListExprToken && this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
                    current = this.processList(current, iterator, null, closedBraceKind, braceOpened);
                    tokens.add(current);
                } else if (current instanceof DieExprToken) {
                    this.processDie(current, next, iterator);
                    tokens.add(current);
                } else if (current instanceof EmptyExprToken) {
                    this.processEmpty(current, iterator);
                    tokens.add(current);
                } else if (current instanceof IssetExprToken) {
                    this.processIsset(previous, current, iterator);
                    tokens.add(current);
                } else if (current instanceof UnsetExprToken) {
                    if (this.isOpenedBrace(previous, BraceExprToken.Kind.SIMPLE) && this.isClosedBrace(next, BraceExprToken.Kind.SIMPLE)) {
                        current = new UnsetCastExprToken(current.getMeta());
                        tokens.set(tokens.size() - 1, current);
                        iterator.next();
                        --braceOpened;
                    } else {
                        if (previous != null) {
                            this.unexpectedToken(current);
                        }
                        this.processUnset(previous, current, iterator);
                        tokens.add(current);
                        needBreak = true;
                    }
                } else if (current instanceof CommaToken) {
                    if (separator == Separator.COMMA || separator == Separator.COMMA_OR_SEMICOLON) {
                        if (!tokens.isEmpty()) break;
                        this.unexpectedToken(current);
                        break;
                    }
                    this.unexpectedToken(current);
                } else if (current instanceof AsStmtToken) {
                    if (separator == Separator.AS) break;
                    this.unexpectedToken(current);
                } else {
                    if (this.isClosedBrace(current, closedBraceKind)) {
                        iterator.previous();
                        break;
                    }
                    if (current instanceof BreakToken) break;
                    if (current instanceof ColonToken) {
                        if (separator == Separator.COLON) break;
                        this.unexpectedToken(current);
                    } else {
                        if (current instanceof SemicolonToken) {
                            if (separator == Separator.SEMICOLON || separator == Separator.COMMA_OR_SEMICOLON || separator != Separator.COMMA && closedBraceKind == null && !tokens.isEmpty()) break;
                            this.unexpectedToken(current);
                            break;
                        }
                        if (current instanceof BraceExprToken) {
                            if (closedBraceKind == BraceExprToken.Kind.ANY && this.isClosedBrace(current)) {
                                iterator.previous();
                                break;
                            }
                            this.unexpectedToken(current);
                        } else if (current instanceof ArrayExprToken) {
                            if (needBreak) {
                                this.unexpectedToken(current);
                            }
                            current = this.processNewArray(current, iterator);
                            tokens.add(current);
                        } else if (current instanceof ExprToken) {
                            if (needBreak) {
                                this.unexpectedToken(current);
                            }
                            CastExprToken cast = null;
                            if (current instanceof NameToken && this.isOpenedBrace(previous, BraceExprToken.Kind.SIMPLE) && this.isClosedBrace(next, BraceExprToken.Kind.SIMPLE) && (cast = CastExprToken.valueOf(((NameToken)current).getName(), current.getMeta())) != null) {
                                current = cast;
                                iterator.next();
                                --braceOpened;
                                tokens.set(tokens.size() - 1, current);
                            }
                            if (cast == null) {
                                Token token2 = this.processSimpleToken(current, previous, next, iterator, closedBraceKind, braceOpened, separator);
                                if (token2 != null) {
                                    current = token2;
                                }
                                tokens.add(current);
                            }
                        } else {
                            this.unexpectedToken(current);
                        }
                    }
                }
            }
            previous = current;
            if (iterator.hasNext()) {
                current = this.nextToken(iterator);
                Token token3 = next = iterator.hasNext() ? iterator.next() : null;
                if (next != null) {
                    iterator.previous();
                }
            } else {
                current = null;
            }
            if (current == null) {
                this.nextToken(iterator);
            }
            if (current != null) continue;
        }
        if (tokens.isEmpty()) {
            return null;
        }
        if (braceOpened != 0) {
            this.unexpectedToken(iterator.previous());
        }
        ExprStmtToken exprStmtToken = new ExprStmtToken(this.analyzer.getEnvironment(), this.analyzer.getContext(), tokens);
        return exprStmtToken;
    }

    @Override
    public ExprStmtToken getToken(Token current, ListIterator<Token> iterator) {
        return this.getToken(current, iterator, false, null);
    }

    @Override
    public boolean isAutomatic() {
        return false;
    }
}

