# 📱 Магазин приложений - Holo Ice Cream Sandwich Dark

Веб-приложение для отображения и скачивания APK файлов с официальной темой Holo Ice Cream Sandwich Dark из библиотеки [holo-web](https://github.com/ZMYaro/holo-web).

## 🚀 Возможности

- Автоматическое сканирование APK файлов из папки `apps/`
- **100% использование компонентов Holo** - никаких кастомных стилей
- Адаптивный дизайн для мобильных устройств
- Отображение информации о приложениях (размер, дата, имя файла)
- Прямое скачивание APK файлов
- Статистика количества приложений

## 📁 Структура проекта

```
ANDROID-WEBAPP/
├── index.php                      # Основной файл магазина приложений
├── holo-base-elements.css         # Базовые стили Holo (размеры)
├── holo-ics-dark-elements.css     # Тема ICS Dark (цвета)
├── holo-base-widgets.css          # Базовые виджеты Holo
├── holo-ics-dark-widgets.css      # Виджеты ICS Dark
└── README.md                      # Этот файл
```

## 🛠️ Установка и использование

1. **Разместите APK файлы** в папку `apps/`
2. **Запустите веб-сервер** с поддержкой PHP
3. **Откройте** `index.php` в браузере

### Примеры APK файлов для тестирования:
- `MyApp.apk`
- `Game.apk`
- `Utility.apk`

## 🎨 Тема Holo Ice Cream Sandwich Dark

Приложение использует **исключительно** официальные компоненты Android Holo Ice Cream Sandwich Dark:

### ✅ Используемые компоненты Holo:
- **Action Bar** (`holo-actionBar`) - верхняя и нижняя панели
- **Holo List** (`holo-list`) - нативный список приложений
- **Buttons** - стандартные кнопки Holo
- **Select** - выпадающие списки
- **Radio buttons** - радиокнопки для фильтрации
- **Checkboxes** - чекбоксы для настроек
- **Range sliders** - слайдеры
- **Progress bars** - прогресс-бары
- **Labels** - стандартные подписи

### 🎯 Особенности:
- **Темный градиентный фон** (#000000 → #272D33)
- **Синие акценты** (#33B5E5) - классический цвет ICS
- **Белый текст** на темном фоне
- **Аутентичные стили** всех элементов
- **Поддержка всех Holo виджетов**
- **Шрифт Roboto** по умолчанию
- **Никаких кастомных CSS стилей**

## 📱 Адаптивность

- Поддерживает мобильные устройства
- Нативный Android интерфейс
- Оптимизированные размеры для разных экранов

## 🔧 Требования

- PHP 7.0 или выше
- Веб-сервер с поддержкой PHP (Apache, Nginx, или встроенный PHP сервер)

## 🚀 Быстрый запуск

```bash
# Запуск встроенного PHP сервера
php -S localhost:8000

# Откройте http://localhost:8000 в браузере
```

## 📚 Используемые библиотеки

- **[holo-web](https://github.com/ZMYaro/holo-web)** - CSS библиотека для имитации Android Holo тем
- **Roboto** - Шрифт по умолчанию для Android

## 🎯 Особенности реализации

- **100% Holo компоненты** - интерфейс использует только официальные элементы темы
- **Нативный Android UX** - пользовательский опыт как в нативных приложениях
- **Семантическая HTML** - правильная структура документа
- **Доступность** - поддержка screen readers и клавиатурной навигации
- **Мобильная оптимизация** - мета-теги для мобильных устройств

## 📝 Лицензия

Свободное использование для личных и коммерческих проектов.

## 🙏 Благодарности

- [ZMYaro](https://github.com/ZMYaro) за создание библиотеки holo-web
- Google за дизайн-систему Android Holo

